/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform.total;

import java.util.HashMap;
import java.util.Map;
import oracle.adf.model.dvt.util.transform.total.AggType;
import oracle.adfinternal.model.dvt.util.transform.QDRLite;
import oracle.dss.util.QDR;
import oracle.dss.util.Utility;

public class AggMethod {
    protected QDR m_qdr = null;
    protected QDRLite m_qdrLite = null;
    protected Map<String, AggType> m_layerAggType = new HashMap<String, AggType>();

    public AggMethod(AggType t) {
        this((QDR)null, t);
    }

    public AggMethod(QDR qdr, AggType t) {
        this.m_qdr = qdr;
        this.m_layerAggType = this._getLayerAggMap(t);
    }

    public AggMethod(Map<String, AggType> layerAgg) {
        this((QDR)null, layerAgg);
    }

    public AggMethod(QDR qdr, Map<String, AggType> layerAgg) {
        this.m_qdr = qdr;
        this.m_layerAggType = layerAgg;
    }

    private Map<String, AggType> _getLayerAggMap(AggType t) {
        HashMap<String, AggType> layerAgg = new HashMap<String, AggType>();
        layerAgg.put("dataValue", t);
        return layerAgg;
    }

    public QDR getQDR() {
        return this.m_qdr;
    }

    protected QDRLite getQDRLite() {
        if (this.m_qdrLite == null && this.m_qdr != null) {
            this.m_qdrLite = new QDRLite(this.m_qdr);
        }
        return this.m_qdrLite;
    }

    public Map<String, AggType> getAggTypeMap() {
        return this.m_layerAggType;
    }

    public boolean containsAggType(AggType type) {
        return this.m_layerAggType.values().contains((Object)type);
    }

    public AggType getAggType(String layer) {
        AggType type = this.m_layerAggType.get(layer);
        if (type == null) {
            return this.m_layerAggType.get("dataValue");
        }
        return type;
    }

    public AggType getAggType() {
        return this.getAggType("dataValue");
    }

    public boolean equals(Object obj) {
        if (obj instanceof AggMethod) {
            AggMethod aggMethod = (AggMethod)obj;
            QDRLite qdr = this.getQDRLite();
            return Utility.compareObj(qdr, aggMethod.getQDRLite()) && Utility.compareHashMap((HashMap)this.m_layerAggType, (HashMap)aggMethod.m_layerAggType);
        }
        return false;
    }

    public int hashCode() {
        QDRLite qdr = this.getQDRLite();
        int code = qdr != null ? qdr.hashCode() : 0;
        return code += this.m_layerAggType != null ? this.m_layerAggType.hashCode() : 0;
    }
}

