/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.dvt.util.transform.BaseRowIterator;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.GetMemberInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.ColumnValues;
import oracle.adfinternal.model.dvt.util.transform.Cube;
import oracle.adfinternal.model.dvt.util.transform.DataTable;
import oracle.adfinternal.model.dvt.util.transform.RowInfo;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.adfinternal.model.dvt.util.transform.total.TotalMember;

public class Row
implements Map,
GetMemberInterface {
    private MemberInterface[] m_members = null;
    private DataCellInterface[] m_cells = null;
    private DataTable m_dataTable = null;
    private ColumnValues m_extraMembers = null;
    private ColumnValues m_calcMembers = null;
    private BaseRowIterator m_iter = null;

    public Row(MemberInterface[] members, DataCellInterface[] cells, ColumnValues extraMembers, DataTable dt, BaseRowIterator iter) {
        this.setMembers(members);
        this.setCells(cells);
        this.setExtraMembers(extraMembers);
        this.m_dataTable = dt;
        this.m_iter = iter;
    }

    public Row(DataTable dt) {
        this.m_dataTable = dt;
    }

    public boolean isCustom() throws TransformException {
        for (int i = 0; i < (this.m_members != null ? this.m_members.length : 0); ++i) {
            if (this.m_members[i] == null || this.m_members[i].getValue() != null) continue;
            return true;
        }
        return false;
    }

    public boolean hasCalcColumns() {
        return this.m_calcMembers != null && this.m_calcMembers.getLength() > 0;
    }

    protected Object getCalcColumnValue(String col) throws TransformException {
        if (this.m_calcMembers != null) {
            return this.m_calcMembers.getColumnValue(col);
        }
        return null;
    }

    public boolean isCalcColumn(String col) throws TransformException {
        if (this.hasCalcColumns()) {
            return this.m_calcMembers.hasColumn(col);
        }
        return false;
    }

    public void release() {
        this.m_members = null;
        this.m_cells = null;
        this.m_dataTable = null;
    }

    protected boolean above() {
        return false;
    }

    protected void setLocation(RowInfo[] column, RowInfo[] row, Cube.PageRowInfo pri) {
    }

    protected boolean replace(MemberInterface member, boolean inserting, String colName, Object currMeas, String measDim) throws TransformException {
        return false;
    }

    @Override
    public int hashCode() {
        MemberInterface[] members = this.getMembers();
        int code = 0;
        try {
            ColumnValues cv;
            Object col = null;
            String val = null;
            if (members != null) {
                for (int i = 0; i < members.length; ++i) {
                    if (members[i] == null) continue;
                    col = members[i].getMetadata("memberMetadataColumn");
                    val = members[i].getValue();
                    code += (col != null ? col.hashCode() : 0) + (val != null ? val.hashCode() : 0);
                }
            }
            if ((cv = this.getExtraMembers()) != null) {
                code += cv.hashCode();
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Row)) {
            return false;
        }
        Row row = (Row)obj;
        try {
            MemberInterface[] members = this.getMembers();
            MemberInterface otherMember = null;
            MemberInterface mi1 = null;
            MemberInterface mi2 = null;
            String val1 = null;
            String val2 = null;
            if (members != null) {
                for (int i = 0; i < members.length; ++i) {
                    if (members[i] == null) continue;
                    otherMember = row.getMemberCell((String)members[i].getMetadata("memberMetadataColumn"));
                    if (otherMember == null) {
                        return false;
                    }
                    mi1 = members[i];
                    if (mi1 == null) continue;
                    val1 = mi1.getValue();
                    mi2 = otherMember;
                    if (mi2 == null) {
                        return false;
                    }
                    val2 = mi2.getValue();
                    if (!(val1 == null ? val2 != null : !val1.equals(val2))) continue;
                    return false;
                }
            }
            DataCellInterface[] data = this.getCells();
            DataCellInterface otherCell = null;
            DataCellInterface di1 = null;
            DataCellInterface di2 = null;
            Object dataval1 = null;
            Object dataval2 = null;
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == null) continue;
                    otherCell = row.getCell((String)data[i].getData("dataTypeColumn"));
                    if (otherCell == null) {
                        return false;
                    }
                    di1 = data[i];
                    if (mi1 == null) continue;
                    dataval1 = di1.getData("dataValue");
                    di2 = otherCell;
                    if (di2 == null) {
                        return false;
                    }
                    dataval2 = di2.getData("dataValue");
                    if (!(dataval1 == null ? dataval2 != null : !dataval1.equals(dataval2))) continue;
                    return false;
                }
            }
            if (this.getExtraMembers() != null && !this.getExtraMembers().equals(row.getExtraMembers())) {
                return false;
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return true;
    }

    protected void setCalcColumns(ColumnValues calcCols) {
        this.m_calcMembers = calcCols;
    }

    protected void setExtraMembers(ColumnValues extraMembers) {
        this.m_extraMembers = extraMembers;
    }

    protected ColumnValues getExtraMembers() {
        return this.m_extraMembers;
    }

    protected void setMembers(MemberInterface[] members) {
        this.m_members = members;
    }

    protected void setCells(DataCellInterface[] cells) {
        this.m_cells = cells;
    }

    protected Object clone(DataTable dt) throws CloneNotSupportedException {
        MemberInterface[] newMembers = new MemberInterface[this.m_members.length];
        for (int i = 0; i < newMembers.length; ++i) {
            newMembers[i] = this.m_members[i];
        }
        DataCellInterface[] newCells = null;
        if (this.m_cells != null) {
            newCells = new DataCellInterface[this.m_cells.length];
            for (int i = 0; i < newCells.length; ++i) {
                newCells[i] = this.m_cells[i];
            }
        }
        ColumnValues newExtraMembers = (ColumnValues)(this.m_extraMembers != null ? this.m_extraMembers.clone() : null);
        ColumnValues newCalcColMembers = (ColumnValues)(this.m_calcMembers != null ? this.m_calcMembers.clone() : null);
        Row row = new Row(newMembers, newCells, newExtraMembers, dt, this.m_iter);
        row.setCalcColumns(newCalcColMembers);
        return row;
    }

    public DataCellInterface[] getCells() {
        return this.m_cells;
    }

    public MemberInterface[] getMembers() {
        return this.m_members;
    }

    protected String[] getColumns() {
        return this.m_dataTable.getColumns();
    }

    public Object getValue(String column) throws TransformException {
        MemberInterface mi = this.getMember(column);
        if (mi != null) {
            return mi.getMetadata("value");
        }
        DataCellInterface dc = this.getCell(column);
        if (dc != null) {
            return dc.getData("dataValue");
        }
        if (this.m_calcMembers != null && this.m_calcMembers.hasColumn(column)) {
            return this.m_calcMembers.getColumnValue(column);
        }
        return this.m_iter.getValue(column);
    }

    protected boolean isCalculatedValue() {
        if (this.m_members == null) {
            return false;
        }
        for (int i = 0; i < this.m_members.length; ++i) {
            if (!(this.m_members[i] instanceof TotalMember)) continue;
            return true;
        }
        return false;
    }

    public DataTable getDataTable() {
        return this.m_dataTable;
    }

    protected boolean insertData(DataCellInterface[] cellsToInsert) {
        DataCellInterface[] tempCells;
        if (cellsToInsert.length > this.m_cells.length) {
            int i;
            tempCells = new DataCellInterface[cellsToInsert.length];
            for (i = 0; i < this.m_cells.length; ++i) {
                tempCells[i] = cellsToInsert[i] != null ? cellsToInsert[i] : this.m_cells[i];
            }
            for (i = this.m_cells.length; i < cellsToInsert.length; ++i) {
                this.m_cells[i] = cellsToInsert[i];
            }
        } else {
            boolean inserted = false;
            block2: for (int i = 0; i < cellsToInsert.length; ++i) {
                if (cellsToInsert[i] == null) continue;
                for (int j = 0; j < this.m_cells.length; ++j) {
                    if (this.m_cells[j] != null) continue;
                    inserted = true;
                    this.m_cells[j] = cellsToInsert[i];
                    continue block2;
                }
            }
            return inserted;
        }
        this.m_cells = tempCells;
        return true;
    }

    private boolean _isDataItem(String col, MemberInterface[] dataItems) throws TransformException {
        if (dataItems == null) {
            return false;
        }
        for (int i = 0; i < dataItems.length; ++i) {
            if (dataItems[i] == null || !col.equals(dataItems[i].getValue())) continue;
            return true;
        }
        return false;
    }

    protected boolean membersEqual(Row row, MemberInterface[] dataItems) throws TransformException {
        if (row == null) {
            return false;
        }
        if (this.m_members == null) {
            return row.m_members == null;
        }
        if (row.m_members == null) {
            return false;
        }
        int memberCount = this.m_members.length;
        if (memberCount != row.m_members.length) {
            return false;
        }
        for (int i = 0; i < memberCount; ++i) {
            if (this._isDataItem((String)this.m_members[i].getMetadata("memberMetadataColumn"), dataItems) || row.inMemberList(this.m_members[i])) continue;
            return false;
        }
        int extraMemberCount = this.m_extraMembers.getLength();
        if (extraMemberCount != row.m_extraMembers.getLength()) {
            return false;
        }
        for (int i = 0; i < extraMemberCount; ++i) {
            if (this._isDataItem(this.m_extraMembers.getColumn(i), dataItems) || this.m_extraMembers.isIgnoredColumn(i) || row.inExtraMemberList(this.m_extraMembers.getValue(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean inMemberList(MemberInterface mi) throws TransformException {
        for (int i = 0; i < this.m_members.length; ++i) {
            if (!mi.getValue().equals(this.m_members[i].getValue())) continue;
            return true;
        }
        return false;
    }

    protected boolean inExtraMemberList(Object value) throws TransformException {
        for (int i = 0; i < this.m_extraMembers.getLength(); ++i) {
            if (value == null || !value.equals(this.m_extraMembers.getValue(i))) continue;
            return true;
        }
        return false;
    }

    protected MemberInterface getMember(int i) {
        if (i >= 0 && i < this.m_members.length) {
            return this.m_members[i];
        }
        return null;
    }

    protected DataCellInterface getCell(int i) {
        if (this.m_cells != null && i >= 0 && i < this.m_cells.length) {
            return this.m_cells[i];
        }
        return null;
    }

    protected void setMember(int i, MemberInterface member) {
        if (i < this.m_members.length) {
            this.m_members[i] = member;
        }
    }

    protected void setCell(int i, DataCellInterface cell) {
        if (i < this.m_cells.length) {
            this.m_cells[i] = cell;
        }
    }

    public MemberInterface getMemberCell(String colName) {
        return this.getMember(this.m_dataTable.getMemberIndexFromID(colName));
    }

    @Override
    public MemberInterface getMember(String column) throws TransformException {
        MemberInterface cell = this.getMemberCell(column);
        if (cell != null) {
            return cell;
        }
        return null;
    }

    public Object getExtraMemberValue(String colName) throws TransformException {
        return this.m_extraMembers != null ? this.m_extraMembers.getColumnValue(colName) : null;
    }

    public DataCellInterface getCell(String colName) {
        return this.getCell(this.m_dataTable.getCellIndexFromID(colName));
    }

    @Override
    public int size() {
        return this.getColumns().length;
    }

    @Override
    public boolean isEmpty() {
        return this.getColumns() == null || this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        String[] cols = this.getColumns();
        if (cols == null) {
            return false;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] == null || !cols[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        String[] cols = this.getColumns();
        if (cols == null) {
            return false;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] == null) continue;
            try {
                Object obj = this.getValue(cols[i]);
                if (obj == null || !obj.equals(value)) continue;
                return true;
            }
            catch (TransformException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    public Object get(Object key) {
        try {
            if (key instanceof String) {
                return this.getValue((String)key);
            }
        }
        catch (TransformException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        String[] cols = this.getColumns();
        HashSet s = new HashSet();
        ArrayList<String> collect = new ArrayList<String>();
        if (cols != null) {
            for (int i = 0; i < cols.length; ++i) {
                collect.add(cols[i]);
            }
        }
        return new HashSet(collect);
    }

    public Collection values() {
        String[] cols = this.getColumns();
        ArrayList<Object> collect = new ArrayList<Object>();
        if (cols != null) {
            try {
                for (int i = 0; i < cols.length; ++i) {
                    collect.add(this.getValue(cols[i]));
                }
            }
            catch (TransformException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return collect;
    }

    public Set entrySet() {
        HashSet<AbstractMap.SimpleEntry<String, Object>> entries = new HashSet<AbstractMap.SimpleEntry<String, Object>>();
        String[] cols = this.getColumns();
        if (cols == null) {
            return null;
        }
        try {
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] == null) continue;
                entries.add(new AbstractMap.SimpleEntry<String, Object>(cols[i], this.getValue(cols[i])));
            }
        }
        catch (TransformException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return entries;
    }
}

