/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.Hashtable;
import java.util.Map;
import oracle.adf.model.dvt.util.transform.BaseProjection;
import oracle.adf.model.dvt.util.transform.CommonTreeProjection;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.EdgeTreeProjection;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.TreeNode;
import oracle.adfinternal.model.dvt.util.transform.CommonTreeBasedCubicDataAccess;
import oracle.adfinternal.model.dvt.util.transform.CubeImpl;
import oracle.adfinternal.model.dvt.util.transform.InsertableTreeDataAccess;
import oracle.adfinternal.model.dvt.util.transform.PageInfo;
import oracle.adfinternal.model.dvt.util.transform.StackPack;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.adfinternal.model.dvt.util.transform.TreeBasedEdgeTree;
import oracle.dss.util.EdgeOutOfRangeException;

public class EdgeTreeBasedCubicDataAccess
extends CommonTreeBasedCubicDataAccess
implements InsertableTreeDataAccess {
    protected CommonTreeProjection[] m_projection = null;
    protected StackPack[] m_stackPack = null;

    public EdgeTreeBasedCubicDataAccess(EdgeTreeProjection[] projection) throws TransformException {
        this.initEdgeTreeBased(projection, this.m_alwaysAdd);
    }

    protected EdgeTreeBasedCubicDataAccess() throws TransformException {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EdgeTreeBasedCubicDataAccess da = (EdgeTreeBasedCubicDataAccess)super.clone();
        da.setLayerEdge((Hashtable)this.getLayerEdge().clone());
        if (this.m_stackPack != null) {
            da.m_stackPack = new StackPack[this.m_stackPack.length];
            for (int i = 0; i < this.m_stackPack.length; ++i) {
                if (this.m_stackPack[i] == null) continue;
                da.m_stackPack[i] = (StackPack)this.m_stackPack[i].clone();
            }
        }
        return da;
    }

    private void initEdgeTreeBased(EdgeTreeProjection[] projection, boolean[] alwaysAdd) throws TransformException {
        this.m_cube = new CubeImpl(new PageInfo(true));
        this.initCaches();
        this.m_projection = new EdgeTreeProjection[projection.length];
        this.m_stackPack = new StackPack[projection.length];
        for (int e = 0; e < projection.length; ++e) {
            TreeNode nodes;
            this.m_projection[e] = projection[e].getDataItems() != null ? new ImpliedMeasureEdgeTreeProjection(projection[e]) : projection[e];
            if (projection[e] == null || (nodes = this.m_projection[e].getNodeTree()) == null) continue;
            if (this.m_stackPack[e] == null) {
                this.m_stackPack[e] = new StackPack();
            }
            this.buildTree(nodes, this.m_stackPack[e], e, -1L, null, alwaysAdd);
        }
        this.m_cube.lockTrees();
    }

    @Override
    protected LayerInterface getDataLayerInterface() {
        for (int e = 0; e < this.m_projection.length; ++e) {
            if (this.m_projection[e] == null) continue;
            return this.m_projection[e].getDataLayer();
        }
        return null;
    }

    @Override
    protected BaseProjection getProjection() {
        for (int e = 0; e < this.m_projection.length; ++e) {
            if (this.m_projection[e] == null) continue;
            return this.m_projection[e];
        }
        return null;
    }

    protected TreeBasedEdgeTree getEdgeTree(int edge) throws TransformException {
        BaseProjection proj = this.getProjection();
        return new TreeBasedEdgeTree(this._getLayers(edge), edge, proj, proj.getDataLayer().getValue(), TransformUtils.getMeasList(proj), this.isNoCollapsedLeaves(edge), -1L, this);
    }

    private boolean isNoCollapsedLeaves(int edge) {
        if (this.m_projection[edge] instanceof EdgeTreeProjection) {
            return ((EdgeTreeProjection)this.m_projection[edge]).isNoCollapseLeaves();
        }
        return true;
    }

    @Override
    protected TreeBasedEdgeTree getEdgeTree(TreeNode node, long slice, boolean checked) throws TransformException {
        int edge = this.getEdgeForLayer(node);
        TreeBasedEdgeTree et = null;
        try {
            et = (TreeBasedEdgeTree)super.getEdgeTree(edge, slice, checked);
        }
        catch (EdgeOutOfRangeException e) {
            throw new TransformException(e.getMessage(), e);
        }
        if (et == null) {
            et = this.getEdgeTree(edge);
            this.m_cube.setEdgeTree(edge, et, this.getCurrentPage());
        }
        return et;
    }

    private class ImpliedMeasureEdgeTreeProjection
    extends CommonTreeBasedCubicDataAccess.ImpliedMeasureCommonTreeProjection
    implements EdgeTreeProjection {
        private final EdgeTreeProjection m_proj;
        private final CommonTreeBasedCubicDataAccess.ImpliedMeasureTreeNode m_node;

        public ImpliedMeasureEdgeTreeProjection(EdgeTreeProjection proj) {
            super(proj);
            this.m_proj = proj;
            this.m_node = new CommonTreeBasedCubicDataAccess.ImpliedMeasureTreeNode(this.m_proj.getNodeTree(), this);
        }

        @Override
        protected int findBottom() throws TransformException {
            String[][] layout = this.m_proj.getLayout();
            if (layout == null) {
                return -1;
            }
            return this.walkTree(layout, this.m_proj.getNodeTree());
        }

        @Override
        protected int getNewLength(String[][] origLayout) {
            return origLayout.length;
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_proj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_proj.getDataItems();
        }

        @Override
        public DataCellInterface getData(Map<String, Object> keyPath) {
            return this.m_proj.getData(keyPath);
        }

        @Override
        public TreeNode getNodeTree() {
            return this.m_node;
        }

        @Override
        public boolean isNoCollapseLeaves() {
            return true;
        }
    }
}

