/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adf.model.dvt.util.transform.BaseProjection;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.RowIterator;
import oracle.adf.model.dvt.util.transform.RowProjection;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.total.AggType;
import oracle.adfinternal.model.dvt.util.transform.Cache;
import oracle.adfinternal.model.dvt.util.transform.CommonComparator;
import oracle.adfinternal.model.dvt.util.transform.ComparatorInterface;
import oracle.adfinternal.model.dvt.util.transform.CubeImpl;
import oracle.adfinternal.model.dvt.util.transform.CubicDataAccess;
import oracle.adfinternal.model.dvt.util.transform.DataAccessLong;
import oracle.adfinternal.model.dvt.util.transform.DeleteChanges;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeChildren;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeImpl;
import oracle.adfinternal.model.dvt.util.transform.EdgeTreeNodeImpl;
import oracle.adfinternal.model.dvt.util.transform.GetSlice;
import oracle.adfinternal.model.dvt.util.transform.LayerAndMember;
import oracle.adfinternal.model.dvt.util.transform.LayerMetadataCacheKey;
import oracle.adfinternal.model.dvt.util.transform.LayerMetadataCacheKeyPool;
import oracle.adfinternal.model.dvt.util.transform.MemberCacheKey;
import oracle.adfinternal.model.dvt.util.transform.MemberCacheKeyPool;
import oracle.adfinternal.model.dvt.util.transform.MemberMetadataCacheKey;
import oracle.adfinternal.model.dvt.util.transform.MemberMetadataCacheKeyPool;
import oracle.adfinternal.model.dvt.util.transform.MetadataWriteback;
import oracle.adfinternal.model.dvt.util.transform.QDRCacheKey;
import oracle.adfinternal.model.dvt.util.transform.QDRLite;
import oracle.adfinternal.model.dvt.util.transform.ResultTable;
import oracle.adfinternal.model.dvt.util.transform.ResultTableInsert;
import oracle.adfinternal.model.dvt.util.transform.TabularDataAccess;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.adfinternal.model.dvt.util.transform.UpdateChanges;
import oracle.adfinternal.model.dvt.util.transform.WriteableMemberInterface;
import oracle.adfinternal.model.dvt.util.transform.hPosDataCacheKey;
import oracle.adfinternal.model.dvt.util.transform.hPosDataCacheKeyPool;
import oracle.adfinternal.model.dvt.util.transform.hPosMetadataCacheKey;
import oracle.adfinternal.model.dvt.util.transform.hPosMetadataCacheKeyPool;
import oracle.adfinternal.model.dvt.util.transform.total.AggMethod;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;

abstract class CubicDataAccessImpl
extends TabularDataAccess
implements CubicDataAccess,
DataAccessLong,
MetadataWriteback {
    protected hPosDataCacheKeyPool m_keyPool = null;
    protected MemberCacheKeyPool m_memberKeyPool = null;
    protected MemberMetadataCacheKeyPool m_metadataKeyPool = null;
    protected hPosMetadataCacheKeyPool m_hPosMetadataKeyPool = null;
    protected LayerMetadataCacheKeyPool m_layerMetadataKeyPool = null;
    protected Map<String, Object> m_cubeValueCache = new HashMap<String, Object>();
    protected SortList m_pageSorts = new SortList();
    protected boolean m_qdrCaching = false;
    protected boolean[] m_alwaysAdd = null;
    protected boolean m_keepNulls = false;

    protected CubicDataAccessImpl() throws TransformException {
        this(null);
    }

    public CubicDataAccessImpl(ResultTable rt) throws TransformException {
        super(rt);
    }

    protected CubicDataAccessImpl(ResultTable rt, boolean qdrCaching) throws TransformException {
        super(rt);
        this.m_qdrCaching = qdrCaching;
    }

    @Override
    protected void clearCaches(boolean clearMemberCache, boolean clearQDRCache) {
        super.clearCaches(clearMemberCache, clearQDRCache);
        this.m_cubeValueCache.clear();
    }

    @Override
    protected void initCaches() {
        super.initCaches();
        this.m_keyPool = new hPosDataCacheKeyPool(10);
        this.m_memberKeyPool = new MemberCacheKeyPool(10);
        this.m_metadataKeyPool = new MemberMetadataCacheKeyPool(10);
        this.m_hPosMetadataKeyPool = new hPosMetadataCacheKeyPool(10);
        this.m_layerMetadataKeyPool = new LayerMetadataCacheKeyPool(10);
    }

    public void setCaching(boolean caching) {
        this.m_caching = caching;
    }

    @Override
    public synchronized void release() {
        this.m_memberKeyPool = null;
        this.m_keyPool = null;
        this.m_metadataKeyPool = null;
        this.m_hPosMetadataKeyPool = null;
        this.m_layerMetadataKeyPool = null;
        this.m_pageSorts = null;
        super.release();
    }

    private int getOppositeEdge(int edge) {
        return edge == 0 ? 1 : 0;
    }

    @Override
    public boolean sort(int edge, QDRInterface qdr, int sortDirection, boolean nullsFirst, boolean group) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (TransformUtils.isLayerQDR(qdr)) {
            int layer = TransformUtils.getLayerFromLayerQDR(this.getLayout(), edge, qdr);
            return this.sort(edge, layer, -1, qdr, sortDirection, nullsFirst, group);
        }
        int oppositeEdge = this.getOppositeEdge(edge);
        int[] slices = this.getSlicesFromQDR(qdr, null, null);
        if (slices[oppositeEdge] > -1) {
            return this.sort(edge, slices[oppositeEdge], sortDirection, nullsFirst, group);
        }
        return false;
    }

    @Override
    public boolean sort(int edge, int slice, int sortDirection, boolean nullsFirst, boolean group) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            return this.sort(edge, -1, slice, null, sortDirection, nullsFirst, group);
        }
        catch (LayerOutOfRangeException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    private boolean sort(int edge, int sortLayer, int slice, QDRInterface qdr, int sortDirection, boolean nullsFirst, boolean group) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (slice == -3) {
            slice = this.getEdgeExtent(this.getOppositeEdge(edge)) - 1;
        } else if (slice == -2) {
            slice = 0;
        }
        if (sortLayer == -1 && (slice < 0 || slice >= this.getEdgeExtent(this.getOppositeEdge(edge)))) {
            return false;
        }
        boolean cacheSetting = this.m_caching;
        this.m_caching = false;
        int edgeExtent = this.getEdgeExtent(edge);
        if (group) {
            this.clearCaches(false, true);
            try {
                EdgeTreeImpl et = this.getEdgeTree(edge, 0L, true);
                if (et == null) {
                    this.m_caching = cacheSetting;
                    boolean bl = false;
                    return bl;
                }
                int layer = sortLayer > -1 ? sortLayer - 1 : et.getLayerCount() - 2;
                long currSlice = 0L;
                if (layer < -1) {
                    this.m_caching = cacheSetting;
                    boolean bl = false;
                    return bl;
                }
                EdgeTreeNodeImpl node = null;
                try {
                    node = layer == -1 ? et.getRoot() : et.getNode(layer, currSlice, GetSlice.GET_ALL_SLICES);
                }
                catch (SliceOutOfRangeException e) {
                    this.m_caching = cacheSetting;
                    boolean bl = false;
                    this.m_caching = cacheSetting;
                    return bl;
                }
                EdgeTreeChildren children = null;
                while (node != null && currSlice < (long)edgeExtent) {
                    children = node.getModifiableChildren();
                    if (children != null) {
                        children.sort(sortDirection, nullsFirst, this, edge, sortLayer, slice);
                        if (edge > 1) {
                            node.unlock();
                        } else {
                            node.clearSpan();
                            node.clearStart();
                        }
                    }
                    if (layer > -1 && (currSlice += node.getSpan()) < (long)edgeExtent) {
                        node = et.getNode(layer, currSlice, GetSlice.GET_ALL_SLICES);
                        continue;
                    }
                    node = null;
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            finally {
                this.m_caching = cacheSetting;
            }
        }
        SortTuple[] newRows = new SortTuple[edgeExtent];
        for (long s = 0L; s < (long)edgeExtent; ++s) {
            newRows[(int)s] = this._getSortTuple(edge, sortLayer, s, slice);
        }
        if (newRows.length > 0) {
            Arrays.sort(newRows, new CommonComparator(sortDirection, nullsFirst));
        }
        this.clearCaches(false, true);
        try {
            boolean[] alwaysAdd = new boolean[edge > 1 ? edge + 1 : 2];
            if (edge < 2) {
                alwaysAdd[edge] = true;
            }
            MyRowProjection proj = new MyRowProjection(this.getProjection(), newRows, edge);
            ResultTable rt = new ResultTable(proj, null, this.m_rt != null && this.m_rt.getDataTable() != null ? this.m_rt.getDataTable().getFilters() : null, true);
            EdgeTreeImpl et = this.getEdgeTree(edge, 0L, true);
            if (et != null) {
                et.clearNodes();
            }
            Cache cache = new Cache(this.m_memberKeyPool, this.m_memberCache, this.m_qdrCaching);
            this.m_cube.walkData(new ResultTableInsert(rt, null), cache, this.getCurrentPage(), alwaysAdd, this.m_keepNulls, false, null);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        finally {
            this.m_caching = cacheSetting;
        }
        this.m_caching = cacheSetting;
        if (this.m_pageSorts != null && edge < 2) {
            this.m_pageSorts.add(edge, qdr == null && slice > -1 ? this.getSliceQDR(this.getOppositeEdge(edge), slice, 0) : null, sortDirection, nullsFirst, group);
        }
        return true;
    }

    @Override
    public boolean reorder(int edge, int layer, int sliceToMove, int sliceToMoveTo, int moveType) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        block22: {
            if (edge > 1) {
                return false;
            }
            int edgeExtent = this.getEdgeExtent(edge);
            if (sliceToMove == -3) {
                sliceToMove = edgeExtent - 1;
            } else if (sliceToMove == -2) {
                sliceToMove = 0;
            }
            if (sliceToMoveTo == -3) {
                sliceToMoveTo = edgeExtent - 1;
            } else if (sliceToMoveTo == -2) {
                sliceToMoveTo = 0;
            }
            if (layer == -1 || sliceToMove < 0 || sliceToMove >= edgeExtent) {
                return false;
            }
            if (sliceToMoveTo < 0 || sliceToMoveTo >= edgeExtent) {
                return false;
            }
            boolean cacheSetting = this.m_caching;
            this.m_caching = false;
            this.clearCaches(false, true);
            try {
                EdgeTreeImpl et = this.getEdgeTree(edge, 0L, true);
                if (et == null) {
                    this.m_caching = cacheSetting;
                    boolean bl = false;
                    return bl;
                }
                EdgeTreeNodeImpl nodeToMove = et.getNode(layer, (long)sliceToMove, GetSlice.GET_ALL_SLICES);
                EdgeTreeNodeImpl nodeToMoveTo = et.getNode(layer, (long)sliceToMoveTo, GetSlice.GET_ALL_SLICES);
                if (nodeToMove != null && nodeToMoveTo != null && nodeToMove.getParent() == nodeToMoveTo.getParent()) {
                    EdgeTreeNodeImpl parent = nodeToMove.getParentInternal();
                    EdgeTreeChildren children = parent.getModifiableChildren();
                    switch (moveType) {
                        case 2: {
                            children.moveAfter(nodeToMove, nodeToMoveTo);
                            break;
                        }
                        case 1: {
                            children.moveBefore(nodeToMove, nodeToMoveTo);
                            break;
                        }
                        case 3: {
                            children.swap(nodeToMove, nodeToMoveTo);
                        }
                    }
                    break block22;
                }
                this.m_caching = cacheSetting;
                boolean bl = false;
                return bl;
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            finally {
                this.m_caching = cacheSetting;
            }
        }
        return true;
    }

    @Override
    public synchronized void setCurrentPosition(int edge, long pos) throws TransformException {
        if (!super._internalSetCurrentPosition(edge, pos)) {
            return;
        }
        try {
            if (this.m_pageSorts != null) {
                this.m_pageSorts.sort();
            }
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private SortTuple _getSortTuple(int edge, int layer, long row, long slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            Object dataVal = null;
            dataVal = layer == -1 ? (edge == 0 ? this.getValue(slice, row, "dataValue") : this.getValue(row, slice, "dataValue")) : this.getMemberMetadata(edge, layer, row, "sortAttribute");
            return new SortTuple(this._getMemberInterface(edge, row), dataVal);
        }
        catch (ColumnOutOfRangeException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        catch (RowOutOfRangeException e2) {
            throw new SliceOutOfRangeException(e2.getMessage(), e2);
        }
        catch (TransformException e3) {
            throw new TransformRuntimeException(e3.getMessage(), e3);
        }
    }

    private MemberInterface[] _getMemberInterface(int edge, long slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, TransformException {
        EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
        if (et != null) {
            return et.getMembers(slice);
        }
        return new MemberInterface[0];
    }

    @Override
    protected EdgeTreeImpl getEdgeTree(int edge, long slice, boolean checked) throws EdgeOutOfRangeException, TransformException {
        if (checked && edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount());
        }
        this.updateTree(edge, slice, null);
        return this.m_cube == null ? null : this.m_cube.getEdgeTree(edge, this.getCurrentPage());
    }

    private boolean hasData() {
        return this.m_dataItems != null && this.m_dataItems.size() > 0;
    }

    protected void updateTree(int edge, long slice, EdgeTreeNodeImpl currNode) throws TransformException {
    }

    private long getExtent(EdgeTreeImpl et) throws TransformException {
        if (et == null || et.getLayerCount() == 0 && this.hasData()) {
            return 1L;
        }
        return et.getExtent();
    }

    @Override
    public synchronized long getEdgeExtentLong(int edge) throws EdgeOutOfRangeException {
        if (this.m_cube == null) {
            return 0L;
        }
        try {
            EdgeTreeImpl et = null;
            switch (edge) {
                case 0: {
                    et = this.m_cube.getColumnEdgeTree(this.getCurrentPage());
                    return this.getExtent(et);
                }
                case 1: {
                    et = this.m_cube.getRowEdgeTree(this.getCurrentPage());
                    return this.getExtent(et);
                }
            }
            return super._getEdgeExtentLong(edge);
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized long getAbsoluteFromContext(int edge, long[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                boolean nullHPos = hPos == null || hPos.length == 0;
                EdgeTreeNodeImpl node = et.getNode(hPos, memberLayer, !nullHPos ? hPos[memberLayer] : 0L);
                return node != null ? node.getStart(GetSlice.GET_ALL_SLICES, -1L) : 0L;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 0L;
    }

    @Override
    public synchronized long getMemberSiblingCount(int edge, long[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                EdgeTreeNodeImpl node;
                boolean nullHPos = hPos == null || hPos.length == 0;
                long hIndex = 0L;
                if (!nullHPos) {
                    hIndex = memberLayer < hPos.length ? hPos[memberLayer] : 0L;
                }
                return (node = et.getNode(hPos, memberLayer, hIndex)) != null ? ((EdgeTreeNodeImpl)node.getParent()).getChildCount() : 0L;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1L;
    }

    @Override
    public synchronized long[] getMemberHPos(int edge, int layer, long slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                EdgeTreeNodeImpl node = et.getNode(layer, slice, GetSlice.GET_ALL_SLICES);
                return node.getHPos();
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return new long[0];
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, long[] hPos, int memberLayer, long hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("extent")) {
            long slice = this.getAbsoluteFromContext(edge, hPos, memberLayer);
            return this.getMemberExtent(edge, memberLayer, (int)slice);
        }
        if (type.equals("startSlice")) {
            long slice = this.getAbsoluteFromContext(edge, hPos, memberLayer);
            return this.getMemberStartSlice(edge, memberLayer, (int)slice);
        }
        hPosMetadataCacheKey cacheKey = null;
        QDRCacheKey qdrCacheKey = null;
        MemberInterface[][] pageSet = null;
        boolean qdrCachingSetting = this.m_qdrCaching;
        if (this.m_caching) {
            try {
                pageSet = this.wrapMembers(this.getPageSet());
                cacheKey = this.m_hPosMetadataKeyPool.getCacheKeyFromPool(pageSet, edge, hPos, memberLayer, hIndex, type);
                Object objResult = this.m_memberMetadataCache.get(cacheKey);
                if (objResult != null) {
                    this.m_hPosMetadataKeyPool.returnCacheKeyToPool(cacheKey);
                    Object var12_15 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                    return var12_15;
                }
                if (this.m_qdrCaching) {
                    this.m_qdrCaching = false;
                    QDRLite qdr = TransformUtils.getMemberQDRLiteImpl(this.getLayout(), this.getDataLayer(), this, edge, hPos, memberLayer, hIndex, 1);
                    this.m_qdrCaching = qdrCachingSetting;
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(qdr);
                    objResult = this.m_qdrCache.get(qdrCacheKey, type);
                    if (objResult != null) {
                        this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
                        this.storeMetadata(objResult, cacheKey, null, null);
                        Object var13_17 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                        return var13_17;
                    }
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            finally {
                this.m_qdrCaching = qdrCachingSetting;
            }
        }
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                Object objResult = this.getMemberMetadata(et.getNode(hPos, memberLayer, hIndex), type);
                this.storeMetadata(objResult, cacheKey, qdrCacheKey, type);
                Object object = objResult;
                return object;
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        finally {
            this.m_qdrCaching = qdrCachingSetting;
        }
        return null;
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, int layer, long slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("extent")) {
            return this.getMemberExtent(edge, layer, (int)slice);
        }
        if (type.equals("startSlice")) {
            return this.getMemberStartSlice(edge, layer, (int)slice);
        }
        MemberMetadataCacheKey cacheKey = null;
        QDRCacheKey qdrCacheKey = null;
        MemberInterface[][] pageSet = null;
        boolean qdrCachingSetting = this.m_qdrCaching;
        if (this.m_caching) {
            try {
                pageSet = this.wrapMembers(this.getPageSet());
                cacheKey = this.m_metadataKeyPool.getCacheKeyFromPool(pageSet, edge, layer, slice, type);
                Object objResult = this.m_memberMetadataCache.get(cacheKey);
                if (objResult != null) {
                    this.m_metadataKeyPool.returnCacheKeyToPool(cacheKey);
                    Object var11_12 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                    return var11_12;
                }
                if (this.m_qdrCaching) {
                    this.m_qdrCaching = false;
                    QDRLite qdr = TransformUtils.getMemberQDRLiteImpl(this.getLayout(), this.getDataLayer(), this, edge, layer, slice, 1);
                    this.m_qdrCaching = qdrCachingSetting;
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(qdr);
                    objResult = this.m_qdrCache.get(qdrCacheKey, type);
                    if (objResult != null) {
                        this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
                        this.storeMetadata(objResult, cacheKey, null, null);
                        Object var12_14 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                        return var12_14;
                    }
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            finally {
                this.m_qdrCaching = qdrCachingSetting;
            }
        }
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                AggMethod[] objResult = this.getMemberMetadata(et.getNode(layer, slice, GetSlice.GET_TO_SLICE), type);
                if (type.equals("aggType") && objResult == null) {
                    objResult = new AggMethod[]{new AggMethod(AggType.NONE)};
                }
                this.storeMetadata((Object)objResult, cacheKey, qdrCacheKey, type);
                AggMethod[] aggMethodArray = objResult;
                return aggMethodArray;
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        finally {
            this.m_qdrCaching = qdrCachingSetting;
        }
        return null;
    }

    @Override
    public synchronized long getEdgeCurrentSliceLong(int edge) throws EdgeOutOfRangeException {
        if (edge >= 2) {
            return super.getEdgeCurrentSlice(edge);
        }
        return 0L;
    }

    @Override
    public synchronized Object getValue(long row, long column, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        if ("dataCubeMax".equals(type) || "dataCubeMin".equals(type)) {
            try {
                return TransformUtils.getValueForAllMeasureCells(this.m_cubeValueCache, this, this.getLayout(), this.getDataLayer(), row, column, type);
            }
            catch (Exception e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        boolean qdrCachingSetting = this.m_qdrCaching;
        try {
            hPosDataCacheKey cacheKey = null;
            MemberInterface[][] pageSet = null;
            QDRCacheKey qdrCacheKey = null;
            if (this.m_caching) {
                pageSet = this.wrapMembers(this.getPageSet());
                cacheKey = this.m_keyPool.getCacheKeyFromPool(pageSet, row, column, type);
                Object objResult = this.m_dataCache.get(cacheKey);
                if (objResult != null) {
                    this.m_keyPool.returnCacheKeyToPool(cacheKey);
                    Object var11_11 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                    return var11_11;
                }
                if (this.m_qdrCaching) {
                    this.m_qdrCaching = false;
                    QDRLite qdr = TransformUtils.getValueQDRLiteImpl(this.getLayout(), this.getDataLayer(), this, row, column, 1);
                    this.m_qdrCaching = qdrCachingSetting;
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(qdr);
                    DataCellInterface cellInt = (DataCellInterface)this.m_qdrDataCache.get(qdrCacheKey);
                    if (cellInt != null) {
                        this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
                        objResult = cellInt.getData(TransformUtils.convertDataMap(type));
                        this.storeData(objResult, cacheKey, null, null);
                        Object var13_14 = objResult instanceof TransformUtils.NullMarker ? null : objResult;
                        return var13_14;
                    }
                }
                if (this.m_clone) {
                    Object var11_12 = null;
                    return var11_12;
                }
            }
            Object object = this.getResultAndCache(cacheKey, row, column, type, qdrCacheKey, false, null);
            return object;
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        finally {
            this.m_qdrCaching = qdrCachingSetting;
        }
    }

    @Override
    public synchronized UpdateChanges setMetadataValues(QDRInterface[] locations, String[] layer, Map<String, Object>[] metadata) {
        if (locations == null || locations.length == 0 || layer == null || layer.length != locations.length) {
            return null;
        }
        UpdateChanges changes = new UpdateChanges();
        boolean qdrCachingSetting = this.m_qdrCaching;
        try {
            if (this.m_caching) {
                String type = null;
                Map<String, Object> val = null;
                Iterator<String> types = null;
                for (int i = 0; i < locations.length; ++i) {
                    int[] edgeLayer;
                    if (metadata != null && metadata.length <= i) {
                        UpdateChanges updateChanges = null;
                        return updateChanges;
                    }
                    int[][] slices = this._getSlicesFromQDR(locations[i], null, null, null, false, true);
                    if (slices == null || (edgeLayer = TransformUtils.getLayerAndEdge(layer[i], this.getLayout())) == null || edgeLayer.length <= 1) continue;
                    int edge = edgeLayer[0];
                    for (int s = 0; s < slices[edge].length; ++s) {
                        val = metadata[i];
                        types = val.keySet().iterator();
                        boolean updated = false;
                        DeleteChanges.Positions pos = null;
                        while (types.hasNext()) {
                            type = types.next();
                            if (!this._setMemberMetadata(edge, edgeLayer[1], slices[edge][s], type, val.get(type), qdrCachingSetting, false)) continue;
                            pos = new DeleteChanges.Positions(edge, edgeLayer[1], slices[edge][s]);
                            updated = true;
                        }
                        if (!updated) continue;
                        changes.addChange(TransformUtils.createMapQDR(locations[i]), pos, val);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        finally {
            this.m_qdrCaching = qdrCachingSetting;
        }
        return changes;
    }

    @Override
    public UpdateChanges setValues(QDRInterface[] locations, Map<String, Object>[] values) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        QDRLite[] liteLocs = new QDRLite[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            liteLocs[i] = new QDRLite(locations[i]);
        }
        UpdateChanges changes = new UpdateChanges();
        try {
            hPosDataCacheKey cacheKey = null;
            QDRCacheKey qdrCacheKey = null;
            if (this.m_caching) {
                String type = null;
                Map<String, Object> val = null;
                Iterator<String> types = null;
                for (int i = 0; i < liteLocs.length; ++i) {
                    if (values != null && values.length <= i) {
                        return null;
                    }
                    int[][] slices = this._getSlicesFromQDR(locations[i], null, null, null, true, false);
                    if (slices != null) {
                        val = values[i];
                        types = val.keySet().iterator();
                        HashMap<String, Object> cellMap = new HashMap<String, Object>();
                        DeleteChanges.Positions pos = new DeleteChanges.Positions(slices.length > 1 && slices[1].length > 0 ? (long)(slices[1][0] == -1 ? 0 : slices[1][0]) : -1L, slices.length > 0 && slices[0].length > 0 ? (long)(slices[0][0] == -1 ? 0 : slices[0][0]) : -1L);
                        while (types.hasNext()) {
                            type = types.next();
                            cacheKey = this.m_keyPool.getCacheKeyFromPool(this.wrapMembers(this.getPageSet()), pos.getRow(), pos.getColumn(), type);
                            Object value = val.get(type);
                            this.m_dataCache.remove(cacheKey);
                            qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(liteLocs[i]);
                            cellMap.put(type, value);
                            this.storeData(value, cacheKey, qdrCacheKey, type);
                        }
                        changes.addChange(TransformUtils.createMapQDR(locations[i]), pos, cellMap);
                    }
                    if (this.m_realQDRs.contains(liteLocs[i])) continue;
                    this.m_realQDRs.add((QDRLite)liteLocs[i].clone());
                }
            }
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return changes;
    }

    @Override
    public synchronized void invalidate(QDRInterface[] qdr) {
        if (qdr == null || qdr.length == 0) {
            return;
        }
        super.invalidate(qdr);
    }

    @Override
    public boolean healthCheck() throws Exception {
        boolean isCaching = this.m_caching;
        try {
            this.m_caching = false;
            if (this.getEdgeExtent(0) > 0 && this.getEdgeExtent(1) > 0) {
                Object object = this.getValue(0, 0, "healthCheckUncachedDataValue");
            }
            this.m_caching = isCaching;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.m_caching = isCaching;
        }
        finally {
            this.m_caching = isCaching;
        }
        return false;
    }

    protected Object processResult(Object objResult, String type, hPosDataCacheKey cacheKey, MemberCacheKey memberKey, QDRCacheKey qdrCacheKey, boolean storeInMemberCache, Object newValue) {
        DataCellInterface cell = null;
        if (objResult instanceof TransformUtils.NullMarker || objResult == null) {
            if (type.equals("aggType")) {
                return AggType.NONE.toString();
            }
            cell = null;
            objResult = null;
        } else {
            cell = (DataCellInterface)objResult;
            try {
                if (type.equals("aggType")) {
                    Object isTotalObj = cell.getData("dataIsTotal");
                    if (isTotalObj instanceof Boolean) {
                        if (!((Boolean)isTotalObj).booleanValue()) {
                            return AggType.NONE.toString();
                        }
                    } else {
                        return AggType.NONE.toString();
                    }
                }
                if (newValue != null) {
                    this.writeToCell(newValue, cell, type);
                }
                objResult = cell.getData(TransformUtils.convertDataMap(type));
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        this.storeData(objResult, cacheKey, qdrCacheKey, type);
        if (storeInMemberCache && (this.isLocalStorage() || memberKey != null && memberKey.isCalculatedValue())) {
            this.m_cube.storeData(cell, memberKey, this.m_memberCache);
        }
        return objResult;
    }

    protected MemberInterface[][] wrapMembers(LayerAndMember[] pageSet) throws TransformException {
        MemberInterface[][] wrappedPage = null;
        if (pageSet != null) {
            wrappedPage = new MemberInterface[pageSet.length][];
            for (int i = 0; i < wrappedPage.length; ++i) {
                if (pageSet[i] == null) continue;
                wrappedPage[i] = pageSet[i].getMembers();
            }
        }
        return wrappedPage;
    }

    protected Object getResultAndCache(hPosDataCacheKey cacheKey, long row, long column, String type, QDRCacheKey qdrCacheKey, boolean storeInMemberCache, Object newValue) throws EdgeOutOfRangeException, SliceOutOfRangeException, TransformException {
        DataCellInterface dci;
        LayerAndMember colMembers = this.getSliceMemberSet(0, column);
        LayerAndMember rowMembers = this.getSliceMemberSet(1, row);
        LayerAndMember[] pageSet = this.getPageSet();
        MemberInterface[][] wrappedPage = this.wrapMembers(pageSet);
        MemberCacheKey memberKey = this.m_memberKeyPool.getCacheKeyFromPool(wrappedPage, rowMembers != null ? rowMembers.getMembers() : null, colMembers != null ? colMembers.getMembers() : null);
        Object objResult = this.m_memberCache.get(memberKey);
        QDRLite qdr = this.constructCellQDR(colMembers, rowMembers, pageSet);
        boolean wroteback = false;
        if (newValue != null && (dci = this.getProjection().getData(qdr)) != null) {
            wroteback = this.writeToCell(newValue, dci, type);
        }
        if (!this.isLocalStorage() && objResult == null) {
            objResult = this.getProjection().getData(qdr);
        }
        objResult = this.processResult(objResult, type, cacheKey, memberKey, qdrCacheKey, storeInMemberCache, wroteback ? null : newValue);
        this.m_memberKeyPool.returnCacheKeyToPool(memberKey);
        this.m_keyPool.returnCacheKeyToPool(cacheKey);
        return objResult;
    }

    private boolean writeToCell(Object newValue, DataCellInterface dci, String type) throws TransformException {
        return dci.setData(newValue instanceof TransformUtils.NullMarker ? null : newValue, TransformUtils.convertDataMap(type));
    }

    protected void addMembers(QDRLite qdr, LayerAndMember members) throws TransformException {
        if (members == null || members.getMembers() == null) {
            return;
        }
        for (int i = 0; i < members.getMembers().length; ++i) {
            qdr.addDimMemberPair(members.getLayers()[i], members.getMembers()[i].getValue());
        }
    }

    protected abstract QDRLite generateQDR() throws TransformException;

    private void _removeCollisions(LayerAndMember[] source, LayerAndMember[] rest) throws TransformException {
        if (source == null || rest == null) {
            return;
        }
        for (int s = 0; s < source.length; ++s) {
            if (source[s] == null) continue;
            for (int r = 0; r < rest.length; ++r) {
                if (rest[r] == null) continue;
                rest[r].removeCollisions(source[s]);
            }
        }
    }

    private void removeCollisions(LayerAndMember colMembers, LayerAndMember rowMembers, LayerAndMember[] pageSet) throws TransformException {
        int i;
        LayerAndMember[] rest = new LayerAndMember[(rowMembers != null ? 1 : 0) + (pageSet != null ? pageSet.length : 0)];
        int pos = 0;
        if (rowMembers != null) {
            rest[pos++] = rowMembers;
        }
        if (pageSet != null) {
            for (i = 0; i < pageSet.length; ++i) {
                rest[pos++] = pageSet[i];
            }
        }
        this._removeCollisions(new LayerAndMember[]{colMembers}, rest);
        rest = new LayerAndMember[(colMembers != null ? 1 : 0) + (pageSet != null ? pageSet.length : 0)];
        pos = 0;
        if (colMembers != null) {
            rest[pos++] = colMembers;
        }
        if (pageSet != null) {
            for (i = 0; i < pageSet.length; ++i) {
                rest[pos++] = pageSet[i];
            }
        }
        this._removeCollisions(new LayerAndMember[]{rowMembers}, rest);
        rest = new LayerAndMember[(colMembers != null ? 1 : 0) + (rowMembers != null ? 1 : 0)];
        pos = 0;
        if (colMembers != null) {
            rest[pos++] = colMembers;
        }
        if (rowMembers != null) {
            rest[pos++] = rowMembers;
        }
        this._removeCollisions(pageSet, rest);
    }

    protected QDRLite constructCellQDR(LayerAndMember colMembers, LayerAndMember rowMembers, LayerAndMember[] pageSet) throws TransformException {
        if (this.isCollisions()) {
            this.removeCollisions(colMembers, rowMembers, pageSet);
        }
        QDRLite qdr = this.generateQDR();
        this.addMembers(qdr, colMembers);
        this.addMembers(qdr, rowMembers);
        if (pageSet != null) {
            for (int i = 0; i < pageSet.length; ++i) {
                if (pageSet[i] == null) continue;
                this.addMembers(qdr, pageSet[i]);
            }
        }
        return qdr;
    }

    protected void storeMetadata(Object metadata, hPosMetadataCacheKey cacheKey, QDRCacheKey qdrCacheKey, String type) {
        if (cacheKey == null) {
            return;
        }
        if (metadata == null) {
            this.m_hPosMetadataCache.put((hPosMetadataCacheKey)cacheKey.clone(), CubeImpl.m_nullMarker);
        } else {
            this.m_hPosMetadataCache.put((hPosMetadataCacheKey)cacheKey.clone(), metadata);
        }
        this.m_hPosMetadataKeyPool.returnCacheKeyToPool(cacheKey);
        this._storeQDRCache(qdrCacheKey, type, metadata);
    }

    protected void storeLayerMetadata(Object metadata, LayerMetadataCacheKey cacheKey) {
        if (cacheKey == null) {
            return;
        }
        if (metadata == null) {
            this.m_layerMetadataCache.put((LayerMetadataCacheKey)cacheKey.clone(), CubeImpl.m_nullMarker);
        } else {
            this.m_layerMetadataCache.put((LayerMetadataCacheKey)cacheKey.clone(), metadata);
        }
        this.m_layerMetadataKeyPool.returnCacheKeyToPool(cacheKey);
    }

    protected void storeMetadata(Object metadata, MemberMetadataCacheKey cacheKey, QDRCacheKey qdrCacheKey, String type) {
        if (cacheKey == null) {
            return;
        }
        if (metadata == null) {
            this.m_memberMetadataCache.put((MemberMetadataCacheKey)cacheKey.clone(), CubeImpl.m_nullMarker);
        } else {
            this.m_memberMetadataCache.put((MemberMetadataCacheKey)cacheKey.clone(), metadata);
        }
        this.m_metadataKeyPool.returnCacheKeyToPool(cacheKey);
        this._storeQDRCache(qdrCacheKey, type, metadata);
    }

    protected void storeData(Object data, hPosDataCacheKey cacheKey, QDRCacheKey qdrCacheKey, String type) {
        if (cacheKey == null) {
            return;
        }
        if (data == null) {
            this.m_dataCache.put((hPosDataCacheKey)cacheKey.clone(), CubeImpl.m_nullMarker);
        } else {
            this.m_dataCache.put((hPosDataCacheKey)cacheKey.clone(), data);
        }
        this.m_keyPool.returnCacheKeyToPool(cacheKey);
        if (qdrCacheKey != null) {
            DataCellInterface cellInt = (DataCellInterface)this.m_qdrDataCache.get(qdrCacheKey);
            boolean newInt = false;
            if (!(cellInt instanceof DataCellInterfaceImpl)) {
                cellInt = new DataCellInterfaceImpl();
                newInt = true;
            }
            if (data == null) {
                ((DataCellInterfaceImpl)cellInt).addType(type, CubeImpl.m_nullMarker);
            } else {
                ((DataCellInterfaceImpl)cellInt).addType(type, data);
            }
            if (newInt) {
                this._storeQDRDataCache(qdrCacheKey, cellInt);
            } else {
                this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
            }
        }
    }

    protected LayerAndMember getSliceMemberSet(int edge, long slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, TransformException {
        EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
        if (et != null) {
            return et.getSliceMembers(slice);
        }
        return null;
    }

    protected LayerAndMember getHPosMemberSet(int edge, long[] hPos) throws EdgeOutOfRangeException, TransformException {
        EdgeTreeImpl et = this.getEdgeTree(edge, -1L, true);
        if (et != null) {
            return et.getHPosMembers(hPos);
        }
        return null;
    }

    protected LayerAndMember[] getPageSet() throws EdgeOutOfRangeException, TransformException {
        int edgeCount = this.getEdgeCount();
        LayerAndMember[] pageSet = edgeCount > 2 ? new LayerAndMember[edgeCount - 2] : null;
        for (int e = 2; e < edgeCount; ++e) {
            pageSet[e - 2] = this.getHPosMemberSet(e, TransformUtils.getLongFromIntArray(this.getEdgeCurrentHPos(e)));
        }
        if (pageSet != null && pageSet.length == 0) {
            return new LayerAndMember[0];
        }
        return pageSet;
    }

    @Override
    public synchronized long getSliceMemberCount(int edge, long slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                return et.getDepth(-1, slice);
            }
            return 0L;
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized Object getLayerMetadata(int edge, int layer, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        Object objResult;
        LayerMetadataCacheKey cacheKey = null;
        if (this.m_caching && (objResult = (Object)this.m_layerMetadataCache.get(cacheKey = this.m_layerMetadataKeyPool.getCacheKeyFromPool(edge, layer, type))) != null) {
            this.m_layerMetadataKeyPool.returnCacheKeyToPool(cacheKey);
            return objResult instanceof TransformUtils.NullMarker ? null : objResult;
        }
        try {
            objResult = null;
            LayerInterface li = this.getLayerInfo(edge, layer);
            if (li != null) {
                objResult = type.equals("layerName") ? li.getValue() : li.getMetadata(TransformUtils.convertLayerMetadataMap(type));
                this.storeLayerMetadata(objResult, cacheKey);
            }
            return objResult;
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        long longSlice = slice;
        return (int)this.getSliceMemberCount(edge, longSlice);
    }

    @Override
    public synchronized int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        return (int)this.getEdgeExtentLong(edge);
    }

    @Override
    public synchronized boolean setMemberMetadata(int edge, int layer, int slice, String type, Object value) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            return this._setMemberMetadata(edge, layer, slice, type, value, this.m_qdrCaching, true);
        }
        catch (TransformException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean _setMemberMetadata(int edge, int layer, int slice, String type, Object value, boolean qdrCachingSetting, boolean writeback) throws TransformException, EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        EdgeTreeNodeImpl node;
        MemberInterface mi;
        EdgeTreeImpl et;
        boolean madeChange;
        MemberInterface[][] pageSet = this.wrapMembers(this.getPageSet());
        MemberMetadataCacheKey cacheKey = this.m_metadataKeyPool.getCacheKeyFromPool(pageSet, edge, layer, slice, type);
        boolean bl = madeChange = this.m_memberMetadataCache.remove(cacheKey) != null;
        if (this.m_qdrCaching) {
            this.m_qdrCaching = false;
            QDRLite qdr = TransformUtils.getMemberQDRLiteImpl(this.getLayout(), this.getDataLayer(), this, edge, layer, slice, 1);
            this.m_qdrCaching = qdrCachingSetting;
            QDRCacheKey qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(qdr);
            this.m_qdrCache.remove(qdrCacheKey, type);
            this.storeMetadata(value, cacheKey, qdrCacheKey, type);
            this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
        } else {
            this.storeMetadata(value, cacheKey, null, type);
        }
        boolean wroteback = false;
        if (writeback && (et = this.getEdgeTree(edge, slice, true)) != null && (mi = (node = et.getNode(layer, (long)slice, GetSlice.GET_TO_SLICE)).getMember()) instanceof WriteableMemberInterface) {
            wroteback = ((WriteableMemberInterface)mi).setMemberValue(value, TransformUtils.convertMetadataMap(type));
        }
        this.m_metadataKeyPool.returnCacheKeyToPool(cacheKey);
        return writeback ? wroteback : madeChange;
    }

    @Override
    public synchronized Object getValue(int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        long longRow = row;
        long longCol = col;
        return this.getValue(longRow, longCol, type);
    }

    @Override
    public synchronized boolean setValue(Object data, int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        boolean qdrCachingSetting = this.m_qdrCaching;
        try {
            MemberInterface[][] pageSet = this.wrapMembers(this.getPageSet());
            hPosDataCacheKey cacheKey = null;
            QDRCacheKey qdrCacheKey = null;
            if (this.m_caching) {
                cacheKey = this.m_keyPool.getCacheKeyFromPool(pageSet, row, col, type);
                if (this.m_qdrCaching) {
                    this.m_qdrCaching = false;
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool(TransformUtils.getValueQDRLiteImpl(this.getLayout(), this.getDataLayer(), this, row, col, 0));
                    this.m_qdrCaching = qdrCachingSetting;
                }
            }
            this.getResultAndCache(cacheKey, row, col, type, qdrCacheKey, true, data == null ? TransformUtils.m_nullMarker : data);
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        finally {
            this.m_qdrCaching = qdrCachingSetting;
        }
        return true;
    }

    @Override
    public synchronized int getSliceOutlineLayer(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                return et.getLowestLayer(slice);
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 0;
    }

    @Override
    public synchronized int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        long longSlice = slice;
        return this.getMemberDepth(edge, layer, longSlice);
    }

    @Override
    public synchronized int getMemberDepth(int edge, int layer, long slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                return et.getNodeSize(layer, slice);
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1;
    }

    @Override
    public synchronized int getMemberStartLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                return et.getStartLayer(layer, slice);
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return layer;
    }

    @Override
    public synchronized int getMemberLogicalLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                return et.getDepth(layer, slice);
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return layer;
    }

    @Override
    public synchronized int getMemberExtent(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return (int)this.getMemberExtentLong(edge, layer, slice);
    }

    @Override
    public long getMemberExtentLong(int edge, int layer, long slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                return et.getSpan(layer, slice);
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1L;
    }

    @Override
    public synchronized int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                return (int)et.getStart(layer, slice);
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1;
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, int layer, int slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        long longSlice = slice;
        return this.getMemberMetadata(edge, layer, longSlice, type);
    }

    @Override
    public synchronized QDR getValueQDR(int row, int column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            return TransformUtils.getValueQDRImpl(this.getLayout(), this.getDataLayer(), this, row, column, flags, false, false, false);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            return TransformUtils.getSliceQDRImpl(this.getLayout(), this.getDataLayer(), this, 0L, edge, slice, flags, false, false, false);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized QDR getMemberQDR(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            return TransformUtils.getMemberQDRImpl(this.getLayout(), this.getDataLayer(), this, edge, layer, slice, flags, false, false, false);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized QDR getMemberQDR(int edge, int[] hPos, int memberLayer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            return TransformUtils.getMemberQDRImpl(this.getLayout(), this.getDataLayer(), this, edge, TransformUtils.getLongFromIntArray(hPos), memberLayer, memberLayer < hPos.length ? (long)hPos[memberLayer] : 0L, flags, false, false, false);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized QDR getLayerQDR(int edge, int layer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        try {
            return TransformUtils.getLayerQDRImpl(this.getLayout(), this.getDataLayer(), this, edge, layer, flags, false, false, false);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int getMemberSiblingCount(int edge, int[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return (int)this.getMemberSiblingCount(edge, TransformUtils.getLongFromIntArray(hPos), memberLayer);
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, int[] hPos, int memberLayer, int hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        long hIndexLong = hIndex;
        return this.getMemberMetadata(edge, TransformUtils.getLongFromIntArray(hPos), memberLayer, hIndexLong, type);
    }

    @Override
    public synchronized int[] getMemberHPos(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        long longSlice = slice;
        return TransformUtils.getIntFromLongArray(this.getMemberHPos(edge, layer, longSlice));
    }

    @Override
    public synchronized int[] getFirstHPos(int edge) throws EdgeOutOfRangeException {
        try {
            return TransformUtils.getIntFromLongArray(super._getFirstHPos(edge));
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int[] getLastHPos(int edge) throws EdgeOutOfRangeException {
        try {
            return TransformUtils.getIntFromLongArray(super._getLastHPos(edge));
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int[] getPrevHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                return TransformUtils.getIntFromLongArray(et.getPreviousLeafNode(TransformUtils.getLongFromIntArray(hPos)).getHPos());
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized int[] getNextHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                EdgeTreeNodeImpl node = et.getNextLeafNode(TransformUtils.getLongFromIntArray(hPos));
                if (node != null) {
                    return TransformUtils.getIntFromLongArray(node.getHPos());
                }
                return null;
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized int[] getSlicesFromQDR(QDRInterface qdr, int[] startSlice, int[] endSlice) {
        int[][] retVal = this._getSlicesFromQDR(qdr, startSlice, endSlice, null, false, false);
        if (retVal != null && retVal.length > 0) {
            int[] edges = new int[retVal.length];
            for (int e = 0; e < edges.length; ++e) {
                edges[e] = retVal[e] != null && retVal[e].length > 0 ? retVal[e][0] : -1;
            }
            return edges;
        }
        return new int[0];
    }

    private int[][] _getSlicesFromQDR(QDRInterface qdr, int[] startSlice, int[] endSlice, int[][] dropBack, boolean fail, boolean treatNullAsAll) {
        int e;
        int edgeCount = this.getEdgeCount();
        int[][] outOfBounds = new int[edgeCount][];
        for (int i = 0; i < edgeCount; ++i) {
            outOfBounds[i] = new int[]{-1};
        }
        if (qdr == null) {
            return outOfBounds;
        }
        int[][] retVal = new int[edgeCount][];
        EdgeTreeImpl et = null;
        EdgeTreeNodeImpl[] node = null;
        String layerName = null;
        QDRMember member = null;
        boolean foundAnyInEdge = false;
        for (int edge = 0; edge < edgeCount; ++edge) {
            foundAnyInEdge = false;
            int layerCount = -1;
            try {
                layerCount = this.getLayerCount(edge);
            }
            catch (EdgeOutOfRangeException e2) {
                throw new TransformRuntimeException(e2.getMessage(), e2);
            }
            if (layerCount <= 0) continue;
            String[] edgeVals = new String[layerCount];
            for (int layer = 0; layer < layerCount; ++layer) {
                try {
                    layerName = (String)this.getLayerMetadata(edge, layer, "layerName");
                }
                catch (DataException e3) {
                    throw new TransformRuntimeException(e3.getMessage(), e3);
                }
                member = qdr.getDimMember(layerName);
                if (member != null) {
                    edgeVals[layer] = member.getData() != null ? member.getData().toString() : null;
                    foundAnyInEdge = true;
                    continue;
                }
                if (fail) {
                    return null;
                }
                try {
                    if (dropBack != null && edge < dropBack.length && dropBack[edge] != null && layer < dropBack[edge].length && dropBack[edge][layer] > -1) {
                        edgeVals[layer] = this.getEdgeTree(edge, dropBack[edge][layer], true).getNode(layer, (long)dropBack[edge][layer], GetSlice.GET_ALL_SLICES).getMember().getValue();
                        continue;
                    }
                    edgeVals[layer] = null;
                    continue;
                }
                catch (Exception e4) {
                    throw new TransformRuntimeException(e4.getMessage(), e4);
                }
            }
            if (!foundAnyInEdge) continue;
            try {
                et = this.getEdgeTree(edge, -1L, true);
                node = et.findNode(edgeVals, treatNullAsAll);
                if (node == null) continue;
                retVal[edge] = new int[node.length];
                for (int z = 0; z < retVal[edge].length; ++z) {
                    retVal[edge][z] = -1;
                }
                for (int i = 0; i < node.length; ++i) {
                    retVal[edge][i] = (int)node[i].getStart(GetSlice.GET_ALL_SLICES, -1L);
                    if (startSlice != null && edge < startSlice.length && retVal[edge][i] < startSlice[edge]) {
                        retVal[edge][i] = -1;
                    }
                    if (endSlice == null || edge >= endSlice.length || retVal[edge][i] <= endSlice[edge]) continue;
                    retVal[edge][i] = -1;
                }
                continue;
            }
            catch (Exception e5) {
                throw new TransformRuntimeException(e5.getMessage(), e5);
            }
        }
        int largestNodeCount = 0;
        for (e = 0; e < retVal.length; ++e) {
            if (retVal[e] == null || retVal[e].length <= largestNodeCount) continue;
            largestNodeCount = retVal[e].length;
        }
        for (e = 0; e < retVal.length; ++e) {
            if (retVal[e] != null) continue;
            retVal[e] = new int[largestNodeCount];
            for (int i = 0; i < retVal[e].length; ++i) {
                retVal[e][i] = -1;
            }
        }
        return retVal;
    }

    @Override
    public synchronized List getUniqueMemberMetadata(int edge, int layer, String[] types, int start, int count) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return TransformUtils.getUniqueMemberMetadata(this, false, 1000L, edge, layer, types, start, count);
    }

    @Override
    public synchronized List getUniqueMemberMetadata(String layerName, String[] types, int start, int count) throws LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            int[] loc = TransformUtils.getLayerAndEdge(layerName, this.getLayout());
            if (loc != null) {
                return TransformUtils.getUniqueMemberMetadata(this, false, 1000L, loc[0], loc[1], types, start, count);
            }
            return new ArrayList();
        }
        catch (EdgeOutOfRangeException e) {
            throw new LayerOutOfRangeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized List getCorrespondingMemberMetadata(int edge, int layer, String[] values, String[] types, boolean inDataAccess) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        return TransformUtils.getCorrespondingMemberMetadata(this, edge, layer, values, types, inDataAccess, false);
    }

    @Override
    public synchronized List getCorrespondingMemberMetadata(String layerName, String[] values, String[] types, boolean inDataAccess) throws LayerOutOfRangeException {
        int[] layerAndEdge = TransformUtils.getLayerAndEdge(layerName, this.getLayout());
        if (layerAndEdge == null || layerAndEdge.length < 2) {
            return new ArrayList();
        }
        try {
            return this.getCorrespondingMemberMetadata(layerAndEdge[0], layerAndEdge[1], values, types, inDataAccess);
        }
        catch (EdgeOutOfRangeException e) {
            throw new LayerOutOfRangeException(e.getMessage(), e);
        }
    }

    protected long[] findMember(EdgeTreeNodeImpl node, long start, long inc, String comp, boolean reverse, String type, int flags, boolean stop) throws TransformException {
        MemberInterface mi = null;
        String comp2 = null;
        long count = node.getChildCount();
        ArrayList<Long> retVals = new ArrayList<Long>();
        for (long val = start; reverse && val >= 0L || !reverse && val < count; val += inc) {
            Object obj;
            mi = node.getChild(val).getMember();
            comp2 = null;
            if (mi != null && (obj = mi.getMetadata(type)) != null) {
                comp2 = obj.toString();
            }
            if ((flags & 0x80) != 0) {
                comp2 = comp2.toUpperCase();
            }
            if (!TransformUtils.compareStrings(comp, comp2, flags)) continue;
            if (stop) {
                return new long[]{val};
            }
            retVals.add(val);
        }
        long[] rets = new long[retVals.size()];
        int i = 0;
        for (Long val : retVals) {
            rets[i++] = val;
        }
        return rets;
    }

    @Override
    public synchronized int[] findMembers(int edge, int[] hPos, int memberLayer, String s, String type, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this._findMembers(edge, hPos, memberLayer, s, type, flags, false);
    }

    @Override
    public synchronized int findMember(int edge, int[] hPos, int memberLayer, String s, String type, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        int[] retVal = this._findMembers(edge, hPos, memberLayer, s, type, flags, true);
        if (retVal != null && retVal.length > 0) {
            return retVal[0];
        }
        return -1;
    }

    private int[] _findMembers(int edge, int[] hPos, int memberLayer, String s, String type, int flags, boolean stop) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTreeImpl et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                boolean nullHPos = hPos == null || hPos.length == 0;
                EdgeTreeNodeImpl node = et.getNode(TransformUtils.getLongFromIntArray(hPos), memberLayer - 1, !nullHPos && memberLayer > 0 ? (long)hPos[memberLayer - 1] : 0L);
                long start = 0L;
                if (hPos != null && hPos.length > memberLayer && (start = (long)hPos[memberLayer]) < 0L) {
                    start = 0L;
                }
                boolean reverse = false;
                long inc = 1L;
                if ((flags & 0x100) != 0) {
                    reverse = true;
                    inc = -1L;
                }
                String comp = null;
                comp = (flags & 0x80) != 0 ? s.toUpperCase() : s;
                long[] retVals = this.findMember(node, start, inc, comp, reverse, type, flags, stop);
                if (retVals != null) {
                    int[] retInt = new int[retVals.length];
                    for (int i = 0; i < retVals.length; ++i) {
                        retInt[i] = (int)retVals[i];
                    }
                    return retInt;
                }
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return new int[]{-1};
    }

    protected class DataCellInterfaceImpl
    implements DataCellInterface {
        Hashtable<String, Object> m_typeData = new Hashtable();

        public void addType(String type, Object data) {
            this.m_typeData.put(type, data);
        }

        @Override
        public Object getData(String type) {
            return this.m_typeData.get(TransformUtils.convertDataType(type));
        }

        @Override
        public boolean setData(Object value, String type) {
            return false;
        }
    }

    protected class SortList
    extends ArrayList<SortParams> {
        private static final long serialVersionUID = 1L;

        protected SortList() {
        }

        public void add(int edge, QDR qdr, int sortDirection, boolean nullsFirst, boolean group) {
            SortParams sp = null;
            SortParams newSp = new SortParams(edge, qdr, sortDirection, nullsFirst, group);
            for (int i = 0; i < super.size(); ++i) {
                sp = (SortParams)super.get(i);
                if (sp.m_edge != edge || !Utility.compareObj(sp.m_QDR, qdr)) continue;
                super.set(i, newSp);
                return;
            }
            super.add(newSp);
        }

        public boolean sort() throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, CloneNotSupportedException {
            boolean retVal = true;
            Iterator iter = super.iterator();
            ArrayList localList = new ArrayList();
            while (iter.hasNext()) {
                localList.add(iter.next());
            }
            for (SortParams sp : localList) {
                if (sp.sort()) continue;
                retVal = false;
            }
            return retVal;
        }

        protected class SortParams {
            private int m_edge = -1;
            protected QDR m_QDR = null;
            private int m_sortDirection = -1;
            private boolean m_nullsFirst = false;
            private boolean m_group = false;

            public SortParams(int edge, QDR qdr, int sortDirection, boolean nullsFirst, boolean group) {
                this.m_edge = edge;
                this.m_QDR = qdr;
                this.m_sortDirection = sortDirection;
                this.m_nullsFirst = nullsFirst;
                this.m_group = group;
            }

            public boolean sort() throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
                return CubicDataAccessImpl.this.sort(this.m_edge, this.m_QDR, this.m_sortDirection, this.m_nullsFirst, this.m_group);
            }
        }
    }

    protected class MyRowProjection
    implements RowProjection {
        protected BaseProjection m_proj = null;
        protected RowIterator m_iter = null;
        protected int m_edge = -1;

        public MyRowProjection(BaseProjection proj, SortTuple[] rows, int edge) throws TransformException {
            this.m_proj = proj;
            this.m_edge = edge;
            this.m_iter = new MyRowIterator(rows, proj, edge);
        }

        @Override
        public RowIterator getRowIterator() {
            return this.m_iter;
        }

        @Override
        public LayerInterface getLayer(String layer) {
            int[] edgeLayer = TransformUtils.getLayerAndEdge(layer, this.getLayout());
            try {
                return CubicDataAccessImpl.this.getLayerInfo(edgeLayer[0], edgeLayer[0]);
            }
            catch (Exception e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public String[][] getLayout() {
            String[][] layout = this.m_proj.getLayout();
            if (layout != null && layout.length > this.m_edge) {
                String[][] retVal = new String[this.m_edge + 1][];
                retVal[this.m_edge] = layout[this.m_edge];
                return retVal;
            }
            return new String[0][];
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_proj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_proj.getDataItems();
        }

        @Override
        public DataCellInterface getData(Map<String, Object> keyPath) {
            return this.m_proj.getData(keyPath);
        }

        @Override
        public String[] getIgnoredColumns() {
            return new String[0];
        }
    }

    protected class MyRowIterator
    implements RowIterator {
        protected int m_row = -1;
        protected SortTuple[] m_rows = null;
        protected String[] m_columns = null;

        public MyRowIterator(SortTuple[] rows, BaseProjection proj, int edge) throws TransformException {
            this.m_rows = rows;
            if (rows.length > 0) {
                this.m_columns = new String[rows[0].m_layers.length];
                for (int c = 0; c < this.m_columns.length; ++c) {
                    this.m_columns[c] = proj.getLayout()[edge][c];
                }
            }
        }

        @Override
        public boolean hasMoreRows() throws TransformException {
            return this.m_row < this.m_rows.length;
        }

        @Override
        public boolean nextRow() throws TransformException {
            ++this.m_row;
            return this.hasMoreRows();
        }

        @Override
        public void close() throws TransformException {
        }

        private int _getColumnIndex(String column) {
            for (int c = 0; c < this.m_columns.length; ++c) {
                if (!column.equals(this.m_columns[c])) continue;
                return c;
            }
            return -1;
        }

        @Override
        public MemberInterface getMember(String column) throws TransformException {
            if (this.m_row < 0 || this.m_row >= this.m_rows.length) {
                return null;
            }
            int c = this._getColumnIndex(column);
            if (c < 0 || c >= this.m_rows[this.m_row].m_layers.length) {
                return null;
            }
            return this.m_rows[this.m_row].m_layers[c];
        }

        @Override
        public DataCellInterface getCell(String column) throws TransformException {
            return null;
        }

        @Override
        public String[] getColumns() {
            return this.m_columns;
        }

        @Override
        public Object getValue(String column) throws TransformException {
            MemberInterface mi = this.getMember(column);
            if (mi != null) {
                return mi.getValue();
            }
            return null;
        }
    }

    protected class SortTuple
    implements ComparatorInterface {
        protected MemberInterface[] m_layers = null;
        protected Object m_data = null;

        public SortTuple(MemberInterface[] layers, Object data) {
            this.m_layers = layers;
            this.m_data = data;
        }

        @Override
        public Object getValue() {
            return this.m_data;
        }
    }
}

