/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.dvt.util.transform.RowProjection;
import oracle.adf.model.dvt.util.transform.SimpleCollectionRowProjectionImpl;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.ResultTable;
import oracle.adfinternal.model.dvt.util.transform.total.AggMethod;
import oracle.adfinternal.model.dvt.util.transform.total.AggSpec;
import oracle.dss.util.QDR;

public class CollectionServices {
    public static final String DATALAYER = "_dataLayer";

    public static List<? extends Map> groupRows(List<? extends Map> rowset, AggSpec[] groupSpecs) throws TransformException {
        String[] dataItems = CollectionServices._getDataItems(groupSpecs);
        String[][] layout = CollectionServices._getLayout(rowset, dataItems);
        SimpleCollectionRowProjectionImpl proj = new SimpleCollectionRowProjectionImpl(rowset, layout, dataItems, DATALAYER);
        ResultTable rt = new ResultTable((RowProjection)proj, groupSpecs);
        return rt.getDataTable().getRows();
    }

    public static List<Map> sortRows(List<Map> rowset, String[] columns, int[] sortDirections) {
        Collections.sort(rowset, new CompareMaps(columns, sortDirections));
        return rowset;
    }

    private static String[] _getDataItems(AggSpec[] specs) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < (specs == null ? 0 : specs.length); ++i) {
            if (specs[i] == null) continue;
            AggMethod[] methods = specs[i].getAggMethods();
            for (int k = 0; k < (methods == null ? 0 : methods.length); ++k) {
                QDR qdr;
                if (methods[k] == null || (qdr = methods[k].getQDR()) == null) continue;
                list.add(qdr.getDimMember(DATALAYER).toString());
            }
        }
        return list.toArray(new String[0]);
    }

    private static String[][] _getLayout(List<? extends Map> rowset, String[] dataItems) {
        if (rowset == null || rowset.size() == 0) {
            return null;
        }
        Map m = rowset.iterator().next();
        if (m == null) {
            return null;
        }
        ArrayList<String> items = new ArrayList<String>();
        Set keys = m.keySet();
        for (String key : keys) {
            if (CollectionServices.inDataItems(dataItems, key)) continue;
            items.add(key);
        }
        return new String[][]{items.toArray(new String[0])};
    }

    private static boolean inDataItems(String[] dataItems, String key) {
        if (dataItems == null) {
            return false;
        }
        for (int i = 0; i < dataItems.length; ++i) {
            if (!dataItems[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    private static class CompareMaps
    implements Comparator {
        private int[] m_sortDirections = null;
        private String[] m_columns = null;

        public CompareMaps(String[] columns, int[] sortDirections) {
            this.m_sortDirections = sortDirections;
            this.m_columns = columns;
        }

        public int compare(Object e1, Object e2) {
            if (e1 instanceof Map && e2 instanceof Map) {
                for (int c = 0; c < this.m_columns.length; ++c) {
                    int comp = this.compareObjs(((Map)e1).get(this.m_columns[c]), ((Map)e2).get(this.m_columns[c]), this.m_sortDirections == null ? 0 : this.m_sortDirections[c]);
                    if (comp == 0) continue;
                    return comp;
                }
            }
            return 0;
        }

        private int getDirectionFactor(int direction) {
            return direction == 0 ? 1 : -1;
        }

        private int compareObjs(Object o1, Object o2, int direction) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                if (o2 instanceof Comparable) {
                    return this.getDirectionFactor(direction) * ((Comparable)o2).compareTo(o1);
                }
                return 0;
            }
            if (o1 instanceof Comparable) {
                return this.getDirectionFactor(direction) * ((Comparable)o1).compareTo(o2);
            }
            return 0;
        }
    }
}

