/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.dvt.util.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.MemberInterfaceAbstractImpl;
import oracle.adf.model.dvt.util.transform.RowIterator;
import oracle.adf.model.dvt.util.transform.RowProjection;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.total.AggType;
import oracle.adfinternal.model.dvt.util.transform.QDRLite;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;

public class SimpleCollectionRowProjectionImpl
implements RowProjection {
    private Map<String, LayerInterface> m_layerIntTable = new HashMap<String, LayerInterface>();
    private MemberInterface[] m_dataMembers = null;
    private Map<Map<String, Object>, DataCellInterface> m_data = new HashMap<Map<String, Object>, DataCellInterface>();
    private String m_dataLayerName = null;
    private String[][] m_layout = null;
    private String[] m_dataItems = null;
    private Collection m_collection = null;

    public SimpleCollectionRowProjectionImpl(Collection coll, String[][] layout, String[] dataItems, String dataLayerName) {
        this.m_dataItems = dataItems;
        this.m_collection = coll;
        this.m_dataLayerName = dataLayerName;
        this.m_layout = layout;
    }

    @Override
    public String[][] getLayout() {
        return this.m_layout;
    }

    @Override
    public LayerInterface getDataLayer() {
        return this.getLayer(this.m_dataLayerName);
    }

    @Override
    public MemberInterface[] getDataItems() {
        if (this.m_dataMembers == null && this.m_dataItems != null) {
            this.m_dataMembers = new MemberInterface[this.m_dataItems.length];
            try {
                for (int i = 0; i < this.m_dataItems.length; ++i) {
                    this.m_dataMembers[i] = new MemberInterfaceImpl(this.m_dataItems[i], this.getDataLayer().getValue());
                }
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        return this.m_dataMembers;
    }

    @Override
    public DataCellInterface getData(Map<String, Object> keyPath) {
        return this.m_data.get(keyPath);
    }

    @Override
    public RowIterator getRowIterator() {
        return new RowIterImpl(this.m_collection);
    }

    @Override
    public LayerInterface getLayer(String layer) {
        LayerInterface layerInt = this.m_layerIntTable.get(layer);
        if (layerInt == null) {
            layerInt = new LayerInterfaceImpl(layer);
            this.m_layerIntTable.put(layer, layerInt);
        }
        return layerInt;
    }

    @Override
    public String[] getIgnoredColumns() {
        return null;
    }

    private class LayerInterfaceImpl
    implements LayerInterface {
        private Object m_value = null;

        public LayerInterfaceImpl(Object value) {
            this.m_value = value;
        }

        @Override
        public String getValue() throws TransformException {
            return this.m_value != null ? this.m_value.toString() : null;
        }

        @Override
        public Object getMetadata(String type) throws TransformException {
            if ("layerName".equals(type) || "layerLabel".equals(type)) {
                return this.m_value;
            }
            if ("dimIsMeasure".equals(type)) {
                return SimpleCollectionRowProjectionImpl.this.m_dataLayerName.equals(this.m_value);
            }
            return null;
        }
    }

    protected class MemberInterfaceImpl
    extends MemberInterfaceAbstractImpl {
        private Object m_value = null;
        private String m_col = null;

        public MemberInterfaceImpl(Object value, String column) {
            this.m_value = value;
            this.m_col = column;
        }

        @Override
        public String getValue() throws TransformException {
            return this.m_value != null ? this.m_value.toString() : null;
        }

        @Override
        public Object getMetadata(String type) throws TransformException {
            if ("memberMetadataColumn".equals(type)) {
                return this.m_col;
            }
            if ("memberMetadataAggPosition".equals(type)) {
                return MemberInterface.AggregatePosition.NONE;
            }
            if ("aggType".equals(type)) {
                return AggType.NONE;
            }
            if ("memberMetadataIsCollapsed".equals(type)) {
                return Boolean.FALSE;
            }
            if ("drillState".equals(type)) {
                return 0;
            }
            if ("drillParentLongName".equals(type)) {
                return null;
            }
            if ("indent".equals(type)) {
                return 0;
            }
            if ("isTotal".equals(type)) {
                return Boolean.FALSE;
            }
            return this.m_value;
        }
    }

    private class DataCellInterfaceImpl
    implements DataCellInterface {
        private Object m_value = null;
        private String m_col = null;

        public DataCellInterfaceImpl(Object value, String column) {
            this.m_value = value;
            this.m_col = column;
        }

        @Override
        public Object getData(String type) throws TransformException {
            if ("dataTypeColumn".equals(type)) {
                return this.m_col;
            }
            if ("dataFormattedValue".equals(type) || "dataValue".equals(type)) {
                return this.m_value;
            }
            if ("dataIsTotal".equals(type) || "dataIsEditable".equals(type)) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public boolean setData(Object value, String type) {
            return false;
        }
    }

    private class RowIterImpl
    implements RowIterator {
        private Collection m_coll = null;
        private String[] m_columns = null;
        private Iterator m_iter = null;
        private Map<String, Object> m_currRow = null;
        private QDRLite m_currKeyPath = new QDRLite();

        public RowIterImpl(Collection coll) {
            this.m_coll = coll;
            this.m_iter = this.m_coll.iterator();
        }

        @Override
        public MemberInterface getMember(String column) throws TransformException {
            Object val = this.m_currRow.get(column);
            this.m_currKeyPath.addDimMemberPair(column, val);
            return new MemberInterfaceImpl(val, column);
        }

        @Override
        public DataCellInterface getCell(String column) throws TransformException {
            DataCellInterfaceImpl dci = new DataCellInterfaceImpl(this.m_currRow.get(column), column);
            try {
                QDRLite currKey = (QDRLite)this.m_currKeyPath.clone();
                currKey.addDimMemberPair(SimpleCollectionRowProjectionImpl.this.m_dataLayerName, column);
                SimpleCollectionRowProjectionImpl.this.m_data.put(currKey, dci);
            }
            catch (CloneNotSupportedException e) {
                throw new TransformException(e.getMessage(), e);
            }
            return dci;
        }

        @Override
        public boolean hasMoreRows() throws TransformException {
            return this.m_iter.hasNext();
        }

        @Override
        public boolean nextRow() throws TransformException {
            if (this.hasMoreRows()) {
                Object obj = this.m_iter.next();
                this.m_currKeyPath = new QDRLite();
                if (obj instanceof Map) {
                    this.m_currRow = (Map)obj;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void close() throws TransformException {
            this.m_currRow = null;
            this.m_coll = null;
            this.m_iter = null;
            this.m_columns = null;
            this.m_currKeyPath = null;
        }

        @Override
        public String[] getColumns() {
            if (this.m_columns == null && this.m_currRow != null) {
                Set<String> cols = this.m_currRow.keySet();
                this.m_columns = cols.toArray(new String[0]);
            }
            return this.m_columns;
        }

        @Override
        public Object getValue(String column) throws TransformException {
            return this.m_currRow.get(column);
        }
    }
}

