/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.ui;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import oracle.ide.print.misc.Util;
import oracle.ide.print.ui.Paper;
import oracle.ide.print.ui.Preview;

final class Printer
implements Printable {
    private List<Paper> myPapers;

    Printer() {
    }

    String print(Preview preview) {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (job == null || job.getPrintService() == null) {
            return "ERR_No_Printer_Service";
        }
        if (!job.printDialog(Util.getConfig().getAttributes())) {
            return null;
        }
        job.setPrintable(this);
        this.myPapers = preview.updatePapers();
        try {
            job.print(Util.getConfig().getAttributes());
        }
        catch (PrinterException e) {
            return "ERR_No_Printer_Success";
        }
        this.myPapers = null;
        return null;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int index) throws PrinterException {
        if (index == this.myPapers.size()) {
            return 1;
        }
        this.myPapers.get(index).print(g);
        return 0;
    }
}

