/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.ide.print.api.PrintManager;
import oracle.ide.print.api.PrintPage;
import oracle.ide.print.api.PrintProvider;
import oracle.ide.print.misc.Percent;
import oracle.ide.print.misc.Util;
import oracle.ide.print.ui.Dialog;
import oracle.ide.print.ui.Option;
import oracle.ide.print.ui.Paper;
import oracle.ide.print.ui.Printer;

public final class Preview
extends Dialog
implements Percent.Listener {
    private JPanel myPaperPanel;
    private List<Paper> myPapers;
    private JButton myFirst;
    private JButton myPrevious;
    private JButton myNext;
    private JButton myLast;
    private JButton myFit;
    private JButton myIncrease;
    private JButton myDecrease;
    private Percent myScale;
    private JTextField myGoto;
    private int myPaperNumber;
    private int myCustomIndex;
    private Option myOption;
    private Printer myPrinter;
    private JToggleButton myToggle;
    private JScrollPane myScrollPane;
    private PrintProvider[] myPrintProviders;
    private static final int GAP_SIZE = 20;
    private static final int GOTO_WIDTH = 60;
    private static final int SCROLL_INCREMENT = 40;
    private static final double SCALE_RATIO = 1.05;
    private static final int[] PERCENTS = new int[]{25, 50, 75, 100, 200, 400};
    private static final String LAST = "last";
    private static final String FIRST = "first";
    private static final String INCREASE = "increase";
    private static final String DECREASE = "decrease";
    private static final String INCREASE_ZOOM = "increase.zoom";
    private static final String DECREASE_ZOOM = "decrease.zoom";
    private static final String INCREASE_SCALE = "increase.scale";
    private static final String DECREASE_SCALE = "decrease.scale";
    private static final String NORMAL_SCALE = "normal.scale";
    private static final String CUSTOM_SCALE = "custom.scale";
    private static final double PREVIEW_HEIGHT_RATIO = 0.77;
    private static final double PREVIEW_WIDTH_RATIO = 0.86;

    public Preview() {
        super("LBL_Print_Preview");
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int height = Util.round((double)screenHeight * 0.77);
        int width = Util.round((double)height * 0.86);
        Dimension d = super.getPreferredSize();
        this.setPreferredSize(new Dimension(Math.max(width, d.width), height));
        KeyStroke stroke = KeyStroke.getKeyStroke(107, 0);
        this.getRootPane().getInputMap(1).put(stroke, INCREASE_SCALE);
        stroke = KeyStroke.getKeyStroke(521, 0);
        this.getRootPane().getInputMap(1).put(stroke, INCREASE_SCALE);
        stroke = KeyStroke.getKeyStroke(61, 0);
        this.getRootPane().getInputMap(1).put(stroke, INCREASE_SCALE);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.myScale.increaseValue();
            }
        };
        this.getRootPane().getActionMap().put(INCREASE_SCALE, action);
        stroke = KeyStroke.getKeyStroke(109, 0);
        this.getRootPane().getInputMap(1).put(stroke, DECREASE_SCALE);
        stroke = KeyStroke.getKeyStroke(45, 0);
        this.getRootPane().getInputMap(1).put(stroke, DECREASE_SCALE);
        stroke = KeyStroke.getKeyStroke(523, 0);
        this.getRootPane().getInputMap(1).put(stroke, DECREASE_SCALE);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.myScale.decreaseValue();
            }
        };
        this.getRootPane().getActionMap().put(DECREASE_SCALE, action);
        stroke = KeyStroke.getKeyStroke(47, 0);
        this.getRootPane().getInputMap(1).put(stroke, CUSTOM_SCALE);
        stroke = KeyStroke.getKeyStroke(111, 0);
        this.getRootPane().getInputMap(1).put(stroke, CUSTOM_SCALE);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.myScale.normalValue();
            }
        };
        this.getRootPane().getActionMap().put(NORMAL_SCALE, action);
        stroke = KeyStroke.getKeyStroke(106, 0);
        this.getRootPane().getInputMap(1).put(stroke, NORMAL_SCALE);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.showCustom(true);
            }
        };
        this.getRootPane().getActionMap().put(CUSTOM_SCALE, action);
        stroke = KeyStroke.getKeyStroke(107, 2);
        this.getRootPane().getInputMap(1).put(stroke, INCREASE_ZOOM);
        stroke = KeyStroke.getKeyStroke(521, 2);
        this.getRootPane().getInputMap(1).put(stroke, INCREASE_ZOOM);
        stroke = KeyStroke.getKeyStroke(61, 2);
        this.getRootPane().getInputMap(1).put(stroke, INCREASE_ZOOM);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.increaseZoom();
            }
        };
        this.getRootPane().getActionMap().put(INCREASE_ZOOM, action);
        stroke = KeyStroke.getKeyStroke(109, 2);
        this.getRootPane().getInputMap(1).put(stroke, DECREASE_ZOOM);
        stroke = KeyStroke.getKeyStroke(45, 2);
        this.getRootPane().getInputMap(1).put(stroke, DECREASE_ZOOM);
        stroke = KeyStroke.getKeyStroke(523, 2);
        this.getRootPane().getInputMap(1).put(stroke, DECREASE_ZOOM);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.decreaseZoom();
            }
        };
        this.getRootPane().getActionMap().put(DECREASE_ZOOM, action);
        this.init(true);
    }

    public void perform(PrintProvider[] providers, boolean withPreview) {
        assert (providers != null) : "Print providers cannot be null";
        this.myPrintProviders = providers;
        this.updatePapers();
        if (withPreview) {
            this.setVisible(true);
        } else {
            this.print();
        }
        this.myPapers = null;
        this.myPrintProviders = null;
    }

    @Override
    protected String getHelpTopic() {
        return "f1_idedprintpreview_html";
    }

    @Override
    protected JButton[] getButtons() {
        JButton pageSetup = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_Page_Setup_Button"), this.i18n("TLT_Page_Setup_Button")){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PrintManager.getManager().openPageSetup()) {
                    Preview.this.updatePapers();
                }
            }
        });
        JButton option = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_Print_Option_Button"), this.i18n("TLT_Print_Option_Button")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.option();
            }
        });
        JButton print = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_Print_Button"), this.i18n("TLT_Print_Button")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.close();
                Preview.this.print();
            }
        });
        JButton close = this.createButton(new Dialog.ButtonAction(this.i18n("LBL_Close_Button"), this.i18n("TLT_Close_Button")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.close();
            }
        });
        this.markAsDefault(print);
        return new JButton[]{pageSetup, option, print, close};
    }

    @Override
    protected Component getInnerComponent() {
        JPanel p = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 2);
        p.add((Component)this.createNavigatePanel(), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        p.add((Component)this.createScalePanel(), c);
        c.anchor = 13;
        c.insets = new Insets(2, 13, 2, 0);
        this.myToggle = this.createToggleButton(new Dialog.ButtonAction(this.icon("toggle"), this.i18n("TLT_Show_First_Page")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.toggle();
            }
        });
        this.myToggle.setSelected(true);
        p.add((Component)this.myToggle, c);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(13, 0, 13, 0);
        panel.add((Component)p, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.createScrollPanel(), c);
        return panel;
    }

    private JComponent createNavigatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        panel = new JPanel(new GridBagLayout());
        c.insets = new Insets(2, 2, 2, 2);
        this.myFirst = this.createButton(new Dialog.ButtonAction(this.icon(FIRST), this.i18n("TLT_First")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.first();
            }
        });
        panel.add((Component)this.myFirst, c);
        this.myPrevious = this.createButton(new Dialog.ButtonAction(this.icon("previous"), this.i18n("TLT_Previous")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.previous();
            }
        });
        panel.add((Component)this.myPrevious, c);
        this.myGoto = new JTextField();
        int height = this.myPrevious.getPreferredSize().height;
        this.myGoto.setPreferredSize(new Dimension(60, height));
        this.myGoto.setMinimumSize(new Dimension(60, height));
        this.populateActionInputMap(this.myGoto.getActionMap(), this.myGoto.getInputMap());
        this.myGoto.setHorizontalAlignment(0);
        this.myGoto.setToolTipText(this.i18n("TLT_Goto"));
        this.myGoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.goTo();
            }
        });
        panel.add((Component)this.myGoto, c);
        this.myNext = this.createButton(new Dialog.ButtonAction(this.icon("next"), this.i18n("TLT_Next")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.next();
            }
        });
        panel.add((Component)this.myNext, c);
        this.myLast = this.createButton(new Dialog.ButtonAction(this.icon(LAST), this.i18n("TLT_Last")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.last();
            }
        });
        panel.add((Component)this.myLast, c);
        return panel;
    }

    private void populateActionInputMap(ActionMap actionMap, InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke('*'), LAST);
        inputMap.put(KeyStroke.getKeyStroke('/'), FIRST);
        inputMap.put(KeyStroke.getKeyStroke('+'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('='), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('-'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('_'), DECREASE);
        actionMap.put(INCREASE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        actionMap.put(DECREASE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        actionMap.put(LAST, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        actionMap.put(FIRST, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
    }

    private JComponent createScalePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 13, 2, 2);
        this.myFit = this.createButton(new Dialog.ButtonAction(this.icon("fit"), this.i18n("TLT_Fit")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.showCustom(true);
            }
        });
        panel.add((Component)this.myFit, c);
        c.insets = new Insets(2, 2, 2, 2);
        String[] custom = new String[]{this.i18n("LBL_Fit_to_Width"), this.i18n("LBL_Fit_to_Height"), this.i18n("LBL_Fit_to_Whole")};
        this.myScale = new Percent(false, this, 1.0, PERCENTS, custom.length - 1, custom, this.i18n("TLT_Preview_Scale"));
        int width = Util.round((double)this.myScale.getPreferredSize().width * 1.05);
        int height = this.myPrevious.getPreferredSize().height;
        this.myScale.setPreferredSize(new Dimension(width, height));
        this.myScale.setMinimumSize(new Dimension(width, height));
        panel.add((Component)this.myScale, c);
        this.myDecrease = this.createButton(new Dialog.ButtonAction(this.icon("minus"), this.i18n("TLT_Scale_Out")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.myScale.decreaseValue();
            }
        });
        panel.add((Component)this.myDecrease, c);
        this.myIncrease = this.createButton(new Dialog.ButtonAction(this.icon("plus"), this.i18n("TLT_Scale_In")){

            @Override
            public void actionPerformed(ActionEvent event) {
                Preview.this.myScale.increaseValue();
            }
        });
        panel.add((Component)this.myIncrease, c);
        return panel;
    }

    private JComponent createScrollPanel() {
        GridBagConstraints c = new GridBagConstraints();
        this.myPaperPanel = new JPanel(new GridBagLayout());
        this.myPaperPanel.setBackground(Color.lightGray);
        JPanel panel = new JPanel(new GridBagLayout());
        c.gridy = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.setBackground(Color.lightGray);
        panel.add((Component)this.myPaperPanel, c);
        c.fill = 1;
        this.myScrollPane = new JScrollPane(panel, 22, 32);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(40);
        this.myScrollPane.setFocusable(true);
        this.myScrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                if (SwingUtilities.isRightMouseButton(event) || event.isControlDown()) {
                    Preview.this.myScrollPane.setWheelScrollingEnabled(false);
                    if (event.getWheelRotation() > 0) {
                        Preview.this.myScale.increaseValue();
                    } else {
                        Preview.this.myScale.decreaseValue();
                    }
                } else {
                    Preview.this.myScrollPane.setWheelScrollingEnabled(true);
                }
            }
        });
        this.myScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() != 2) {
                    return;
                }
                if (event.isControlDown()) {
                    if (SwingUtilities.isRightMouseButton(event)) {
                        Preview.this.decreaseZoom();
                    } else {
                        Preview.this.increaseZoom();
                    }
                } else if (SwingUtilities.isRightMouseButton(event)) {
                    Preview.this.myScale.decreaseValue();
                } else {
                    Preview.this.myScale.increaseValue();
                }
            }
        });
        return this.myScrollPane;
    }

    private void increaseZoom() {
        Util.getConfig().setZoom(Util.getConfig().getZoom() * 1.05);
        this.updatePapers();
    }

    private void decreaseZoom() {
        Util.getConfig().setZoom(Util.getConfig().getZoom() / 1.05);
        this.updatePapers();
    }

    private void showCustom(boolean doNext) {
        if (doNext) {
            ++this.myCustomIndex;
        }
        this.myScale.customValue(this.myCustomIndex);
    }

    private void updateButtons() {
        this.myGoto.setText(this.getPaper(this.myPaperNumber));
        this.myFirst.setEnabled(this.myPaperNumber > 1);
        this.myPrevious.setEnabled(this.myPaperNumber > 1);
        this.myNext.setEnabled(this.myPaperNumber < this.getPaperCount());
        this.myLast.setEnabled(this.myPaperNumber < this.getPaperCount());
        boolean enabled = this.getPaperCount() > 0;
        this.myGoto.setEnabled(enabled);
        this.myScale.setEnabled(enabled);
        this.myToggle.setEnabled(enabled);
        this.myFit.setEnabled(enabled);
        this.myIncrease.setEnabled(enabled);
        this.myDecrease.setEnabled(enabled);
    }

    private void scrollTo() {
        Paper paper = this.myPapers.get(this.myPaperNumber - 1);
        int gap = this.getGap();
        int x = paper.getX() - gap;
        int y = paper.getY() - gap;
        int w = paper.getWidth();
        int h = paper.getHeight();
        JViewport view = this.myScrollPane.getViewport();
        if (!view.getViewRect().contains(x, y, w, h)) {
            view.setViewPosition(new Point(x, y));
            this.updatePaperPanel();
        }
    }

    @Override
    public double getCustomValue(int index) {
        if (this.getPaperCount() == 0) {
            return 0.0;
        }
        int width = this.myPapers.get(0).getPaperWidth() + 20;
        int height = this.myPapers.get(0).getPaperHeight() + 20;
        if (index == 0) {
            return this.getWidthScale(width);
        }
        if (index == 1) {
            return this.getHeightScale(height);
        }
        if (index == 2) {
            return this.getAllScale(width, height);
        }
        return 1.0;
    }

    private double getWidthScale(int width) {
        int JAVA_INSET = 5;
        double scrollWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth() - 5;
        return scrollWidth / (double)width;
    }

    private double getHeightScale(int height) {
        int JAVA_INSET = 5;
        double scrollHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight() - 5;
        return scrollHeight / (double)height;
    }

    private double getAllScale(int width, int height) {
        int w = width;
        int h = height;
        if (!this.isSingleMode()) {
            int maxRow = 0;
            int maxColumn = 0;
            for (Paper paper : this.myPapers) {
                maxRow = Math.max(maxRow, paper.getRow());
                maxColumn = Math.max(maxColumn, paper.getColumn());
            }
            w *= maxColumn + 1;
            h *= maxRow + 1;
        }
        return Math.min(this.getWidthScale(w), this.getHeightScale(h));
    }

    @Override
    public void valueChanged(double value, int index) {
        if (index != -1) {
            this.myCustomIndex = index;
        }
        if (this.getPaperCount() == 0) {
            return;
        }
        for (Paper paper : this.myPapers) {
            paper.setScale(value);
        }
        this.updatePaperPanel();
    }

    private void addPapers() {
        this.myPaperPanel.removeAll();
        if (this.getPaperCount() == 0) {
            String label = this.i18n("LBL_No_Content_Found");
            if (this.myPrintProviders != null && this.myPrintProviders.length > 0) {
                label = this.i18n("LBL_No_Content_Found_For", this.myPrintProviders[0].getName());
            }
            this.myPaperPanel.add(new JLabel(label));
            this.updatePaperPanel();
            return;
        }
        int gap = this.getGap();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(gap, gap, 0, 0);
        if (this.isSingleMode()) {
            this.myPaperPanel.add((Component)this.myPapers.get(this.myPaperNumber - 1), c);
        } else {
            for (Paper paper : this.myPapers) {
                c.gridx = paper.getColumn();
                c.gridy = paper.getRow();
                this.myPaperPanel.add((Component)paper, c);
            }
        }
        this.myPaperPanel.doLayout();
        this.updatePaperPanel();
    }

    private void updatePaperPanel() {
        this.myPaperPanel.revalidate();
        this.myPaperPanel.repaint();
    }

    List<Paper> updatePapers() {
        this.myPapers = new ArrayList<Paper>();
        int width = Util.getConfig().getPageWidth();
        int height = Util.getConfig().getPageHeight();
        double zoom = Util.getConfig().getZoom();
        double scale = 1.0;
        if (this.myScale != null) {
            scale = this.myScale.getValue();
        }
        int delta = 0;
        int number = 0;
        for (PrintProvider provider : this.myPrintProviders) {
            String name = provider.getName();
            if (name == null) {
                name = "";
            }
            PrintPage[][] pages = provider.getPages(width, height, zoom);
            for (int i = 0; i < pages.length; ++i) {
                for (int j = 0; j < pages[i].length; ++j) {
                    PrintPage page = pages[i][j];
                    if (page == null) continue;
                    Paper paper = new Paper(page, name);
                    paper.setCoordinate(number + 1, i + delta, j, scale);
                    this.myPapers.add(paper);
                    ++number;
                }
            }
            delta += pages.length;
        }
        int count = this.myPapers.size();
        for (Paper paper : this.myPapers) {
            paper.setCount(count);
        }
        this.toggle();
        return this.myPapers;
    }

    private void toggle() {
        this.initPaperNumber();
        this.addPapers();
        this.updateButtons();
        this.setToolTip(this.myToggle, this.isSingleMode() ? this.i18n("TLT_Show_Multiple_Pages") : this.i18n("TLT_Show_First_Page"));
    }

    private int getPaperCount() {
        if (this.myPapers == null) {
            return 0;
        }
        return this.myPapers.size();
    }

    @Override
    public void invalidValue(String value) {
    }

    private void first() {
        this.initPaperNumber();
        this.changePaper();
    }

    private void previous() {
        if (this.myPaperNumber == 1) {
            return;
        }
        --this.myPaperNumber;
        this.changePaper();
    }

    private void next() {
        if (this.myPaperNumber == this.getPaperCount()) {
            return;
        }
        ++this.myPaperNumber;
        this.changePaper();
    }

    private void last() {
        this.myPaperNumber = this.getPaperCount();
        this.changePaper();
    }

    private void goTo() {
        String value = this.myGoto.getText();
        int number = this.getPaperNumber(value);
        int count = this.getPaperCount();
        if (number < 1 || number > count) {
            this.myGoto.setText(this.getPaper(this.myPaperNumber));
        } else {
            this.myPaperNumber = number;
            this.changePaper();
        }
        this.myGoto.selectAll();
    }

    private void changePaper() {
        if (this.isSingleMode()) {
            this.addPapers();
        } else {
            this.scrollTo();
        }
        this.updateButtons();
    }

    private void initPaperNumber() {
        this.myPaperNumber = this.getPaperCount() == 0 ? 0 : 1;
    }

    private int getGap() {
        return Util.round(20.0 * this.myScale.getValue());
    }

    private String getPaper(int value) {
        return String.valueOf(value) + " / " + String.valueOf(this.getPaperCount());
    }

    @Override
    protected void opened() {
        this.myScrollPane.requestFocus();
    }

    @Override
    protected void resized() {
        if (this.myScale.isCustomValue()) {
            this.showCustom(false);
        }
    }

    private boolean isSingleMode() {
        return !this.myToggle.isSelected();
    }

    private void option() {
        if (this.myOption == null) {
            this.myOption = new Option(this);
        }
        this.myOption.setVisible(true);
    }

    private void print() {
        String key;
        if (this.myPrinter == null) {
            this.myPrinter = new Printer();
        }
        if ((key = this.myPrinter.print(this)) != null) {
            this.printError(this.i18n(key));
        }
    }

    private int getPaperNumber(String text) {
        char c;
        String value = text.trim();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length() && Character.isDigit(c = value.charAt(i)); ++i) {
            builder.append(c);
        }
        return Util.getInt(builder.toString());
    }

    private boolean isCtrl(int modifiers) {
        return this.isModifier(modifiers, 2) || this.isModifier(modifiers, 4);
    }

    private boolean isModifier(int modifiers, int mask) {
        return (modifiers & mask) != 0;
    }
}

