/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.print.core.text.Attributes;
import oracle.ide.print.core.text.Symbol;
import oracle.ide.print.misc.Config;
import oracle.ide.print.misc.Util;

final class Line {
    private TextLayout myTextLayout;
    private List<Symbol> mySymbols = new ArrayList<Symbol>();

    Line(List<Symbol> symbols) {
        this.mySymbols = symbols;
        this.checkSpaces();
    }

    private void checkSpaces() {
        int i;
        for (i = this.length() - 1; i >= 1 && this.mySymbols.get(i).getChar() == ' '; --i) {
        }
        this.mySymbols = this.mySymbols.subList(0, i + 1);
        if (this.length() == 0) {
            this.mySymbols.add(Symbol.SPACE);
        }
    }

    void prepend(String text, Font font, Color color) {
        for (int i = text.length() - 1; i >= 0; --i) {
            this.mySymbols.add(0, new Symbol(text.charAt(i), font, color));
        }
    }

    boolean isEmpty() {
        for (int i = 0; i < this.length(); ++i) {
            if (this.mySymbols.get(i).getChar() == ' ') continue;
            return false;
        }
        return true;
    }

    int length() {
        return this.mySymbols.size();
    }

    Line substring(int index1, int index2) {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (int i = index1; i < index2; ++i) {
            list.add(this.mySymbols.get(i));
        }
        return new Line(list);
    }

    Line substring(int index) {
        return this.substring(index, this.mySymbols.size());
    }

    int getAscent() {
        return Util.round(this.getTextLayout().getAscent());
    }

    int getDescent() {
        return Util.round(this.getTextLayout().getDescent());
    }

    int getLeading() {
        return Util.round(this.getTextLayout().getLeading());
    }

    int getWidth() {
        int offset = this.getOffset();
        if (offset > 0) {
            offset = 0;
        }
        return Util.round(this.getTextLayout().getBounds().getMaxX() - (double)offset);
    }

    int getOffset() {
        return Util.round(this.getTextLayout().getBounds().getX());
    }

    void draw(Graphics2D g, int x, int y) {
        this.getTextLayout().draw(g, x, y);
    }

    private TextLayout getTextLayout() {
        if (this.myTextLayout == null) {
            this.myTextLayout = new TextLayout(this.getIterator(), Config.FONT_RENDER_CONTEXT);
        }
        return this.myTextLayout;
    }

    private AttributedCharacterIterator getIterator() {
        Attributes attributes = new Attributes();
        for (Symbol symbol : this.mySymbols) {
            attributes.add(symbol.getChar(), symbol.getFont(), symbol.getColor());
        }
        return attributes.iterator();
    }

    int lastIndexOf(char c, int index) {
        for (int i = index; i >= 0; --i) {
            if (this.mySymbols.get(i).getChar() != c) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Symbol symbol : this.mySymbols) {
            builder.append(symbol.getChar());
        }
        return builder.toString();
    }
}

