/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.print.core.Graphix;
import oracle.ide.print.core.text.Line;
import oracle.ide.print.core.text.Symbol;
import oracle.ide.print.misc.Util;

final class Document
extends JComponent {
    private int myWidth;
    private int myHeight;
    private int[] myCorrection;
    private int[] myAscent;
    private int[] myDescent;
    private int[] myLeading;
    private int myMinOffset;
    private Color myBackgroundColor;
    private double myLineSpacing;
    private boolean myWrapLines;
    private boolean myLineNumbers;
    private List<Line> myLines;

    Document(Symbol[] symbols) {
        this.init();
        this.prepare(symbols);
        this.processLines();
    }

    private void init() {
        this.myWrapLines = Util.getConfig().isWrapLongLines();
        this.myLineNumbers = Util.getConfig().hasLineNumbers();
        this.myBackgroundColor = Util.getConfig().getBackgroundColor();
        this.myLineSpacing = Util.getConfig().getLineSpacing();
        this.myLines = new ArrayList<Line>();
    }

    private void prepare(Symbol[] symbols) {
        LineTokenizer stk = new LineTokenizer(symbols);
        while (stk.hasMoreTokens()) {
            Line line = new Line(this.trimEnded(stk.nextToken()));
            this.myLines.add(line);
        }
    }

    private void processLines() {
        this.removeEmptyLinesAtTheEnd();
        if (this.myLineNumbers) {
            this.prepareLineNumbering();
        }
        this.calculateOffset();
        if (this.myWrapLines) {
            this.prepareWrapLines();
        } else {
            this.prepareNoWrapLines();
        }
        this.calculateMetrics();
    }

    private void removeEmptyLinesAtTheEnd() {
        Line line;
        int i = this.myLines.size() - 1;
        while (i >= 0 && (line = this.myLines.get(i--)).isEmpty()) {
            this.myLines.remove(line);
        }
    }

    private List<Symbol> trimEnded(List<Symbol> value) {
        int i;
        for (i = value.size() - 1; i >= 0 && value.get(i).getChar() == ' '; --i) {
        }
        return this.subarray(value, 0, i + 1);
    }

    private List<Symbol> subarray(List<Symbol> value, int lo, int hi) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (int k = lo; k < hi; ++k) {
            result.add(value.get(k));
        }
        return result;
    }

    private void prepareLineNumbering() {
        int length = (this.myLines.size() + "").length();
        int number = 1;
        Font font = Util.getConfig().getTextFont();
        Color color = Util.getConfig().getTextColor();
        for (Line line : this.myLines) {
            line.prepend(this.getNumber(number++, length), font, color);
        }
    }

    private void prepareNoWrapLines() {
        int maxWidth = 0;
        for (Line line : this.myLines) {
            int width = line.getWidth();
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        this.myWidth = maxWidth + this.myMinOffset;
    }

    private void prepareWrapLines() {
        this.myWidth = Util.getConfig().getPageWidth();
        ArrayList<Line> lines = new ArrayList<Line>();
        for (Line line : this.myLines) {
            if (line.getWidth() + this.myMinOffset <= this.myWidth) {
                lines.add(line);
                continue;
            }
            this.addWordWrappedLine(lines, line);
        }
        this.myLines = lines;
    }

    private void addWordWrappedLine(List<Line> lines, Line line) {
        block5: {
            int k;
            Line part;
            if (line.getWidth() + this.myMinOffset <= this.myWidth) {
                lines.add(line);
                return;
            }
            int last = line.length();
            do {
                if ((k = line.lastIndexOf(' ', last - 1)) == -1) {
                    this.addCharWrappedLine(lines, line);
                    break block5;
                }
                last = k;
                part = line.substring(0, k);
                this.checkOffset(part);
            } while (part.getWidth() + this.myMinOffset > this.myWidth);
            if (part.isEmpty()) {
                this.addCharWrappedLine(lines, line);
            } else {
                lines.add(part);
                part = line.substring(k + 1);
                this.checkOffset(part);
                this.addWordWrappedLine(lines, part);
            }
        }
    }

    private void addCharWrappedLine(List<Line> lines, Line line) {
        if (line.getWidth() + this.myMinOffset <= this.myWidth) {
            lines.add(line);
            return;
        }
        for (int k = line.length(); k >= 0; --k) {
            Line part = line.substring(0, k);
            this.checkOffset(part);
            if (part.getWidth() + this.myMinOffset > this.myWidth) continue;
            lines.add(part);
            part = line.substring(k);
            this.checkOffset(part);
            this.addCharWrappedLine(lines, part);
            break;
        }
    }

    private void checkOffset(Line line) {
        int offset = -line.getOffset();
        if (offset > this.myMinOffset) {
            this.myMinOffset = offset;
        }
    }

    private void calculateOffset() {
        this.myMinOffset = 0;
        for (Line line : this.myLines) {
            this.checkOffset(line);
        }
    }

    private void calculateMetrics() {
        int pageHeight;
        this.myHeight = 0;
        int size = this.myLines.size();
        this.myAscent = new int[size];
        this.myDescent = new int[size];
        this.myLeading = new int[size];
        this.myCorrection = new int[size];
        int breakPosition = pageHeight = Util.getConfig().getPageHeight();
        for (int i = 0; i < size; ++i) {
            Line line = this.myLines.get(i);
            this.myAscent[i] = Util.round((double)line.getAscent() * this.myLineSpacing);
            this.myDescent[i] = line.getDescent();
            this.myCorrection[i] = 0;
            int prevPos = this.myHeight;
            this.myHeight += this.myAscent[i] + this.myDescent[i];
            if (this.myHeight > breakPosition && prevPos < breakPosition) {
                this.myCorrection[i] = breakPosition - prevPos;
                this.myHeight += this.myCorrection[i];
                breakPosition += pageHeight;
            }
            if (i == size - 1) continue;
            this.myLeading[i] = line.getLeading();
            this.myHeight += this.myLeading[i];
        }
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = Graphix.adjustGraphics(graphics);
        g.setColor(this.myBackgroundColor);
        g.fillRect(0, 0, this.myWidth, this.myHeight);
        int y = 0;
        for (int i = 0; i < this.myLines.size(); ++i) {
            Line line = this.myLines.get(i);
            line.draw(g, this.myMinOffset, y += this.myCorrection[i] + this.myAscent[i]);
            y += this.myDescent[i] + this.myLeading[i];
        }
    }

    private String getNumber(int number, int length) {
        StringBuilder builder = new StringBuilder();
        builder.append(number);
        for (int i = builder.length(); i < length; ++i) {
            builder.insert(0, " ");
        }
        builder.append(" ");
        return builder.toString();
    }

    private static class LineTokenizer {
        private int myPos = 0;
        private int myLength;
        private Symbol[] myValue;

        LineTokenizer(Symbol[] value) {
            this.myValue = value;
            this.myLength = value.length;
        }

        boolean hasMoreTokens() {
            return this.myPos < this.myLength;
        }

        List<Symbol> nextToken() {
            ArrayList<Symbol> result = new ArrayList<Symbol>();
            while (this.myPos < this.myLength) {
                char c;
                if ((c = this.myValue[this.myPos++].getChar()) == '\r' || c == '\n') {
                    if (c != '\r' || this.myPos >= this.myLength || this.myValue[this.myPos].getChar() != '\n') break;
                    ++this.myPos;
                    break;
                }
                result.add(this.myValue[this.myPos - 1]);
            }
            return result;
        }
    }
}

