/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.comp;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.print.api.PrintPage;
import oracle.ide.print.api.PrintProvider;
import oracle.ide.print.core.comp.Page;
import oracle.ide.print.core.comp.Panel;
import oracle.ide.print.misc.Percent;
import oracle.ide.print.misc.Util;

public class Provider
implements PrintProvider {
    private String myName;
    private Component myPanel;

    public Provider(String name) {
        this.myName = name;
    }

    public Provider(Component component, String name) {
        this.myPanel = component;
        this.myName = this.getName(component, name);
    }

    public Provider(List<Component> components, String name) {
        this.myPanel = this.createPanel(this.createPages(components, name));
        this.myName = name;
    }

    public Provider(PrintPage page) {
        this(Collections.singletonList(page));
    }

    public Provider(List<PrintPage> pages) {
        this.myPanel = this.createPanel(pages);
    }

    private Component createPanel(List<PrintPage> pages) {
        return new Panel(pages);
    }

    private List<PrintPage> createPages(List<Component> components, String name) {
        Collections.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component component1, Component component2) {
                int order2;
                int order1 = this.getInt(component1);
                if (order1 < (order2 = this.getInt(component2))) {
                    return -1;
                }
                if (order1 > order2) {
                    return 1;
                }
                return 0;
            }

            private int getInt(Component component) {
                if (!(component instanceof JComponent)) {
                    return Integer.MIN_VALUE;
                }
                Object object = ((JComponent)component).getClientProperty("print.order");
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                return Integer.MIN_VALUE;
            }
        });
        ArrayList<PrintPage> pages = new ArrayList<PrintPage>();
        for (Component component : components) {
            pages.add(new Page(component));
            this.myName = this.getName(component, name);
        }
        return pages;
    }

    private String getName(Component component, String name) {
        if (!(component instanceof JComponent)) {
            return name;
        }
        Object object = ((JComponent)component).getClientProperty("print.name");
        if (object == null) {
            return name;
        }
        return object.toString();
    }

    protected Component getComponent() {
        return this.myPanel;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public PrintPage[][] getPages(int pageWidth, int pageHeight, double pageZoom) {
        ArrayList<Page> pages = new ArrayList<Page>();
        Component component = this.getComponent();
        if (component == null) {
            return new PrintPage[0][0];
        }
        int componentWidth = component.getWidth();
        int componentHeight = component.getHeight();
        double zoom = this.getZoom(pageZoom, pageWidth, pageHeight, componentWidth, componentHeight);
        componentWidth = Util.round((double)componentWidth * zoom);
        componentHeight = Util.round((double)componentHeight * zoom);
        int row = 0;
        int column = 0;
        for (int h = 0; h < componentHeight; h += pageHeight) {
            ++row;
            column = 0;
            for (int w = 0; w < componentWidth; w += pageWidth) {
                Rectangle piece = new Rectangle((++column - 1) * pageWidth, (row - 1) * pageHeight, pageWidth, pageHeight);
                pages.add(new Page(component, piece, zoom, row - 1, column - 1));
            }
        }
        PrintPage[][] printPages = new PrintPage[row][column];
        for (Page page : pages) {
            printPages[page.getRow()][page.getColumn()] = page;
        }
        return printPages;
    }

    private double getZoom(double zoom, int pageWidth, int pageHeight, int componentWidth, int componentHeight) {
        double factor = Percent.getZoomFactor(zoom, -1.0);
        if (0.0 < factor) {
            return factor;
        }
        if (Percent.isZoomPage(zoom)) {
            factor = 0.0;
        }
        int zoomWidth = Percent.getZoomWidth(zoom, -1);
        int zoomHeight = Percent.getZoomHeight(zoom, -1);
        if (factor == 0.0) {
            zoomWidth = 1;
            zoomHeight = 1;
        }
        return this.getZoom((double)(pageWidth * zoomWidth) / (double)componentWidth, (double)(pageHeight * zoomHeight) / (double)componentHeight);
    }

    private double getZoom(double widthZoom, double heightZoom) {
        if (widthZoom > 0.0 && heightZoom > 0.0) {
            return Math.min(widthZoom, heightZoom);
        }
        if (widthZoom < 0.0 && heightZoom > 0.0) {
            return heightZoom;
        }
        if (widthZoom > 0.0 && heightZoom < 0.0) {
            return widthZoom;
        }
        return 1.0;
    }
}

