/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.comp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import oracle.ide.print.api.PrintPage;

final class Page
implements PrintPage {
    private int myRow;
    private int myColumn;
    private double myZoom;
    private Rectangle myPiece;
    private Component myComponent;

    Page(Component component) {
        this(component, null, 1.0, 0, 0);
        this.myPiece = new Rectangle(this.getSize(component));
    }

    Page(Component component, Rectangle piece, double zoom, int row, int column) {
        this.myComponent = component;
        this.myPiece = piece;
        this.myZoom = zoom;
        this.myRow = row;
        this.myColumn = column;
    }

    int getRow() {
        return this.myRow;
    }

    int getColumn() {
        return this.myColumn;
    }

    @Override
    public Dimension getSize() {
        return this.myPiece.getSize();
    }

    @Override
    public void print(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics.create(0, 0, this.myPiece.width, this.myPiece.height);
        g.translate(-this.myPiece.x, -this.myPiece.y);
        g.scale(this.myZoom, this.myZoom);
        this.myComponent.print(g);
        g.dispose();
    }

    private Dimension getSize(Component component) {
        Object object;
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("print.size")) instanceof Dimension) {
            return (Dimension)object;
        }
        Dimension size = component.getSize();
        int width = Math.max(size.width, component.getWidth());
        int height = Math.max(size.height, component.getHeight());
        return new Dimension(width, height);
    }
}

