/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.IdeCore;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.boot.WebupdateStarter;
import oracle.ideimpl.webupdate.commandline.CommandLineUpdate;

public class WebupdateRunner
extends IdeRunner {
    public void runCommand(IdeStarter ideStarter) {
        WebupdateStarter starter = (WebupdateStarter)ideStarter;
        String[] arguments = starter.getArguments();
        ArrayList<String> unknownArguments = new ArrayList<String>();
        CommandLineUpdate updater = CommandLineUpdate.createWithoutProperties();
        boolean listAvailable = false;
        boolean verbose = false;
        for (int i = 0; i < arguments.length; ++i) {
            String args;
            String currentArg = arguments[i];
            if (currentArg.startsWith("-properties=")) {
                String file = currentArg.substring("-properites=".length());
                updater = CommandLineUpdate.createFromPropertiesFile((CommandLineUpdate)updater, (String)file);
                continue;
            }
            if ("-list".equals(currentArg) || "-l".equals(currentArg)) {
                listAvailable = true;
                continue;
            }
            if ("-ignore-invalid-bundles".equals(currentArg) || "-i".equals(currentArg)) {
                updater.setIgnoreInvalidBundles(true);
                continue;
            }
            if (currentArg.startsWith("-zips=") || currentArg.startsWith("-z=")) {
                args = currentArg.substring("-zips=".length());
                String[] zips = args.split(",");
                updater.addLocalBundles(Arrays.asList(zips));
                continue;
            }
            if (currentArg.startsWith("-bundles=") || currentArg.startsWith("-b=")) {
                args = currentArg.substring("-bundles=".length());
                String[] bundles = args.split(",");
                updater.addRemoteExtensions(Arrays.asList(bundles));
                continue;
            }
            if (currentArg.startsWith("-proxy=")) {
                args = currentArg.substring("-proxy=".length());
                String[] parts = args.split(":");
                updater.setHostName(parts[0]);
                if (parts.length > 1) {
                    updater.setPortNumber(parts[1]);
                    continue;
                }
                updater.setPortNumber("80");
                continue;
            }
            if (currentArg.equals("-verbose") || currentArg.equals("-v")) {
                updater.setVerbose(true);
                verbose = true;
                continue;
            }
            if (IdeCore.isFrameworkCommandLineOption((String)currentArg)) continue;
            unknownArguments.add(currentArg);
        }
        try {
            if (verbose && !unknownArguments.isEmpty()) {
                for (String s : unknownArguments) {
                    System.err.println("Unrecognized argument: " + s);
                }
            }
            if (listAvailable) {
                updater.showCommandsOnOuput();
            } else if (updater.validateOptions()) {
                updater.doUpdate();
            } else {
                System.err.println("To view help specify -help\nNo bundles specified: exiting");
            }
        }
        catch (InvalidLocalBundleException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

