/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.lang.reflect.Constructor;
import javax.swing.ImageIcon;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.wizard.Background;
import oracle.bali.ewt.wizard.BackgroundGradient;
import oracle.bali.ewt.wizard.BackgroundImage;
import oracle.bali.ewt.wizard.PaintCtxt;
import oracle.bali.ewt.wizard.WizardBackgroundHandler;

class BackgroundPainter
extends AbstractPainter {
    private static final int _sCENTER_INDEX = 4;
    private static final int[] _sEDGE_INDICES = new int[]{1, 5, 7, 3};
    private static final int[] _sCORNER_INDICES = new int[]{0, 2, 8, 6};
    private static BackgroundPainter _sInstance = new BackgroundPainter();

    public static BackgroundPainter getInstance() {
        return _sInstance;
    }

    private BackgroundPainter() {
    }

    public Dimension getMinimumSize(PaintContext context) {
        return null;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        if (context != null && context instanceof PaintCtxt) {
            Background bg = ((PaintCtxt)context).getBackground();
            this._paintGradient(bg, g, width, height);
            this._paintBackgroundImage(bg, g, width, height);
        }
    }

    private BufferedImage _toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = this._hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    private boolean _hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    private void _setInitialBoundary(ImageImpl impl, int width, int height, WizardBackgroundHandler.Position position) {
        BufferedImage icon = impl.image;
        if (impl.hStrech && icon.getWidth() > width) {
            icon = this._resize(icon, width, icon.getHeight());
        }
        if (impl.vStrech && icon.getHeight() > height) {
            icon = this._resize(icon, icon.getWidth(), height);
        }
        int iWidth = icon.getWidth();
        int iHeight = icon.getHeight();
        int ix = 0;
        int iw = 0;
        int iy = 0;
        int ih = 0;
        int diffx = iWidth - width;
        int diffy = iHeight - height;
        int posX = 0;
        int posY = 0;
        switch (position) {
            case TOP_LEFT_CORNER: 
            case CENTER_LEFT_EDGE: 
            case BOTTOM_LEFT_CORNER: {
                if (diffx > 0) {
                    ix = 0;
                    iw = width;
                } else {
                    ix = 0;
                    iw = iWidth;
                }
                posX = 0;
                break;
            }
            case TOP_CENTER_EDGE: 
            case CENTER: 
            case BOTTOM_CENTER_EDGE: {
                if (diffx > 0) {
                    ix = diffx / 2;
                    iw = width;
                    posX = 0;
                    break;
                }
                ix = 0;
                iw = iWidth;
                posX = -diffx / 2;
                break;
            }
            case TOP_RIGHT_CORNER: 
            case CENTER_RIGHT_EDGE: 
            case BOTTOM_RIGHT_CORNER: {
                if (diffx > 0) {
                    ix = diffx;
                    iw = width;
                    posX = 0;
                    break;
                }
                ix = 0;
                iw = iWidth;
                posX = -diffx;
            }
        }
        switch (position) {
            case TOP_LEFT_CORNER: 
            case TOP_CENTER_EDGE: 
            case TOP_RIGHT_CORNER: {
                if (diffy > 0) {
                    iy = 0;
                    ih = height;
                } else {
                    iy = 0;
                    ih = iHeight;
                }
                posY = 0;
                break;
            }
            case CENTER_LEFT_EDGE: 
            case CENTER: 
            case CENTER_RIGHT_EDGE: {
                if (diffy > 0) {
                    iy = diffy / 2;
                    ih = height;
                    posY = 0;
                    break;
                }
                iy = 0;
                ih = iHeight;
                posY = -diffy / 2;
                break;
            }
            case BOTTOM_LEFT_CORNER: 
            case BOTTOM_CENTER_EDGE: 
            case BOTTOM_RIGHT_CORNER: {
                if (diffy > 0) {
                    iy = diffy;
                    ih = height;
                    posY = 0;
                    break;
                }
                iy = 0;
                ih = iHeight;
                posY = -diffy;
            }
        }
        BufferedImage clipped = icon.getSubimage(ix, iy, iw, ih);
        impl.image = clipped;
        impl.posX = posX;
        impl.posY = posY;
        impl.width = iw;
        impl.height = ih;
    }

    private BufferedImage _resize(BufferedImage image, int width, int height) {
        int type = image.getType() == 0 ? 2 : image.getType();
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    private void _paintBackgroundImage(Background bg, Graphics g, int width, int height) {
        int i;
        WizardBackgroundHandler.Position position;
        int i2;
        BackgroundImage[] backgroundImages;
        BackgroundImage[] backgroundImageArray = backgroundImages = bg == null ? null : bg.getImages();
        if (backgroundImages == null) {
            return;
        }
        ImageImpl[] initialImages = new ImageImpl[9];
        ImageImpl impl = null;
        for (i2 = 0; i2 < 9; ++i2) {
            Image icon;
            position = WizardBackgroundHandler.findPosition(i2);
            BackgroundImage image = backgroundImages[i2];
            Image image2 = icon = image == null ? null : image.getIcon();
            if (icon == null) continue;
            WizardBackgroundHandler.Stretch stretch = image.getStretch();
            boolean isHStrech = stretch == WizardBackgroundHandler.Stretch.HORIZONTAL || stretch == WizardBackgroundHandler.Stretch.BOTH;
            boolean isVStrech = stretch == WizardBackgroundHandler.Stretch.VERTICAL || stretch == WizardBackgroundHandler.Stretch.BOTH;
            boolean isStretchNextPane = image.getImageBoundary() == WizardBackgroundHandler.ImageBoundary.PANE;
            impl = new ImageImpl(icon, isHStrech, isVStrech, isStretchNextPane);
            this._setInitialBoundary(impl, width, height, position);
            initialImages[i2] = impl;
        }
        block11: for (i2 = 0; i2 < 9; ++i2) {
            position = WizardBackgroundHandler.findPosition(i2);
            ImageImpl curr = null;
            ImageImpl prev = null;
            ImageImpl next = null;
            switch (position) {
                case TOP_LEFT_CORNER: {
                    curr = initialImages[WizardBackgroundHandler.Position.TOP_LEFT_CORNER.ordinal()];
                    next = initialImages[WizardBackgroundHandler.Position.TOP_CENTER_EDGE.ordinal()];
                    if (next == null) {
                        next = initialImages[WizardBackgroundHandler.Position.TOP_RIGHT_CORNER.ordinal()];
                    }
                    prev = null;
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = initialImages[WizardBackgroundHandler.Position.CENTER_LEFT_EDGE.ordinal()];
                    if (next == null) {
                        next = initialImages[WizardBackgroundHandler.Position.BOTTOM_LEFT_CORNER.ordinal()];
                    }
                    this._stretchImage(prev, curr, next, width, height, false);
                    continue block11;
                }
                case TOP_CENTER_EDGE: {
                    curr = initialImages[WizardBackgroundHandler.Position.TOP_CENTER_EDGE.ordinal()];
                    next = initialImages[WizardBackgroundHandler.Position.TOP_RIGHT_CORNER.ordinal()];
                    prev = initialImages[WizardBackgroundHandler.Position.TOP_LEFT_CORNER.ordinal()];
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = initialImages[WizardBackgroundHandler.Position.CENTER.ordinal()];
                    if (next == null) {
                        next = initialImages[WizardBackgroundHandler.Position.BOTTOM_CENTER_EDGE.ordinal()];
                    }
                    prev = null;
                    this._stretchImage(prev, curr, next, width, height, false);
                    continue block11;
                }
                case TOP_RIGHT_CORNER: {
                    curr = initialImages[WizardBackgroundHandler.Position.TOP_RIGHT_CORNER.ordinal()];
                    next = null;
                    prev = initialImages[WizardBackgroundHandler.Position.TOP_CENTER_EDGE.ordinal()];
                    if (prev == null) {
                        prev = initialImages[WizardBackgroundHandler.Position.TOP_LEFT_CORNER.ordinal()];
                    }
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = initialImages[WizardBackgroundHandler.Position.CENTER_RIGHT_EDGE.ordinal()];
                    if (next == null) {
                        next = initialImages[WizardBackgroundHandler.Position.BOTTOM_RIGHT_CORNER.ordinal()];
                    }
                    prev = null;
                    this._stretchImage(prev, curr, next, width, height, false);
                    continue block11;
                }
                case CENTER_LEFT_EDGE: {
                    curr = initialImages[WizardBackgroundHandler.Position.CENTER_LEFT_EDGE.ordinal()];
                    next = initialImages[WizardBackgroundHandler.Position.CENTER.ordinal()];
                    if (next == null) {
                        next = initialImages[WizardBackgroundHandler.Position.CENTER_RIGHT_EDGE.ordinal()];
                    }
                    prev = null;
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = initialImages[WizardBackgroundHandler.Position.BOTTOM_LEFT_CORNER.ordinal()];
                    prev = initialImages[WizardBackgroundHandler.Position.TOP_LEFT_CORNER.ordinal()];
                    this._stretchImage(prev, curr, next, width, height, false);
                    continue block11;
                }
                case CENTER_RIGHT_EDGE: {
                    curr = initialImages[WizardBackgroundHandler.Position.CENTER_RIGHT_EDGE.ordinal()];
                    next = null;
                    prev = initialImages[WizardBackgroundHandler.Position.CENTER.ordinal()];
                    if (prev == null) {
                        prev = initialImages[WizardBackgroundHandler.Position.CENTER_LEFT_EDGE.ordinal()];
                    }
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = initialImages[WizardBackgroundHandler.Position.BOTTOM_RIGHT_CORNER.ordinal()];
                    prev = initialImages[WizardBackgroundHandler.Position.TOP_RIGHT_CORNER.ordinal()];
                    this._stretchImage(prev, curr, next, width, height, false);
                    continue block11;
                }
                case BOTTOM_LEFT_CORNER: {
                    curr = initialImages[WizardBackgroundHandler.Position.BOTTOM_LEFT_CORNER.ordinal()];
                    next = initialImages[WizardBackgroundHandler.Position.BOTTOM_CENTER_EDGE.ordinal()];
                    if (next == null) {
                        next = initialImages[WizardBackgroundHandler.Position.BOTTOM_RIGHT_CORNER.ordinal()];
                    }
                    prev = null;
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = null;
                    prev = initialImages[WizardBackgroundHandler.Position.CENTER_LEFT_EDGE.ordinal()];
                    if (prev == null) {
                        prev = initialImages[WizardBackgroundHandler.Position.TOP_LEFT_CORNER.ordinal()];
                    }
                    this._stretchImage(prev, curr, next, width, height, false);
                    continue block11;
                }
                case BOTTOM_CENTER_EDGE: {
                    curr = initialImages[WizardBackgroundHandler.Position.BOTTOM_CENTER_EDGE.ordinal()];
                    next = initialImages[WizardBackgroundHandler.Position.BOTTOM_RIGHT_CORNER.ordinal()];
                    prev = initialImages[WizardBackgroundHandler.Position.BOTTOM_LEFT_CORNER.ordinal()];
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = null;
                    prev = initialImages[WizardBackgroundHandler.Position.CENTER.ordinal()];
                    if (prev == null) {
                        prev = initialImages[WizardBackgroundHandler.Position.TOP_CENTER_EDGE.ordinal()];
                    }
                    this._stretchImage(prev, curr, next, width, height, false);
                    continue block11;
                }
                case BOTTOM_RIGHT_CORNER: {
                    curr = initialImages[WizardBackgroundHandler.Position.BOTTOM_RIGHT_CORNER.ordinal()];
                    next = null;
                    prev = initialImages[WizardBackgroundHandler.Position.BOTTOM_CENTER_EDGE.ordinal()];
                    if (prev == null) {
                        prev = initialImages[WizardBackgroundHandler.Position.BOTTOM_LEFT_CORNER.ordinal()];
                    }
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = null;
                    prev = initialImages[WizardBackgroundHandler.Position.CENTER_RIGHT_EDGE.ordinal()];
                    if (prev == null) {
                        prev = initialImages[WizardBackgroundHandler.Position.TOP_RIGHT_CORNER.ordinal()];
                    }
                    this._stretchImage(prev, curr, next, width, height, false);
                    continue block11;
                }
                default: {
                    curr = initialImages[WizardBackgroundHandler.Position.CENTER.ordinal()];
                    next = initialImages[WizardBackgroundHandler.Position.CENTER_RIGHT_EDGE.ordinal()];
                    prev = initialImages[WizardBackgroundHandler.Position.CENTER_LEFT_EDGE.ordinal()];
                    this._stretchImage(prev, curr, next, width, height, true);
                    next = initialImages[WizardBackgroundHandler.Position.BOTTOM_CENTER_EDGE.ordinal()];
                    prev = initialImages[WizardBackgroundHandler.Position.TOP_CENTER_EDGE.ordinal()];
                    this._stretchImage(prev, curr, next, width, height, false);
                }
            }
        }
        ImageImpl impl1 = null;
        impl = initialImages[4];
        if (impl1 != null) {
            g.drawImage(impl1.image, impl1.posX, impl1.posY, impl1.width, impl1.height, null);
        }
        int len = _sEDGE_INDICES.length;
        for (i = 0; i < len; ++i) {
            impl1 = initialImages[_sEDGE_INDICES[i]];
            if (impl1 == null) continue;
            g.drawImage(impl1.image, impl1.posX, impl1.posY, impl1.width, impl1.height, null);
        }
        len = _sCORNER_INDICES.length;
        for (i = 0; i < len; ++i) {
            impl1 = initialImages[_sCORNER_INDICES[i]];
            if (impl1 == null) continue;
            g.drawImage(impl1.image, impl1.posX, impl1.posY, impl1.width, impl1.height, null);
        }
    }

    private void _stretchImage(ImageImpl prev, ImageImpl curr, ImageImpl next, int width, int height, boolean dir) {
        int diffX = 0;
        int diffY = 0;
        float fraction = 0.0f;
        if (dir) {
            if (curr != null && curr.hStrech) {
                if (curr.nextPane) {
                    curr.posX = 0;
                    curr.width = width;
                } else {
                    ImageImpl imageImpl;
                    if (prev == null) {
                        imageImpl = curr;
                        imageImpl.width = imageImpl.width + curr.posX;
                        curr.posX = 0;
                    } else {
                        diffX = curr.posX - (prev.posX + prev.width);
                        if (diffX > 0) {
                            if (prev.hStrech) {
                                fraction = (float)curr.width / (float)(curr.width + prev.width);
                                imageImpl = prev;
                                imageImpl.width = (int)((float)imageImpl.width + (float)diffX * (1.0f - fraction));
                                imageImpl = curr;
                                imageImpl.posX = (int)((float)imageImpl.posX - ((float)diffX * fraction + 1.0f));
                                imageImpl = curr;
                                imageImpl.width = (int)((float)imageImpl.width + ((float)diffX * fraction + 1.0f));
                            } else {
                                imageImpl = curr;
                                imageImpl.posX = imageImpl.posX - diffX;
                                imageImpl = curr;
                                imageImpl.width = imageImpl.width + diffX;
                            }
                        }
                    }
                    if (next == null) {
                        imageImpl = curr;
                        imageImpl.width = imageImpl.width + (width - (curr.posX + curr.width));
                    } else {
                        diffX = next.posX - (curr.posX + curr.width);
                        if (diffX > 0) {
                            if (next.hStrech) {
                                fraction = (float)curr.width / (float)(curr.width + next.width);
                                imageImpl = curr;
                                imageImpl.width = (int)((float)imageImpl.width + (float)diffX * fraction);
                                imageImpl = next;
                                imageImpl.posX = (int)((float)imageImpl.posX - ((float)diffX * (1.0f - fraction) + 1.0f));
                                imageImpl = next;
                                imageImpl.width = (int)((float)imageImpl.width + ((float)diffX * (1.0f - fraction) + 1.0f));
                            } else {
                                imageImpl = curr;
                                imageImpl.width = imageImpl.width + diffX;
                            }
                        }
                    }
                }
            }
        } else if (curr != null && curr.vStrech) {
            if (curr.nextPane) {
                curr.posY = 0;
                curr.height = height;
            } else {
                ImageImpl imageImpl;
                if (prev == null) {
                    imageImpl = curr;
                    imageImpl.height = imageImpl.height + curr.posY;
                    curr.posY = 0;
                } else {
                    diffY = curr.posY - (prev.posY + prev.height);
                    if (diffY > 0) {
                        if (prev.vStrech) {
                            fraction = (float)curr.width / (float)(curr.width + prev.width);
                            imageImpl = prev;
                            imageImpl.height = (int)((float)imageImpl.height + (float)diffY * (1.0f - fraction));
                            imageImpl = curr;
                            imageImpl.posY = (int)((float)imageImpl.posY - ((float)diffY * fraction + 1.0f));
                            imageImpl = curr;
                            imageImpl.height = (int)((float)imageImpl.height + ((float)diffY * fraction + 1.0f));
                        } else {
                            imageImpl = curr;
                            imageImpl.posY = imageImpl.posY - diffY;
                            imageImpl = curr;
                            imageImpl.height = imageImpl.height + diffY;
                        }
                    }
                }
                if (next == null) {
                    imageImpl = curr;
                    imageImpl.height = imageImpl.height + (height - (curr.posY + curr.height));
                } else {
                    diffY = next.posY - (curr.posY + curr.height);
                    if (diffY > 0) {
                        if (next.vStrech) {
                            fraction = (float)curr.width / (float)(curr.width + next.width);
                            imageImpl = curr;
                            imageImpl.height = (int)((float)imageImpl.height + (float)diffY * fraction);
                            imageImpl = next;
                            imageImpl.posY = (int)((float)imageImpl.posY - ((float)diffY * (1.0f - fraction) + 1.0f));
                            imageImpl = next;
                            imageImpl.height = (int)((float)imageImpl.height + ((float)diffY * (1.0f - fraction) + 1.0f));
                        } else {
                            imageImpl = curr;
                            imageImpl.height = imageImpl.height + diffY;
                        }
                    }
                }
            }
        }
    }

    private void _paintGradient(Background bg, Graphics g, int width, int height) {
        BackgroundGradient gradient;
        BackgroundGradient backgroundGradient = gradient = bg == null ? null : bg.getGradient();
        if (gradient == null) {
            return;
        }
        Color first = gradient.getFirst();
        Color second = gradient.getSecond();
        if (first == null || second == null) {
            return;
        }
        if (g instanceof Graphics2D) {
            Paint grad = null;
            switch (gradient.getType()) {
                case HORIZONTAL: {
                    grad = new GradientPaint(0.0f, 0.0f, first, width, 0.0f, second);
                    break;
                }
                case BACKSLASH: {
                    grad = new GradientPaint(0.0f, 0.0f, first, width, height, second);
                    break;
                }
                case SLASH: {
                    grad = new GradientPaint(0.0f, height, first, width, 0.0f, second);
                    break;
                }
                case RADIAL: {
                    Point2D.Float center = new Point2D.Float(width / 2, height / 2);
                    float radius = Math.max(width / 2, height / 2);
                    float[] dist = new float[]{0.0f, 1.0f};
                    Color[] colors = new Color[]{first, second};
                    try {
                        Class<?> c = Class.forName("java.awt.RadialGradientPaint");
                        if (c == null) break;
                        Constructor<?> ct = c.getConstructor(Point2D.class, Float.TYPE, float[].class, Color[].class);
                        grad = (Paint)ct.newInstance(center, Float.valueOf(radius), dist, colors);
                    }
                    catch (Throwable e) {
                        System.err.println(e);
                    }
                    break;
                }
                default: {
                    grad = new GradientPaint(0.0f, 0.0f, first, 0.0f, height, second);
                }
            }
            if (grad == null) {
                return;
            }
            ((Graphics2D)g).setPaint(grad);
            g.fillRect(0, 0, width, height);
        }
    }

    private class ImageImpl {
        private BufferedImage image;
        private int posX;
        private int posY;
        private int width;
        private int height;
        private boolean vStrech;
        private boolean hStrech;
        private boolean nextPane = true;

        public ImageImpl(Image image, boolean hStrech, boolean vStrech, boolean nextPane) {
            this.image = BackgroundPainter.this._toBufferedImage(image);
            this.hStrech = hStrech;
            this.vStrech = vStrech;
            this.nextPane = nextPane;
        }
    }
}

