/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.share.datatransfer.ObjectTransferable;

public class TreePicker
implements ItemPicker {
    private ActionListener _actionListener;
    private PropertyChangeSupport _changeSupport;
    private JTree _tree;
    private JScrollPane _pane;
    private Handler _handler;

    public TreePicker(JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Tree cannot be null");
        }
        this._tree = tree;
        this._handler = new Handler();
        this._pane = new JScrollPane(tree);
        this._tree.addTreeSelectionListener(this._handler);
        this._tree.addMouseListener(this._handler);
        this._tree.addKeyListener(this._handler);
    }

    public JTree getTree() {
        return this._tree;
    }

    public void dispose() {
        this._pane.setViewportView(null);
        this._pane = null;
        this._tree.removeTreeSelectionListener(this._handler);
        this._tree.removeMouseListener(this._handler);
        this._tree.removeKeyListener(this._handler);
        this._changeSupport = null;
        this._handler = null;
        this._tree = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(listener);
        }
    }

    public boolean isSelectableItemPresent() {
        return this._tree.getModel().getChildCount(this._tree.getModel().getRoot()) != 0;
    }

    public boolean isItemSelected() {
        return this._tree.getSelectionCount() > 0;
    }

    public void deselectAll() {
        this._tree.getSelectionModel().clearSelection();
    }

    public boolean addSelectedItems(Transferable[] selectedItems) {
        if (selectedItems != null) {
            block2: for (Transferable curr : selectedItems) {
                DataFlavor[] flavors = curr.getTransferDataFlavors();
                if (flavors == null) continue;
                for (DataFlavor f : flavors) {
                    try {
                        int i;
                        Object data = curr.getTransferData(f);
                        TreePath path = (TreePath)data;
                        Object[] nodes = path.getPath();
                        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
                        Object pparent = null;
                        int index = -1;
                        ArrayList<Object> pathElements = new ArrayList<Object>();
                        for (i = 0; i < nodes.length; ++i) {
                            if (i == 0) {
                                if (!((DefaultMutableTreeNode)nodes[i]).getUserObject().equals(((DefaultMutableTreeNode)model.getRoot()).getUserObject())) break;
                                pparent = model.getRoot();
                                pathElements.add(pparent);
                                index = i;
                                continue;
                            }
                            if (pparent == null) continue;
                            int count = model.getChildCount(pparent);
                            boolean found = false;
                            for (int j = 0; j < count; ++j) {
                                DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(pparent, j);
                                if (!child.getUserObject().equals(((DefaultMutableTreeNode)nodes[i]).getUserObject())) continue;
                                pparent = child;
                                index = i;
                                found = true;
                                break;
                            }
                            if (!found) break;
                            pathElements.add(pparent);
                        }
                        if (index != -1 && index == nodes.length - 1) {
                            DefaultMutableTreeNode fromChild = (DefaultMutableTreeNode)nodes[index];
                            this._recursivelyAddChildren(fromChild, pparent, model, pathElements);
                        } else {
                            for (i = index + 1; i < nodes.length; ++i) {
                                if (i == 0) {
                                    model.setRoot((TreeNode)nodes[i]);
                                    pparent = model.getRoot();
                                    pathElements.add(pparent);
                                    continue;
                                }
                                if (i == nodes.length - 1) {
                                    int k;
                                    DefaultMutableTreeNode fromChild = (DefaultMutableTreeNode)nodes[i];
                                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(fromChild.getUserObject());
                                    int ccount = fromChild.getChildCount();
                                    DefaultMutableTreeNode[] children = new DefaultMutableTreeNode[ccount];
                                    for (k = 0; k < ccount; ++k) {
                                        children[k] = (DefaultMutableTreeNode)fromChild.getChildAt(k);
                                    }
                                    for (k = 0; k < ccount; ++k) {
                                        child.add(children[k]);
                                    }
                                    model.insertNodeInto(child, (DefaultMutableTreeNode)pparent, model.getChildCount(pparent));
                                    pathElements.add(child);
                                    pparent = nodes[i];
                                    continue;
                                }
                                DefaultMutableTreeNode child = new DefaultMutableTreeNode(((DefaultMutableTreeNode)nodes[i]).getUserObject());
                                model.insertNodeInto(child, (DefaultMutableTreeNode)pparent, model.getChildCount(pparent));
                                pathElements.add(child);
                                pparent = child;
                            }
                        }
                        Object[] paths = pathElements.toArray();
                        TreePath p = new TreePath(paths);
                        this._tree.makeVisible(p);
                        this._tree.revalidate();
                        continue block2;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return true;
    }

    public void removeSelectedItems() {
        TreePath[] paths = this._tree.getSelectionPaths();
        if (paths != null) {
            DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
            for (int i = 0; i < paths.length; ++i) {
                MutableTreeNode node = (MutableTreeNode)paths[i].getLastPathComponent();
                MutableTreeNode parent = (MutableTreeNode)node.getParent();
                if (parent == null) continue;
                model.removeNodeFromParent(node);
            }
        }
    }

    public void removeAllSelectableItems() {
        int i;
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        Object root = model.getRoot();
        int count = model.getChildCount(root);
        Object[] children = new Object[count];
        for (i = 0; i < count; ++i) {
            children[i] = model.getChild(root, i);
        }
        for (i = 0; i < count; ++i) {
            model.removeNodeFromParent((MutableTreeNode)children[i]);
        }
        this._tree.setModel(null);
        this._tree.setModel(model);
        this._tree.revalidate();
    }

    public Transferable[] getSelectedItems() {
        TreePath[] paths = this._tree.getSelectionPaths();
        if (paths == null) {
            return new Transferable[0];
        }
        Transferable[] trans = new Transferable[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            trans[i] = ObjectTransferable.createTransferable((Object)paths[i]);
        }
        return trans;
    }

    public Transferable[] getAllSelectableItems() {
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        Object root = model.getRoot();
        TreePath rootPath = new TreePath(root);
        Transferable[] trans = new Transferable[]{ObjectTransferable.createTransferable((Object)rootPath)};
        return trans;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        return null;
    }

    public boolean canAcceptFlavors(DataFlavor[] flavors) {
        return true;
    }

    public Component getComponent() {
        return this._pane;
    }

    public synchronized void addActionListener(ActionListener l) {
        this._actionListener = AWTEventMulticaster.add(this._actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this._actionListener = AWTEventMulticaster.remove(this._actionListener, l);
        if (this._actionListener == null) {
            this._tree.removeMouseListener(this._handler);
        }
    }

    private void _recursivelyAddChildren(DefaultMutableTreeNode fromChild, Object pparent, DefaultTreeModel model, ArrayList pathElements) {
        int ccount = fromChild.getChildCount();
        DefaultMutableTreeNode[] children = new DefaultMutableTreeNode[ccount];
        for (int k = 0; k < ccount; ++k) {
            children[k] = (DefaultMutableTreeNode)fromChild.getChildAt(k);
        }
        DefaultMutableTreeNode tochild = (DefaultMutableTreeNode)pparent;
        int cccount = tochild.getChildCount();
        DefaultMutableTreeNode[] tochildren = new DefaultMutableTreeNode[cccount];
        for (int l = 0; l < cccount; ++l) {
            tochildren[l] = (DefaultMutableTreeNode)tochild.getChildAt(l);
        }
        for (int k = 0; k < ccount; ++k) {
            boolean found = false;
            for (int l = 0; l < cccount; ++l) {
                if (!children[k].getUserObject().equals(tochildren[l].getUserObject())) continue;
                found = true;
                pparent = tochildren[l];
                break;
            }
            if (!found) {
                model.insertNodeInto(children[k], tochild, model.getChildCount(tochild));
                pathElements.add(children[k]);
                continue;
            }
            this._recursivelyAddChildren(children[k], pparent, model, pathElements);
        }
    }

    private class Handler
    extends MouseAdapter
    implements TreeSelectionListener,
    KeyListener {
        private Handler() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePicker.this._changeSupport.firePropertyChange("selection", Boolean.FALSE, Boolean.TRUE);
        }

        public void mouseClicked(MouseEvent me) {
            int selRow;
            if (me.getClickCount() % 2 == 0 && SwingUtilities.isLeftMouseButton(me) && (selRow = TreePicker.this._tree.getRowForLocation(me.getX(), me.getY())) != -1 && TreePicker.this._tree.getModel().isLeaf(TreePicker.this._tree.getPathForRow(selRow).getLastPathComponent())) {
                TreePicker.this._actionListener.actionPerformed(new ActionEvent(TreePicker.this, me.getID(), null, me.getModifiers()));
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.getModifiers() == 0 && TreePicker.this._tree.getSelectionCount() != 0 && TreePicker.this._actionListener != null) {
                e.consume();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.getModifiers() == 0 && TreePicker.this._tree.getSelectionCount() != 0 && TreePicker.this._actionListener != null && TreePicker.this._tree.getModel().getChildCount(TreePicker.this._tree.getModel().getRoot()) > 0) {
                TreePicker.this._actionListener.actionPerformed(new ActionEvent(TreePicker.this, 1001, null));
                e.consume();
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

