/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTable;

public class PivotHeaderInputHandler
extends ProxyInputHandler {
    public PivotHeaderInputHandler() {
        super(NullInputHandler.getCellInputHandler());
    }

    public void mouseExited(MouseEvent e, Grid grid, int column, int row) {
        grid.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseMoved(MouseEvent e, Grid grid, int column, int row) {
        if (e.isConsumed()) {
            return;
        }
        PivotHeader header = this.getHeader(grid);
        AbstractPivotHeaderCell cell = header.getPivotHeaderCell(column, row);
        if (cell != null) {
            Cursor newCursor;
            Point p = AbstractBigCell.convertPoint(grid, cell, column, row, e.getX(), e.getY());
            int newColumn = cell.getColumn();
            int newRow = cell.getRow();
            Cursor oldCursor = grid.getCursor();
            if (oldCursor != (newCursor = header.isDrill(newColumn, newRow, p.x, p.y) ? header.getDrillCursor(newColumn, newRow) : Cursor.getDefaultCursor())) {
                grid.setCursor(newCursor);
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            super.mouseMoved(e, grid, column, row);
        }
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        if (e.isConsumed()) {
            return;
        }
        boolean left = SwingUtilities.isLeftMouseButton(e);
        if (!left) {
            return;
        }
        PivotHeader header = this.getHeader(grid);
        AbstractPivotHeaderCell cell = header.getPivotHeaderCell(column, row);
        if (cell != null) {
            boolean drillable = header.isDrillable(column, row);
            boolean collapsable = drillable ? false : header.isCollapsable(column, row);
            Point p = AbstractBigCell.convertPoint(grid, cell, column, row, e.getX(), e.getY());
            if ((drillable || collapsable) && header.isDrill(cell.getColumn(), cell.getRow(), p.x, p.y)) {
                if (drillable) {
                    header.fireHeaderCellDrillRequest(column, row);
                } else {
                    header.fireCollapse(column, row);
                }
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            super.mousePressed(e, grid, column, row);
        }
    }

    public void keyPressed(KeyEvent e, Grid grid, int column, int row) {
        if (e.isConsumed()) {
            return;
        }
        PivotHeader header = this.getHeader(grid);
        AbstractPivotHeaderCell cell = header.getPivotHeaderCell(column, row);
        if (cell != null) {
            boolean controlOrAltDown;
            boolean drillable = header.isDrillable(column, row);
            boolean collapsable = drillable ? false : header.isCollapsable(column, row);
            boolean bl = controlOrAltDown = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? e.isControlDown() : e.isAltDown();
            if (drillable && controlOrAltDown && e.getKeyCode() == 40) {
                header.fireHeaderCellDrillRequest(column, row);
                e.consume();
            } else if (collapsable & controlOrAltDown & e.getKeyCode() == 38) {
                header.fireCollapse(column, row);
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            super.keyPressed(e, grid, column, row);
        }
    }

    protected PivotHeader getHeader(Grid grid) {
        Container parent = grid.getParent();
        PivotHeader header = null;
        if (parent instanceof PivotHeader) {
            header = (PivotHeader)parent;
        } else if (parent instanceof PivotScrollPaneView) {
            PivotScrollPaneView view = (PivotScrollPaneView)parent;
            PivotTable table = view.getPivotTable();
            header = table.getPivotHeader(view.getOrientation());
        }
        return header;
    }
}

