/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotValidateEvent;
import oracle.bali.ewt.table.TableEvent;

class GridResizer
extends MouseAdapter
implements MouseMotionListener {
    private static final int _TARGET = 5;
    private static final int _MIN_SIZE = 2;
    private int _resizeItem = -1;
    private int _resizeOffset;
    private boolean _itemResized;
    private int _column;
    private int _row;
    private PivotHeader _header;

    public GridResizer(PivotHeader header) {
        this._header = header;
        this._header.getGrid().addMouseListener(this);
        this._header.getGrid().addMouseMotionListener(this);
    }

    public void dispose() {
        this._header.getGrid().removeMouseListener(this);
        this._header.getGrid().removeMouseMotionListener(this);
        this._header = null;
    }

    public void mouseMoved(MouseEvent e) {
        int y;
        if (e.isConsumed() || !this._header.isEnabled()) {
            return;
        }
        Grid grid = this._header.getGrid();
        Point canvasPoint = grid.convertOuterToCanvas(e.getX(), e.getY());
        int column = grid.getColumnAt(canvasPoint.x);
        int row = grid.getRowAt(canvasPoint.y);
        if (column < 0 || row < 0) {
            grid.setCursor(Cursor.getDefaultCursor());
            return;
        }
        Point origin = grid.getCanvasOrigin();
        int x = e.getX() + -origin.x - grid.getColumnPosition(column);
        if (this._isResizing(grid, column, row, x, y = e.getY() + -origin.y - grid.getRowPosition(row)) != -1) {
            grid.setCursor(this._getResizeCursor());
            e.consume();
        } else {
            grid.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.isConsumed() || !this._header.isEnabled()) {
            return;
        }
        boolean left = SwingUtilities.isLeftMouseButton(e);
        if (!left) {
            return;
        }
        Grid grid = this._header.getGrid();
        Point canvasPoint = grid.convertOuterToCanvas(e.getX(), e.getY());
        int column = grid.getColumnAt(canvasPoint.x);
        int row = grid.getRowAt(canvasPoint.y);
        if (column < 0 || row < 0) {
            return;
        }
        Point origin = grid.getCanvasOrigin();
        int x = e.getX() + -origin.x - grid.getColumnPosition(column);
        int y = e.getY() + -origin.y - grid.getRowPosition(row);
        this._resizeItem = this._isResizing(grid, column, row, x, y);
        if (this._resizeItem != -1) {
            int r;
            int c;
            int id;
            boolean horizontal = GridResizer._isHorizontal(this._header);
            if (horizontal) {
                id = 2001;
                c = this._resizeItem;
                r = -1;
            } else {
                id = 2003;
                c = -1;
                r = this._resizeItem;
            }
            if (this._fireCancelableTableEvent(id, c, r)) {
                this._header.getGrid().setCursor(this._getResizeCursor());
                this._header.setResizeItem(this._resizeItem);
                this._resizeOffset = horizontal ? canvasPoint.x - (grid.getColumnPosition(this._resizeItem) + grid.getColumnWidth(this._resizeItem)) : canvasPoint.y - (grid.getRowPosition(this._resizeItem) + grid.getRowHeight(this._resizeItem));
                this._column = column;
                this._row = row;
                PivotTable table = this._header.getPivotTable();
                if (table != null) {
                    table.getPivotGrid().setCurrentlyResizing(true);
                }
                e.consume();
            } else {
                this._header.getGrid().setCursor(Cursor.getDefaultCursor());
                this._resizeItem = -1;
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            this._itemResized = true;
            this._setSize(e, false);
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            int r;
            int c;
            int id;
            PivotTable table = this._header.getPivotTable();
            if (table != null) {
                table.getPivotGrid().setCurrentlyResizing(false);
            }
            if (this._itemResized) {
                this._setSize(e, true);
                this._itemResized = false;
            } else {
                this._header.setResizeItem(-1);
            }
            if (GridResizer._isHorizontal(this._header)) {
                id = 2002;
                c = this._resizeItem;
                r = -1;
            } else {
                id = 2004;
                c = -1;
                r = this._resizeItem;
            }
            this._fireTableEvent(id, c, r);
            this._header.getGrid().setCursor(Cursor.getDefaultCursor());
            e.consume();
        }
        this._resizeItem = -1;
        this._resizeOffset = 0;
    }

    private int _isResizing(Grid grid, int column, int row, int x, int y) {
        Header header;
        PivotTable table = this._header.getPivotTable();
        if (table == null) {
            return -1;
        }
        PivotGrid pg = table.getPivotGrid();
        boolean horizontal = GridResizer._isHorizontal(this._header);
        Header header2 = header = horizontal ? pg.getColumnHeader() : pg.getRowHeader();
        if (!header.getCanResizeItems()) {
            return -1;
        }
        int index = 0;
        index = horizontal ? row : column;
        if (!this._header.isLevelResizable(index)) {
            return -1;
        }
        AbstractBigCell cell = AbstractBigCell.getBigCell(grid, column, row);
        if (cell != null) {
            return this._isResizing(grid, column, row, cell, x, y);
        }
        return -1;
    }

    private int _isResizing(Grid grid, int column, int row, AbstractBigCell cell, int x, int y) {
        boolean firstEdge;
        int index;
        int startIndex;
        int point;
        Point p = this._convertPoint(grid, cell, column, row, x, y);
        boolean horizontal = GridResizer._isHorizontal(this._header);
        if (horizontal) {
            point = p.x;
            startIndex = grid.getNextVisibleColumn(cell.getColumn() - 1);
            index = grid.getPreviousVisibleColumn(startIndex + cell.getColumnCount());
        } else {
            point = p.y;
            startIndex = grid.getNextVisibleRow(cell.getRow() - 1);
            index = grid.getPreviousVisibleRow(startIndex + cell.getRowCount());
        }
        int size = horizontal ? this._getWidth(grid, cell) : this._getHeight(grid, cell);
        boolean lastEdge = point >= size - 5;
        boolean bl = firstEdge = point >= 0 && point <= 5;
        if (!lastEdge && !firstEdge) {
            return -1;
        }
        if (lastEdge) {
            return index;
        }
        if (firstEdge) {
            int temp;
            int n = temp = horizontal ? grid.getPreviousVisibleColumn(startIndex) : grid.getPreviousVisibleRow(startIndex);
            if (temp >= 0) {
                return temp;
            }
        }
        return -1;
    }

    private void _setSize(MouseEvent e, boolean finish) {
        Grid grid = this._header.getGrid();
        Point origin = grid.getCanvasOrigin();
        int x = e.getX() + -origin.x - grid.getColumnPosition(this._column);
        int y = e.getY() + -origin.y - grid.getRowPosition(this._row);
        AbstractBigCell cell = AbstractBigCell.getBigCell(grid, this._column, this._row);
        if (cell == null) {
            this._setSize(grid, this._column, this._row, x, y, finish);
        } else {
            this._setSize(grid, this._column, this._row, cell, x, y, finish);
        }
    }

    private void _setSize(Grid grid, int column, int row, int x, int y, boolean finish) {
    }

    private void _setSize(Grid grid, int column, int row, AbstractBigCell cell, int x, int y, boolean finish) {
        PivotTable table = this._header.getPivotTable();
        int size = 0;
        if (GridResizer._isHorizontal(this._header)) {
            int maxSize;
            int index;
            if (column != this._resizeItem) {
                cell = AbstractBigCell.getBigCell(grid, this._resizeItem, row);
            }
            size = (index = grid.getPreviousVisibleColumn(cell.getColumn() + cell.getColumnCount())) == column ? x : this._header.getColumnWidth(index) + x;
            int minSize = this._header.getGrid().getColumnGeometryManager().getMinimumItemSize(index);
            if ((size -= this._resizeOffset) < minSize) {
                size = minSize;
            }
            if (size > (maxSize = this._header.getGrid().getColumnGeometryManager().getMaximumItemSize(index))) {
                size = maxSize;
            }
            if (finish && table.getEqualSizedColumns()) {
                table.tryDefaultColumns();
                this._header.setColumnWidth(index, -1);
                this.trySetColumnWidth(index, -1, false);
                table.setDefaultColumnWidth(size);
            } else {
                table.setColumnWidth(index, size);
            }
        } else {
            int maxSize;
            int index;
            if (row != this._resizeItem) {
                cell = AbstractBigCell.getBigCell(grid, column, this._resizeItem);
            }
            size = (index = grid.getPreviousVisibleRow(cell.getRow() + cell.getRowCount())) == row ? y : this._header.getRowHeight(index) + y;
            int minSize = this._header.getGrid().getRowGeometryManager().getMinimumItemSize(index);
            if ((size -= this._resizeOffset) < minSize) {
                size = minSize;
            }
            if (size > (maxSize = this._header.getGrid().getRowGeometryManager().getMaximumItemSize(index))) {
                size = maxSize;
            }
            if (finish && table.getEqualSizedRows()) {
                table.tryDefaultRows();
                this._header.setRowHeight(index, -1);
                this.trySetRowHeight(index, -1);
                table.setDefaultRowHeight(size);
            } else {
                table.setRowHeight(index, size);
            }
        }
        if (finish) {
            this._header.setResizeItem(-1);
        }
    }

    private int _getWidth(Grid grid, AbstractBigCell cell) {
        int width = 0;
        int start = cell.getColumn();
        int count = cell.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (!grid.isColumnVisible(i + start)) continue;
            width += grid.getColumnWidth(i + start);
        }
        return width;
    }

    private int _getHeight(Grid grid, AbstractBigCell cell) {
        int height = 0;
        int start = cell.getRow();
        int count = cell.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (!grid.isRowVisible(i + start)) continue;
            height += grid.getRowHeight(i + start);
        }
        return height;
    }

    private Cursor _getResizeCursor() {
        if (GridResizer._isHorizontal(this._header)) {
            return Cursor.getPredefinedCursor(10);
        }
        return Cursor.getPredefinedCursor(9);
    }

    private static boolean _isHorizontal(PivotHeader header) {
        return header.getOrientation() == 0;
    }

    private void trySetColumnWidth(int index, int size, boolean checkl2r) {
        PivotGrid grid = this._header.getPivotTable().getPivotGrid();
        int count = grid.getGrid().getColumnCount();
        if (index < count) {
            grid.setColumnWidth(index, size);
        }
    }

    private void trySetRowHeight(int index, int size) {
        PivotGrid grid = this._header.getPivotTable().getPivotGrid();
        int count = grid.getGrid().getRowCount();
        if (index < count) {
            grid.setRowHeight(index, size);
        }
    }

    private boolean _fireCancelableTableEvent(int id, int column, int row) {
        PivotTable pivot = this._header.getPivotTable();
        PivotValidateEvent event = new PivotValidateEvent(pivot, id, column, row);
        pivot.postEvent(event);
        return !event.isCancelled();
    }

    private void _fireTableEvent(int id, int column, int row) {
        PivotTable pivot = this._header.getPivotTable();
        TableEvent event = new TableEvent(pivot, id, column, row);
        pivot.postEvent(event);
    }

    private Point _convertPoint(Grid grid, AbstractBigCell cell, int column, int row, int x, int y) {
        for (int cellCol = cell.getColumn(); cellCol < column; ++cellCol) {
            if (!grid.isColumnVisible(cellCol)) continue;
            x += grid.getColumnWidth(cellCol);
        }
        for (int cellRow = cell.getRow(); cellRow < row; ++cellRow) {
            if (!grid.isRowVisible(cellRow)) continue;
            y += grid.getRowHeight(cellRow);
        }
        return new Point(x, y);
    }
}

