/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.util.IntegerUtils;

public class DrillPopup {
    private static final int _DEFAULT_IMAGE_WIDTH = 5;
    private static final int _DEFAULT_IMAGE_HEIGHT = 5;
    PivotTable _pivot;
    boolean _isHorizontal;
    int _column;
    int _row;
    Object[] _cmds;
    private _Listener _listener;
    private JPopupMenu _menu;
    private boolean _dirty;
    private String[] _items;
    PivotHeader _header;
    private PopupMenuListener _popupListener;

    public DrillPopup() {
        this(null, null);
    }

    public DrillPopup(String[] items, Object[] commands) {
        this.setItems(items, commands);
    }

    public void dispose() {
        this.removeAll();
        this._pivot = null;
        this._header = null;
        if (this._menu != null) {
            this._menu.setInvoker(null);
            this._menu.removePopupMenuListener(this._popupListener);
            if (this._listener != null) {
                this._removeActionListeners(this._menu, this._listener);
            }
            this._menu.removeAll();
        }
        this._menu = null;
        this._listener = null;
        this._popupListener = null;
    }

    public void removeAll() {
        this._items = null;
        this._cmds = null;
    }

    public void setItems(String[] items, Object[] commands) {
        this.removeAll();
        this._items = items;
        this._cmds = commands;
        this._dirty = true;
    }

    public void show(DrillEvent e) {
        this._pivot = e.getPivotTable();
        this._column = e.getColumn();
        this._row = e.getRow();
        this._isHorizontal = e.getOrientation() == 0;
        PivotHeader header = this._isHorizontal ? this._pivot.getColumnPivotHeader() : this._pivot.getRowPivotHeader();
        Grid grid = header.getGrid();
        int imageWidth = 5;
        int imageHeight = 5;
        Image image = header.getDrillImage(this._column, this._row);
        if (image != null) {
            imageWidth = image.getWidth(header);
            imageHeight = image.getHeight(header);
        }
        int x = grid.getColumnPosition(this._column) + imageWidth;
        int y = grid.getRowPosition(this._row) + imageHeight / 2;
        int rowHeight = grid.getRowHeight(this._row);
        float align = grid.getCellPaintContext(this._column, this._row).getInteriorAlignmentY();
        if (align == 0.5f) {
            y += rowHeight / 2;
        } else if (align == 1.0f) {
            y = y + rowHeight - imageHeight / 2;
        }
        Point pos = grid.convertCanvasToOuter(x, y);
        this._header = header;
        this._header.setDrilling(true);
        this._showMenu(grid, pos.x, pos.y);
    }

    private void _showMenu(Component c, int x, int y) {
        if (this._items == null || this._items.length == 0) {
            return;
        }
        if (this._menu == null) {
            this._menu = new JPopupMenu();
            this._popupListener = new MenuListen();
            this._menu.addPopupMenuListener(this._popupListener);
            this._listener = new _Listener();
        }
        if (this._dirty) {
            this._removeActionListeners(this._menu, this._listener);
            this._menu.removeAll();
            for (int i = 0; i < this._items.length; ++i) {
                JMenuItem item = new JMenuItem(this._items[i]);
                item.addActionListener(this._listener);
                item.setActionCommand(IntegerUtils.getString((int)i));
                this._menu.add(item);
            }
            this._dirty = false;
        }
        MenuUtils.showPopupMenu(this._menu, c, x, y);
    }

    private void _removeActionListeners(JPopupMenu menu, ActionListener listener) {
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component c = menu.getComponent(i);
            if (!(c instanceof JMenuItem)) continue;
            ((JMenuItem)c).removeActionListener(listener);
        }
    }

    private class _Listener
    implements ActionListener {
        private _Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            int index = 0;
            try {
                index = Integer.parseInt(cmd);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int orientation = DrillPopup.this._isHorizontal ? 0 : 1;
            DrillPopup.this._pivot.fireDrillEvent(orientation, DrillPopup.this._column, DrillPopup.this._row, DrillPopup.this._cmds[index]);
        }
    }

    private class MenuListen
    implements PopupMenuListener {
        private MenuListen() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (DrillPopup.this._header != null) {
                DrillPopup.this._header.setDrilling(false);
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

