/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PainterJoiner
extends AbstractPainter {
    public static final int ALIGN_TOP_DEFAULT = 9;
    public static final int ALIGN_CENTER_DEFAULT = 10;
    public static final int ALIGN_BOTTOM_DEFAULT = 11;
    public static final int ALIGN_TOP_ANTIDEFAULT = 12;
    public static final int ALIGN_CENTER_ANTIDEFAULT = 13;
    public static final int ALIGN_BOTTOM_ANTIDEFAULT = 14;
    public static final int ALIGN_TOP_LEFT = 0;
    public static final int ALIGN_CENTER_LEFT = 1;
    public static final int ALIGN_BOTTOM_LEFT = 2;
    public static final int ALIGN_TOP_CENTER = 3;
    public static final int ALIGN_CENTER_CENTER = 4;
    public static final int ALIGN_BOTTOM_CENTER = 5;
    public static final int ALIGN_TOP_RIGHT = 6;
    public static final int ALIGN_CENTER_RIGHT = 7;
    public static final int ALIGN_BOTTOM_RIGHT = 8;
    private static final int _MAIN_INDEX = 0;
    private static final int _SECOND_INDEX = 1;
    private boolean _fill;
    private int _align;
    private Painter _main;
    private Painter _second;

    public PainterJoiner(Painter main, Painter second) {
        this(main, second, 5, false);
    }

    public PainterJoiner(Painter main, Painter second, int align) {
        this(main, second, align, false);
    }

    public PainterJoiner(Painter main, Painter second, int align, boolean fill) {
        if (main == null) {
            main = NullPainter.getPainter();
        }
        if (second == null) {
            second = NullPainter.getPainter();
        }
        this._main = main;
        this._second = second;
        this._align = align;
        this._fill = fill;
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        Rectangle[] positions = this._getPainterBounds(context, 0, 0, availableWidth, availableHeight);
        return this._getCombinedSize(context, new Dimension(positions[0].width, positions[0].height), new Dimension(positions[1].width, positions[1].height), true);
    }

    public Dimension getPreferredSize(PaintContext context) {
        return this._getCombinedSize(context, this._main.getPreferredSize(context), this._second.getPreferredSize(context), true);
    }

    public Dimension getMinimumSize(PaintContext context) {
        return this._getCombinedSize(context, this._main.getMinimumSize(context), this._second.getMinimumSize(context), true);
    }

    public Dimension getMaximumSize(PaintContext context) {
        return this._getCombinedSize(context, this._main.getMaximumSize(context), this._second.getMaximumSize(context), false);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Rectangle[] positions = this._getPainterBounds(context, x, y, width, height);
        Rectangle mainPosition = positions[0];
        if (mainPosition.width > 0 && mainPosition.height > 0) {
            this._main.paint(context, g, mainPosition.x, mainPosition.y, mainPosition.width, mainPosition.height);
        }
        Rectangle secondPosition = positions[1];
        if (secondPosition.width > 0 && secondPosition.height > 0) {
            this._second.paint(context, g, secondPosition.x, secondPosition.y, secondPosition.width, secondPosition.height);
        }
    }

    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Rectangle[] positions = this._getPainterBounds(context, 0, 0, availableWidth, availableHeight);
        Rectangle secondPosition = positions[1];
        Painter containedPainter = this._second.getPainterAt(context, secondPosition.width, secondPosition.height, x - secondPosition.x, y - secondPosition.y, proxyPainter);
        if (containedPainter == null) {
            Rectangle mainPosition = positions[0];
            containedPainter = this._main.getPainterAt(context, mainPosition.width, mainPosition.height, x - mainPosition.x, y - mainPosition.y, proxyPainter);
        }
        if (proxyPainter == this && containedPainter != null) {
            containedPainter = this;
        }
        return containedPainter;
    }

    public boolean isTransparent(PaintContext context) {
        return true;
    }

    public int getRepaintFlags(PaintContext context) {
        int flags = this._main.getRepaintFlags(context) | this._second.getRepaintFlags(context);
        if (this._align >= 9) {
            flags |= 0x4000;
        }
        return flags;
    }

    public int getInvalidateFlags(PaintContext context) {
        return this._main.getInvalidateFlags(context) | this._second.getInvalidateFlags(context);
    }

    protected int getActualAlignment(PaintContext context) {
        int align = this._align;
        if (align >= 9) {
            boolean right;
            int direction = context.getReadingDirection();
            boolean bl = right = align >= 12;
            if (direction == 2) {
                right = !right;
            }
            align %= 3;
            if (right) {
                align += 6;
            }
        }
        return align;
    }

    private Dimension _getCombinedSize(PaintContext context, Dimension mainSize, Dimension secondSize, boolean useMaximum) {
        int align = this.getActualAlignment(context);
        if (align % 3 == 1) {
            if (useMaximum) {
                if (secondSize.height > mainSize.height) {
                    mainSize.height = secondSize.height;
                }
            } else if (secondSize.height < mainSize.height) {
                mainSize.height = secondSize.height;
            }
        } else {
            mainSize.height += secondSize.height;
        }
        if (align / 3 == 1) {
            if (useMaximum) {
                if (secondSize.width > mainSize.width) {
                    mainSize.width = secondSize.width;
                }
            } else if (secondSize.width < mainSize.width) {
                mainSize.width = secondSize.width;
            }
        } else {
            mainSize.width += secondSize.width;
        }
        return mainSize;
    }

    private Rectangle[] _getPainterBounds(PaintContext context, int x, int y, int width, int height) {
        Rectangle[] positions = new Rectangle[2];
        Dimension mainSize = this._main.getPreferredSize(context);
        Dimension secondSize = this._second.getPreferredSize(context);
        Rectangle mainPosition = new Rectangle();
        Rectangle secondPosition = new Rectangle();
        positions[0] = mainPosition;
        positions[1] = secondPosition;
        mainPosition.x = x;
        mainPosition.y = y;
        mainPosition.width = mainSize.width;
        mainPosition.height = mainSize.height;
        secondPosition.x = x;
        secondPosition.y = y;
        int align = this.getActualAlignment(context);
        switch (align % 3) {
            case 0: {
                secondPosition.height = height - mainPosition.height;
                if (secondPosition.height < 0) {
                    secondPosition.height = 0;
                }
                if (!this._fill && secondPosition.height > secondSize.height) {
                    secondPosition.height = secondSize.height;
                }
                mainPosition.y += secondPosition.height;
                break;
            }
            case 1: {
                if (this._fill) {
                    mainPosition.height = height;
                    secondPosition.height = height;
                    break;
                }
                secondPosition.y += (height - secondSize.height + 1) / 2;
                mainPosition.y += (height - mainPosition.height + 1) / 2;
                secondPosition.height = secondSize.height;
                break;
            }
            case 2: {
                secondPosition.y += mainPosition.height;
                secondPosition.height = height - mainPosition.height;
                if (secondPosition.height < 0) {
                    secondPosition.height = 0;
                }
                if (this._fill || secondPosition.height <= secondSize.height) break;
                secondPosition.height = secondSize.height;
            }
        }
        switch (align / 3) {
            case 0: {
                secondPosition.width = width - mainPosition.width;
                if (secondPosition.width < 0) {
                    secondPosition.width = 0;
                }
                if (!this._fill && secondPosition.width > secondSize.width) {
                    secondPosition.width = secondSize.width;
                }
                mainPosition.x += secondPosition.width;
                break;
            }
            case 1: {
                if (this._fill) {
                    mainPosition.width = width;
                    secondPosition.width = width;
                    break;
                }
                secondPosition.x += (width - secondSize.width) / 2;
                mainPosition.x += (width - mainPosition.width) / 2;
                secondPosition.width = secondSize.width;
                break;
            }
            case 2: {
                secondPosition.x += mainPosition.width;
                secondPosition.width = width - mainPosition.width;
                if (secondPosition.width < 0) {
                    secondPosition.width = 0;
                }
                if (this._fill || secondPosition.width <= secondSize.width) break;
                secondPosition.width = secondSize.width;
            }
        }
        if (!this._fill) {
            if (mainPosition.width > width) {
                mainPosition.width = width;
            }
            if (mainPosition.height > height) {
                mainPosition.height = height;
            }
        }
        return positions;
    }
}

