/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class JPaintContext
implements PaintContext {
    private JComponent _c;
    private boolean _useParentBackground;
    private UIDefaults _defaults;
    private static final int _REALLY_DARK_LUMINANCE = 51;
    private static final int _DARK_LUMINANCE = 139;
    private static final int _LIGHT_LUMINANCE = 240;
    private static final String _DARK_DEFAULTS = "UIDefaults.dark";
    private static final String _LIGHT_DEFAULTS = "UIDefaults.light";
    private static boolean _sAppletsActive = false;
    private static boolean _sAppletParameterTested = false;
    private static final Object _PAINT_CONTEXT_KEY = new StringKey("_EWTPaintContext");

    public static void setAppletsAlwaysActive(boolean active) {
        _sAppletsActive = active;
    }

    public static PaintContext getPaintContext(JComponent component) {
        Object context = component.getClientProperty(_PAINT_CONTEXT_KEY);
        if (context instanceof PaintContext) {
            return (PaintContext)context;
        }
        return null;
    }

    public static void putPaintContext(JComponent component, PaintContext context) {
        component.putClientProperty(_PAINT_CONTEXT_KEY, context);
    }

    public static void removePaintContext(JComponent component) {
        JPaintContext.putPaintContext(component, null);
    }

    public JPaintContext(JComponent component) {
        this(component, null, false);
    }

    public JPaintContext(JComponent component, boolean useParentBackground) {
        this(component, null, useParentBackground);
    }

    private JPaintContext(JComponent component, UIDefaults defaults, boolean useParentBackground) {
        this._c = component;
        this._useParentBackground = useParentBackground;
        this._defaults = defaults == null ? UIManager.getLookAndFeelDefaults() : defaults;
    }

    public Color getPaintForeground() {
        return this._c.getForeground();
    }

    public Color getPaintBackground() {
        return this._c.getBackground();
    }

    public Color getSurroundingColor() {
        if (this._useParentBackground || !this._c.isOpaque()) {
            Container parent = this._c.getParent();
            if (parent != null) {
                return parent.getBackground();
            }
            return null;
        }
        return this._c.getBackground();
    }

    public Font getPaintFont() {
        return this._c.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this._c.getFontMetrics(font);
    }

    public int getPaintState() {
        JComponent c = this._c;
        int state = JPaintContext.getBasePaintState(c);
        if (c.hasFocus()) {
            state |= 0x40;
        }
        return state;
    }

    public static Integer getMnemonicIndex(String text, int mnemonic) {
        if (text != null && mnemonic != 0) {
            char lower;
            char upper = Character.toUpperCase((char)mnemonic);
            int index = text.indexOf(upper);
            if (index < 0 && (lower = Character.toLowerCase((char)mnemonic)) != upper) {
                index = text.indexOf(lower);
            }
            if (index >= 0) {
                return IntegerUtils.getInteger((int)index);
            }
        }
        return null;
    }

    public Object getPaintData(Object key) {
        return null;
    }

    public ImageObserver getImageObserver() {
        return this._c;
    }

    public Locale getPaintLocale() {
        return LocaleUtils.getDefaultableLocale((Component)this._c);
    }

    public UIDefaults getPaintUIDefaults() {
        UIDefaults baseDefaults = this._defaults;
        Color keyColor = this.getSurroundingColor();
        if (keyColor != null) {
            Object lightDefaults;
            int luminance = ColorUtils.getApproximateLuminance(keyColor);
            if (luminance <= 139 && luminance > 51) {
                Object darkDefaults = baseDefaults.get(_DARK_DEFAULTS);
                if (darkDefaults instanceof UIDefaults) {
                    return (UIDefaults)darkDefaults;
                }
            } else if (luminance > 240 && (lightDefaults = baseDefaults.get(_LIGHT_DEFAULTS)) instanceof UIDefaults) {
                return (UIDefaults)lightDefaults;
            }
        }
        return baseDefaults;
    }

    public float getInteriorAlignmentX() {
        return this._c.getAlignmentX();
    }

    public float getInteriorAlignmentY() {
        return this._c.getAlignmentY();
    }

    public int getReadingDirection() {
        return 1;
    }

    public JComponent getComponent() {
        return this._c;
    }

    public void dispose() {
        this._c = null;
        this._defaults = null;
    }

    public String toString() {
        String debugString = super.toString();
        debugString = debugString + ", Component:" + this._c.getName();
        int paintState = this.getPaintState();
        if ((paintState & 1) != 0) {
            debugString = debugString + ", disabled";
        }
        if ((paintState & 2) != 0) {
            debugString = debugString + ", armed";
        }
        if ((paintState & 4) != 0) {
            debugString = debugString + ", inactive";
        }
        if ((paintState & 8) != 0) {
            debugString = debugString + ", set";
        }
        if ((paintState & 0x10) != 0) {
            debugString = debugString + ", mouse over";
        }
        if ((paintState & 0x40) != 0) {
            debugString = debugString + ", focused";
        }
        if ((paintState & 0x80) != 0) {
            debugString = debugString + ", default";
        }
        return debugString;
    }

    public static int getBasePaintState(Component component) {
        int state = 0;
        if (!JPaintContext._isActive(component)) {
            state |= 4;
        }
        if (!component.isEnabled()) {
            state |= 1;
        }
        return state;
    }

    private static boolean _isActive(Component component) {
        Window w = null;
        while (component != null) {
            if (component instanceof Applet) {
                if (_sAppletsActive) {
                    return true;
                }
                if (!_sAppletParameterTested) {
                    _sAppletParameterTested = true;
                    try {
                        Applet applet = (Applet)component;
                        if ("true".equals(applet.getParameter("JEWTAlwaysActive"))) {
                            _sAppletsActive = true;
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (component instanceof Window) {
                w = (Window)component;
                break;
            }
            if (component instanceof JInternalFrame && !((JInternalFrame)component).isSelected() || component instanceof JInternalFrame.JDesktopIcon && !((JInternalFrame.JDesktopIcon)component).getInternalFrame().isSelected()) {
                return false;
            }
            component = component.getParent();
        }
        if (w == null) {
            return false;
        }
        if (w == WindowUtils.getActiveWindow()) {
            return true;
        }
        if (w instanceof Frame || w instanceof Dialog) {
            return w.getFocusOwner() != null;
        }
        return true;
    }
}

