/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import oracle.bali.ewt.olaf.TypeAheadSelectionData;

public class TypeAheadSelectionListener
implements KeyListener {
    private String _prefix = "";
    private long _lastTime = 0L;
    private TypeAheadSelectionData _data;

    public TypeAheadSelectionListener(TypeAheadSelectionData data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this._data = data;
    }

    public void keyTyped(KeyEvent e) {
        int index;
        Object src = e.getSource();
        if (e.isConsumed() || e.isAltDown() || e.isControlDown() || e.isMetaDown() || !this._data.isSelectionAllowed(src)) {
            this._prefix = "";
            return;
        }
        char c = e.getKeyChar();
        long time = e.getWhen();
        int startIndex = 0;
        if (time - this._lastTime < 1000L && (this._prefix.length() > 1 || c != this._prefix.charAt(0))) {
            this._prefix = this._prefix + c;
            startIndex = this._data.getSelectedIndex(src);
        } else {
            this._prefix = "" + c;
            startIndex = this._data.getSelectedIndex(src) + 1;
        }
        this._lastTime = time;
        if (startIndex < 0 || startIndex >= this._data.getSize(src)) {
            startIndex = 0;
        }
        if ((index = this._getNextMatch(this._prefix, startIndex, src)) >= 0) {
            this._data.setSelectedIndex(index, src);
        }
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    private int _getNextMatch(String prefix, int startIndex, Object src) {
        int max = this._data.getSize(src);
        prefix = prefix.toUpperCase();
        int index = startIndex;
        do {
            String name;
            if ((name = this._data.getElementAt(index, src)) == null || !(name = name.toUpperCase()).startsWith(prefix)) continue;
            return index;
        } while ((index = (index + 1 + max) % max) != startIndex);
        return -1;
    }
}

