/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleThumbPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.event.ListenerManager;

class SplitterButton
extends LWComponent {
    public static final int NON_ONE_TOUCH_ACTION_EVENT = 1;
    public static final int ONE_TOUCH_FIRST_ACTION_EVENT = 2;
    public static final int ONE_TOUCH_SECOND_ACTION_EVENT = 3;
    private static final int _RIGHT = 1;
    private static final int _LEFT = 2;
    private static final int _TOP = 3;
    private static final int _BOTTOM = 4;
    private static final int _COMMON = 1;
    private static final int _SPECIAL_1 = 2;
    private static final int _SPECIAL_2 = 3;
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 5;
    private static final int _GRIPPY_STRIDE = 8;
    private static final int _MAX_SEC_BUTTON_SIZE = 10;
    private static final int _MIN_SEC_BUTTON_SIZE = 4;
    private static final int _ONETOUCH_MIN_GRIPPIES = 0;
    private static final int _ONETOUCH_MAX_GRIPPIES = 6;
    private static final int _ONETOUCH_ARROW_SIZE = 7;
    private static final int _ONETOUCH_BORDER_ARROW_SPACE = 5;
    private static final int _ONETOUCH_ARROW_GRIPPY_SPACE = 3;
    private static final int _ONETOUCH_GRIPPY_SEPARATOR_SPACE = 7;
    private static final int _ONETOUCH_SEPARATOR_SIZE = 6;
    private static final int _ONETOUCH_MIN_BUTTON_SIZE = 50;
    private static final int _ONETOUCH_MAX_BUTTON_SIZE = 88;
    private static final int _NON_ONETOUCH_MIN_GRIPPIES = 3;
    private static final int _NON_ONETOUCH_MAX_GRIPPIES = 7;
    private static final int _NON_ONETOUCH_BORDER_GRIPPY_SPACE = 7;
    private static final int _NON_ONETOUCH_MIN_BUTTON_SIZE = 33;
    private static final int _NON_ONETOUCH_MAX_BUTTON_SIZE = 65;
    private static final int _ONETOUCH_FOUR_GRIPPY_SIZE = 72;
    private static final int _ONETOUCH_TWO_GRIPPY_SIZE = 56;
    private static final int _NON_ONETOUCH_FIVE_GRIPPY_SIZE = 44;
    private boolean _isHorizontal = false;
    private boolean _oneTouchExpandable = false;
    private boolean _firstPressed;
    private boolean _secondPressed;
    private boolean _firstArmed;
    private boolean _secondArmed;
    private boolean _firstEnabled = true;
    private boolean _secondEnabled = true;
    private ListenerManager _listenerManager = new ListenerManager();
    private UIDefaults _defaults = OracleUIUtils.getUIDefaults(this);
    private Color _highlight = null;
    private Color _shadow = null;
    private Color _darkBorder = null;
    private Color _lightBorder = null;
    private static final int[] _sXOffsetCommon = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
    private static final int[] _sYOffsetCommon = new int[]{0, 6, 1, 5, 2, 4, 3, 3};
    private static final int[] _sXOffsetDimension5 = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] _sYOffsetDimension5 = new int[]{0, 4, 1, 3, 2, 2};
    private static final int[] _sXOffsetDimension4 = new int[]{0, 0, 1, 1};
    private static final int[] _sYOffsetDimension4 = new int[]{0, 2, 1, 1};
    private static final int[] _sXOffsetSeparatorCommon = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 7};
    private static final int[] _sYOffsetSeparatorCommon = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4};
    private static final int[] _sXOffsetSeparatorDimension5 = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] _sYOffsetSeparatorDimension5 = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] _sXOffsetSeparatorDimension4 = new int[]{0, 0, 1, 1};
    private static final int[] _sYOffsetSeparatorDimension4 = new int[]{0, 0, 1, 1};

    public SplitterButton(int orientation, boolean oneTouchExpandable) {
        this.setOpaque(true);
        this._isHorizontal = orientation == 0;
        this._oneTouchExpandable = oneTouchExpandable;
        this.enableEvents(48L);
        this.updateUI();
    }

    public void addActionListener(ActionListener actionListener) {
        this._listenerManager.addListener((EventListener)actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listenerManager.removeListener((EventListener)actionListener);
    }

    public void setOneTouchExpandable(boolean oneTouchExpandable) {
        this._oneTouchExpandable = oneTouchExpandable;
        this.revalidate();
    }

    public Dimension getMinimumSize() {
        Dimension dim = new Dimension();
        if (this._isHorizontal) {
            dim.width = this._oneTouchExpandable ? 50 : 33;
            dim.height = 4;
        } else {
            dim.width = 4;
            dim.height = this._oneTouchExpandable ? 50 : 33;
        }
        return dim;
    }

    public void updateUI() {
        super.updateUI();
        UIDefaults defaults = OracleUIUtils.getUIDefaults(this);
        this._highlight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        this._shadow = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        this._lightBorder = defaults.getColor("Button.lightBorder");
        this._darkBorder = defaults.getColor("Button.darkBorder");
    }

    public Dimension getButtonSize(Dimension dividerSize) {
        int perpendToBase;
        int n = this._isHorizontal ? (dividerSize.getHeight() >= 10.0 ? 10 : (dividerSize.getHeight() >= 4.0 ? (int)dividerSize.getHeight() : 4)) : (dividerSize.getWidth() >= 10.0 ? 10 : (perpendToBase = dividerSize.getWidth() >= 4.0 ? (int)dividerSize.getWidth() : 4));
        int alongBase = this._oneTouchExpandable ? (this._isHorizontal ? (dividerSize.getWidth() >= 88.0 ? 88 : (dividerSize.getWidth() > 50.0 ? ((int)((dividerSize.getWidth() - 50.0) / 22.0) == 0 ? (dividerSize.getWidth() - 50.0 >= 6.0 ? 56 : 50) : 72) : 50)) : (dividerSize.getHeight() >= 88.0 ? 88 : (dividerSize.getHeight() > 50.0 ? ((int)((dividerSize.getHeight() - 50.0) / 22.0) == 0 ? (dividerSize.getHeight() - 50.0 >= 6.0 ? 56 : 50) : 72) : 50))) : (this._isHorizontal ? (dividerSize.getWidth() >= 65.0 ? 65 : (dividerSize.getWidth() > 33.0 ? (int)((dividerSize.getWidth() - 33.0) / 16.0) * 16 + 33 : 33)) : (dividerSize.getHeight() >= 65.0 ? 65 : (dividerSize.getHeight() > 33.0 ? (int)((dividerSize.getHeight() - 33.0) / 16.0) * 16 + 33 : 33)));
        return this._isHorizontal ? new Dimension(alongBase, perpendToBase) : new Dimension(perpendToBase, alongBase);
    }

    public int getOrientation() {
        return this._isHorizontal ? 0 : 1;
    }

    public void setOrientation(int orientation) {
        this._isHorizontal = orientation == 0;
        this.revalidate();
    }

    public void setButtonArmed(boolean armed) {
        if (this._oneTouchExpandable) {
            String message = "setButtonArmed() method cannot be invoked for One Touch Expandable SplitButton";
            throw new UnsupportedOperationException(message);
        }
        this._firstArmed = armed;
    }

    public boolean isButtonArmed() {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isButtonArmed() method cannotbe invoked for One Touch Expandable SplitButton");
        }
        return this._firstArmed;
    }

    public void setFirstArmed(boolean armed) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setFirstArmed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        this._firstArmed = armed;
    }

    public boolean isFirstArmed() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isFirstArmed() method cannot be invoked for Non One Touch Expandable SplitButton");
        }
        return this._firstArmed;
    }

    public void setSecondArmed(boolean armed) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setSecondArmed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        this._secondArmed = armed;
    }

    public boolean isSecondArmed() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isSecondArmed() method cannotbe invoked forNon One Touch Expandable SplitButton");
        }
        return this._secondArmed;
    }

    public void setButtonPressed(boolean pressed) {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setButtonPressed() method cannot be invoked forOne Touch Expandable SplitButton");
        }
        if (this._firstPressed == pressed) {
            return;
        }
        this._firstPressed = pressed;
        this.repaint();
        if (!this._firstPressed && this._firstArmed) {
            this._fireActionPerformed(1);
        }
    }

    public boolean isButtonPressed() {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isButtonPressed() method cannot be invoked for One Touch Expandable SplitButton");
        }
        return this._firstPressed;
    }

    public void setFirstPressed(boolean pressed) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setFirstPressed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        if (this._firstPressed == pressed) {
            return;
        }
        this._firstPressed = pressed;
        this.repaint();
        if (!this._firstPressed && this._firstArmed) {
            this._fireActionPerformed(2);
        }
    }

    public boolean isFirstPressed() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isFirstPressed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        return this._firstPressed;
    }

    public void setSecondPressed(boolean pressed) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setSecondPressed() method cannot be invoked for Non One Touch Expandable SplitButton");
        }
        if (this._secondPressed == pressed) {
            return;
        }
        this._secondPressed = pressed;
        this.repaint();
        if (!this._secondPressed && this._secondArmed) {
            this._fireActionPerformed(3);
        }
    }

    public boolean isSecondPressed() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isSecondPressed() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        return this._secondPressed;
    }

    public void setFirstEnabled(boolean enabled) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setFirstEnabled() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        this._firstEnabled = enabled;
    }

    public boolean isFirstEnabled() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isFirstEnabled() method cannot be invoked for Non One Touch Expandable SplitButton");
        }
        return this._firstEnabled;
    }

    public void setSecondEnabled(boolean enabled) {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setSecondEnabled() method cannot be invoked for Non One Touch Expandable SplitButton");
        }
        this._secondEnabled = enabled;
    }

    public boolean isSecondEnabled() {
        if (!this._oneTouchExpandable) {
            throw new UnsupportedOperationException("isSecondEnabled() method cannotbe invoked for Non One Touch Expandable SplitButton");
        }
        return this._secondEnabled;
    }

    public void setButtonEnabled(boolean enabled) {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setButtonEnabled() method  cannot be invoked for One Touch Expandable SplitButton");
        }
        this._firstEnabled = enabled;
    }

    public boolean isButtonEnabled() {
        if (this._oneTouchExpandable) {
            throw new UnsupportedOperationException("setButtonEnabled() method cannot be invoked for One Touch Expandable SplitButton");
        }
        return this._firstEnabled;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 504: {
                this._handleMouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this._handleMouseExited(mouseEvent);
                break;
            }
            case 501: {
                this._handleMousePressed(mouseEvent);
                break;
            }
            case 502: {
                this._handleMouseReleased(mouseEvent);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        switch (e.getID()) {
            case 503: {
                this._handleMouseMoved(e);
                break;
            }
            case 506: {
                this._handleMouseDragged(e);
            }
        }
    }

    protected void paintComponent(Graphics g) {
        int alongBase;
        int totalGrippies = 0;
        PaintContext context = OracleUIUtils.getPaintContext(this);
        int bheight = this.getHeight();
        int bwidth = this.getWidth();
        int numGrippies = 0;
        int xOffset = 0;
        int yOffset = 0;
        int grippyWidth = 3;
        int grippyHeight = 3;
        int grippySize = 0;
        int grippyX = 0;
        int grippyY = 0;
        Color savedColor = g.getColor();
        g.setColor(context.getPaintBackground());
        g.fillRect(0, 0, bwidth, bheight);
        int n = alongBase = this._isHorizontal ? bwidth : bheight;
        if (this._oneTouchExpandable) {
            totalGrippies = alongBase >= 88 ? 6 : (alongBase >= 72 ? 4 : (alongBase >= 56 ? 2 : 0));
            numGrippies = totalGrippies / 2;
            if (numGrippies != 0) {
                grippySize = numGrippies * 3 + (numGrippies - 1) * 5;
            }
            if (this._isHorizontal) {
                xOffset = 8;
                this._drawOneTouchHorizontalSplitter(g, bheight, grippySize, numGrippies, xOffset, yOffset);
            } else {
                yOffset = 8;
                this._drawOneTouchVerticalSplitter(g, bwidth, grippySize, numGrippies, xOffset, yOffset);
            }
        } else {
            int val;
            if (alongBase < 33) {
                return;
            }
            totalGrippies = alongBase >= 65 ? 7 : (alongBase >= 44 ? 5 : 3);
            numGrippies = totalGrippies;
            grippySize = numGrippies * 3 + (numGrippies - 1) * 5;
            if (this._isHorizontal) {
                grippyWidth = grippySize;
                xOffset = 8;
                if (bheight == 5) {
                    grippyY = 0;
                } else {
                    val = bheight % 2 == 0 ? bheight : bheight - 1;
                    grippyY = (val - grippyHeight) / 2;
                }
                grippyX = 7;
            } else {
                grippyHeight = grippySize;
                yOffset = 8;
                if (bheight == 5) {
                    grippyX = 0;
                } else {
                    val = bwidth % 2 == 0 ? bwidth : bwidth - 1;
                    grippyX = (val - grippyWidth) / 2;
                }
                grippyY = 7;
            }
            boolean isArmed = this.isButtonPressed();
            if (bwidth == 4) {
                while (numGrippies > 0) {
                    if (this.getActualReadingDirection() == 1) {
                        g.setColor(this._highlight);
                        g.drawLine(1, grippyY + 1, 1, grippyY + 1);
                        g.setColor(this._shadow);
                        g.drawLine(2, grippyY + 2, 2, grippyY + 2);
                    } else {
                        g.setColor(this._highlight);
                        g.drawLine(2, grippyY + 1, 2, grippyY + 1);
                        g.setColor(this._shadow);
                        g.drawLine(1, grippyY + 2, 1, grippyY + 2);
                    }
                    --numGrippies;
                    grippyX += xOffset;
                    grippyY += yOffset;
                }
            } else if (bheight == 4) {
                while (numGrippies > 0) {
                    g.setColor(this._highlight);
                    g.drawLine(grippyX, 1, grippyX, 1);
                    g.setColor(this._shadow);
                    g.drawLine(grippyX + 1, 2, grippyX + 1, 2);
                    --numGrippies;
                    grippyX += xOffset;
                    grippyY += yOffset;
                }
            } else {
                while (numGrippies > 0) {
                    OracleThumbPainter.__drawGrippy(g, grippyX, grippyY, this._highlight, this._shadow, isArmed);
                    --numGrippies;
                    grippyX += xOffset;
                    grippyY += yOffset;
                }
            }
        }
        g.setColor(savedColor);
    }

    protected void paintBorder(Graphics g) {
        Color savedColor = g.getColor();
        int width = this.getWidth();
        int height = this.getHeight();
        int buttonX = 0;
        int buttonY = 0;
        int bwidth = 0;
        int bheight = 0;
        int center = 0;
        if (this._isHorizontal) {
            bwidth = width - 7;
            bheight = height;
            center = width / 2;
            if (this._oneTouchExpandable) {
                boolean isPressed = this.isFirstPressed();
                this._drawLeftButtonBorder(g, isPressed, buttonX, buttonY, bwidth, bheight, center);
                isPressed = this.isSecondPressed();
                this._drawRightButtonBorder(g, isPressed, buttonX, buttonY, bwidth, bheight, center);
            } else {
                boolean isButtonPressed = this.isButtonPressed();
                this._drawLeftButtonBorder(g, isButtonPressed, buttonX, buttonY, bwidth, bheight, center);
                this._drawRightButtonBorder(g, isButtonPressed, buttonX, buttonY, bwidth, bheight, center);
            }
        } else {
            bwidth = width;
            bheight = height - 7;
            center = height / 2;
            if (this._oneTouchExpandable) {
                boolean isPressed = this.isFirstPressed();
                this._drawTopButtonBorder(g, isPressed, buttonX, buttonY, bwidth, bheight, center);
                isPressed = this.isSecondPressed();
                this._drawBottomButtonBorder(g, isPressed, buttonX, buttonY, bwidth, bheight, center);
            } else {
                boolean isButtonPressed = this.isButtonPressed();
                this._drawTopButtonBorder(g, isButtonPressed, buttonX, buttonY, bwidth, bheight, center);
                this._drawBottomButtonBorder(g, isButtonPressed, buttonX, buttonY, bwidth, bheight, center);
            }
        }
        g.setColor(savedColor);
    }

    private void _drawLeftButtonBorder(Graphics g, boolean isPressed, int buttonX, int buttonY, int bwidth, int bheight, int center) {
        int y1 = buttonX;
        int y2 = 0;
        if (isPressed) {
            g.setColor(this._darkBorder);
        } else {
            g.setColor(this._lightBorder);
        }
        g.drawLine(buttonX + 3, buttonY, center + 3, buttonY);
        if (bheight <= 9) {
            g.drawLine(buttonX + 2, buttonY, buttonX + 2, buttonY);
        } else {
            g.drawLine(buttonX + 1, ++y1, buttonX + 2, y1);
        }
        if (bheight <= 7) {
            g.drawLine(buttonX + 2, buttonY, buttonX + 1, buttonY);
        } else {
            g.drawLine(buttonX + 1, ++y1, buttonX + 1, y1);
        }
        if (isPressed) {
            g.setColor(this._darkBorder);
        } else {
            g.setColor(this._lightBorder);
        }
        ++y1;
        if (bheight > 5) {
            y2 = y1 + 3;
        } else if (bheight == 5) {
            y2 = y1 + 2;
        } else if (bheight == 4) {
            y2 = y1 + 1;
        }
        g.drawLine(buttonX, y1, buttonX, y2 - 1);
        g.setColor(this._lightBorder);
        g.drawLine(buttonX, y2, buttonX, y2);
        g.setColor(this._lightBorder);
        y1 = y2;
        if (bheight > 6) {
            g.drawLine(buttonX + 1, ++y1, buttonX + 1, y1);
        }
        if (bheight > 8) {
            g.drawLine(buttonX + 1, ++y1, buttonX + 2, y1);
        }
        ++y1;
        if (bheight <= 8) {
            g.drawLine(buttonX + 2, y1, buttonX + 2, y1);
        }
        if (bheight <= 6) {
            g.drawLine(buttonX + 1, y1, buttonX + 1, y1);
            if (isPressed) {
                g.setColor(this._lightBorder);
            } else {
                g.setColor(this._darkBorder);
            }
        }
        g.drawLine(buttonX + 3, y1, buttonX + 3, y1);
        if (isPressed) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        g.drawLine(buttonX + 4, y1, center - 3, y1);
    }

    private void _drawRightButtonBorder(Graphics g, boolean isPressed, int buttonX, int buttonY, int bwidth, int bheight, int center) {
        if (isPressed) {
            g.setColor(this._darkBorder);
        } else {
            g.setColor(this._lightBorder);
        }
        int y1 = buttonY;
        int y2 = 0;
        g.drawLine(center + 3 + 1, buttonY, buttonX + 3 + bwidth, buttonY);
        if (bheight <= 9) {
            g.drawLine(buttonX + 4 + bwidth, buttonY, buttonX + 4 + bwidth, buttonY);
        } else {
            g.drawLine(buttonX + 4 + bwidth, ++y1, buttonX + 4 + bwidth, y1);
            g.setColor(this._darkBorder);
            g.drawLine(buttonX + 5 + bwidth, y1, buttonX + 5 + bwidth, y1);
        }
        g.setColor(this._darkBorder);
        if (bheight <= 7) {
            g.drawLine(buttonX + 5 + bwidth, buttonY, buttonX + 5 + bwidth, buttonY);
        } else {
            g.drawLine(buttonX + 5 + bwidth, ++y1, buttonX + 5 + bwidth, y1);
        }
        ++y1;
        if (bheight > 5) {
            y2 = y1 + 3;
        } else if (bheight == 5) {
            y2 = y1 + 2;
        } else if (bheight == 4) {
            y2 = y1 + 1;
        }
        g.setColor(this._darkBorder);
        g.drawLine(buttonX + 6 + bwidth, y1, buttonX + 6 + bwidth, y1);
        if (isPressed) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        g.drawLine(buttonX + 6 + bwidth, y1 + 1, buttonX + 6 + bwidth, y2);
        y1 = y2;
        if (isPressed) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        if (bheight > 6) {
            g.drawLine(buttonX + 5 + bwidth, ++y1, buttonX + 5 + bwidth, y1);
        }
        if (bheight > 8) {
            g.drawLine(buttonX + 4 + bwidth, ++y1, buttonX + 4 + bwidth, y1);
        }
        ++y1;
        if (isPressed) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        g.drawLine(center - 3 + 1, y1, buttonX + 3 + bwidth, y1);
        if (bheight <= 8) {
            g.drawLine(buttonX + 4 + bwidth, y1, buttonX + 4 + bwidth, y1);
        }
        if (bheight <= 6) {
            g.drawLine(buttonX + 5 + bwidth, y1, buttonX + 5 + bwidth, y1);
        }
    }

    private void _drawTopButtonBorder(Graphics g, boolean isPressed, int buttonX, int buttonY, int bwidth, int bheight, int center) {
        int end2;
        int x1 = buttonX;
        int x2 = 0;
        boolean rtl = this.getActualReadingDirection() == 2;
        int end1 = rtl ? center - 3 : center + 3;
        int n = end2 = rtl ? center + 3 : center - 3;
        if (isPressed && !rtl) {
            g.setColor(this._darkBorder);
        } else {
            g.setColor(this._lightBorder);
        }
        g.drawLine(buttonX, buttonY + 3, buttonX, buttonY + 3);
        if (bwidth <= 9) {
            g.drawLine(buttonX, buttonY + 2, buttonX, buttonY + 2);
        } else {
            g.drawLine(++x1, buttonY + 1, x1, buttonY + 2);
        }
        if (bwidth <= 7) {
            g.drawLine(buttonX, buttonY + 1, buttonX, buttonY + 1);
        } else {
            g.drawLine(++x1, buttonY + 1, x1, buttonY + 1);
        }
        if (rtl && !isPressed) {
            g.setColor(this._darkBorder);
        }
        g.drawLine(buttonX, buttonY + 4, buttonX, end1);
        g.setColor(this._lightBorder);
        ++x1;
        if (bwidth > 5) {
            x2 = x1 + 3;
        } else if (bwidth == 5) {
            x2 = x1 + 2;
        } else if (bwidth == 4) {
            x2 = x1 + 1;
        }
        if (isPressed && !rtl) {
            g.setColor(this._darkBorder);
        }
        g.drawLine(x1, buttonY, x1, buttonY);
        if (x2 != x1 + 1) {
            if (isPressed) {
                g.setColor(this._darkBorder);
            }
            g.drawLine(x1 + 1, buttonY, x2 - 1, buttonY);
        }
        if (isPressed && rtl) {
            g.setColor(this._darkBorder);
        } else {
            g.setColor(this._lightBorder);
        }
        g.drawLine(x2, buttonY, x2, buttonY);
        x1 = x2;
        if (isPressed && rtl) {
            g.setColor(this._darkBorder);
        } else {
            g.setColor(this._lightBorder);
        }
        if (bwidth > 6) {
            g.drawLine(++x1, buttonY + 1, x1, buttonY + 1);
        }
        if (bwidth > 8) {
            g.drawLine(++x1, buttonY + 1, x1, buttonY + 2);
        }
        ++x1;
        if (bwidth <= 8) {
            g.drawLine(x1, buttonY + 2, x1, buttonY + 2);
        }
        if (bwidth <= 6) {
            g.drawLine(x1, buttonY + 1, x1, buttonY + 1);
        }
        g.drawLine(x1, buttonY + 3, x1, buttonY + 3);
        if (isPressed && !rtl || !isPressed && rtl) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        g.drawLine(x1, buttonY + 4, x1, end2);
    }

    private void _drawBottomButtonBorder(Graphics g, boolean isPressed, int buttonX, int buttonY, int bwidth, int bheight, int center) {
        int end2;
        int x1 = buttonX;
        int x2 = 0;
        boolean rtl = this.getActualReadingDirection() == 2;
        int end1 = rtl ? center - 3 + 1 : center + 3 + 1;
        int n = end2 = rtl ? center + 3 + 1 : center - 3 + 1;
        if (isPressed && rtl || !isPressed && !rtl) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        g.drawLine(buttonX, end1, buttonX, buttonY + 3 + bheight);
        if (bwidth <= 9) {
            g.drawLine(buttonX, buttonY + 4 + bheight, buttonX, buttonY + 4 + bheight);
        }
        if (bwidth <= 7) {
            g.drawLine(buttonX, buttonY + 5 + bheight, buttonX, buttonY + 5 + bheight);
        }
        if (isPressed && rtl) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        if (bwidth > 9) {
            g.drawLine(++x1, buttonY + 5 + bheight, x1, buttonY + 5 + bheight);
            if (!isPressed && !rtl) {
                g.setColor(this._lightBorder);
            }
            g.drawLine(x1, buttonY + 4 + bheight, x1, buttonY + 4 + bheight);
        }
        if (isPressed && rtl) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        if (bwidth > 7) {
            g.drawLine(++x1, buttonY + 5 + bheight, x1, buttonY + 5 + bheight);
        }
        ++x1;
        if (bwidth > 5) {
            x2 = x1 + 3;
        } else if (bwidth == 5) {
            x2 = x1 + 2;
        } else if (bwidth == 4) {
            x2 = x1 + 1;
        }
        g.setColor(this._darkBorder);
        if (isPressed && rtl) {
            g.setColor(this._lightBorder);
        }
        g.drawLine(x1, buttonY + 6 + bheight, x1, buttonY + 6 + bheight);
        if (x2 != x1 + 1) {
            if (isPressed) {
                g.setColor(this._lightBorder);
            }
            g.drawLine(x1 + 1, buttonY + 6 + bheight, x2 - 1, buttonY + 6 + bheight);
        }
        if (isPressed && !rtl) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        g.drawLine(x2, buttonY + 6 + bheight, x2, buttonY + 6 + bheight);
        x1 = x2;
        if (isPressed && !rtl) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        if (bwidth > 6) {
            g.drawLine(++x1, buttonY + 5 + bheight, x1, buttonY + 5 + bheight);
        }
        if (bwidth > 8) {
            g.drawLine(++x1, buttonY + 5 + bheight, x1, buttonY + 5 + bheight);
            if (!isPressed && rtl) {
                g.setColor(this._lightBorder);
            }
            g.drawLine(x1, buttonY + 4 + bheight, x1, buttonY + 4 + bheight);
        }
        ++x1;
        if (isPressed && !rtl || !isPressed && rtl) {
            g.setColor(this._lightBorder);
        } else {
            g.setColor(this._darkBorder);
        }
        if (bwidth <= 8) {
            g.drawLine(x1, buttonY + 4 + bheight, x1, buttonY + 4 + bheight);
        }
        if (bwidth <= 6) {
            g.drawLine(x1, buttonY + 5 + bheight, x1, buttonY + 5 + bheight);
        }
        g.drawLine(x1, end2, x1, buttonY + 3 + bheight);
    }

    private void _drawOneTouchHorizontalSplitter(Graphics g, int bheight, int grippySize, int numGrippies, int xOffset, int yOffset) {
        block9: {
            int nGrippies;
            int lineStart;
            int grippyX;
            block8: {
                grippyX = 16;
                int grippyY = 0;
                lineStart = 8 + grippySize + 7 + 7;
                boolean isFirstPressed = this.isFirstPressed();
                boolean isSecondPressed = this.isSecondPressed();
                boolean isFirstEnabled = this.isFirstEnabled();
                boolean isSecondEnabled = this.isSecondEnabled();
                boolean type = false;
                nGrippies = 0;
                int alongBase = this.getWidth();
                int perpToBase = this.getHeight();
                int perpCenter = perpToBase / 2;
                int alongCenter = alongBase / 2;
                int[] xArray = null;
                int[] yArray = null;
                int[] xSepArray = null;
                int[] ySepArray = null;
                int x1 = 0;
                int y1 = 0;
                int x2 = 0;
                int y2 = 0;
                switch (bheight) {
                    case 5: {
                        xArray = _sYOffsetDimension5;
                        yArray = _sXOffsetDimension5;
                        xSepArray = _sYOffsetSeparatorDimension5;
                        ySepArray = _sXOffsetSeparatorDimension5;
                        grippyY = 0;
                        x1 = 10;
                        x2 = alongBase - x1;
                        y2 = 1;
                        y1 = 3;
                        break;
                    }
                    case 4: {
                        xArray = _sYOffsetDimension4;
                        yArray = _sXOffsetDimension4;
                        xSepArray = _sYOffsetSeparatorDimension4;
                        ySepArray = _sXOffsetSeparatorDimension4;
                        grippyY = 0;
                        x1 = 8;
                        x2 = alongBase - x1;
                        y2 = 1;
                        y1 = 2;
                        break;
                    }
                    default: {
                        xArray = _sYOffsetCommon;
                        yArray = _sXOffsetCommon;
                        xSepArray = _sYOffsetSeparatorCommon;
                        ySepArray = _sXOffsetSeparatorCommon;
                        grippyY = perpCenter - 2;
                        x1 = 12;
                        x2 = alongBase - x1;
                        y2 = perpCenter - 2;
                        y1 = perpCenter + 1;
                    }
                }
                this._drawArrow(g, xArray, yArray, x1, y1, 3, isFirstEnabled);
                this._drawArrow(g, xArray, yArray, x2, y2, 4, isSecondEnabled);
                this._drawSeparator(g, xSepArray, ySepArray, alongCenter + 2, 1);
                if (bheight < 5) break block8;
                nGrippies = numGrippies;
                while (nGrippies > 0) {
                    OracleThumbPainter.__drawGrippy(g, grippyX, grippyY, this._highlight, this._shadow, isFirstPressed);
                    --nGrippies;
                    grippyX += xOffset;
                    grippyY += yOffset;
                }
                grippyX = lineStart + 5 + 7 + 1;
                nGrippies = numGrippies;
                while (nGrippies > 0) {
                    OracleThumbPainter.__drawGrippy(g, grippyX, grippyY, this._highlight, this._shadow, isSecondPressed);
                    --nGrippies;
                    grippyX += xOffset;
                    grippyY += yOffset;
                }
                break block9;
            }
            if (bheight != 4) break block9;
            nGrippies = numGrippies;
            while (nGrippies > 0) {
                g.setColor(this._highlight);
                g.drawLine(grippyX, 1, grippyX, 1);
                g.setColor(this._shadow);
                g.drawLine(grippyX + 1, 2, grippyX + 1, 2);
                --nGrippies;
                grippyX += xOffset;
                grippyY += yOffset;
            }
            grippyX = lineStart + 5 + 7 + 1;
            nGrippies = numGrippies;
            while (nGrippies > 0) {
                g.setColor(this._highlight);
                g.drawLine(grippyX, 1, grippyX, 1);
                g.setColor(this._shadow);
                g.drawLine(grippyX + 1, 2, grippyX + 1, 2);
                --nGrippies;
                grippyX += xOffset;
                grippyY += yOffset;
            }
        }
    }

    private void _drawArrow(Graphics g, int[] xOffset, int[] yOffset, int x, int y, int arrowType, boolean enabled) {
        int readingDirection = this.getActualReadingDirection();
        Color color = enabled ? this._darkBorder : this._shadow;
        g.setColor(color);
        int i = 0;
        if (arrowType == 1 || arrowType == 4) {
            for (i = 0; i < xOffset.length - 1; i += 2) {
                g.drawLine(x + xOffset[i], y + yOffset[i], x + xOffset[i + 1], y + yOffset[i + 1]);
            }
        } else {
            for (i = xOffset.length - 1; i > 0; i -= 2) {
                g.drawLine(x - xOffset[i], y - yOffset[i], x - xOffset[i - 1], y - yOffset[i - 1]);
            }
        }
    }

    private void _drawSeparator(Graphics g, int[] xOffset, int[] yOffset, int x, int y) {
        int i = 0;
        int readingDirection = this.getActualReadingDirection();
        int xMul = 0;
        int yMul = 0;
        int x1 = 0;
        int y1 = 0;
        if (this._isHorizontal) {
            xMul = -1;
            yMul = 1;
            x1 = -1;
            y1 = 0;
        } else {
            if (readingDirection == 1) {
                xMul = 1;
                yMul = -1;
            } else {
                xMul = -1;
                yMul = -1;
            }
            x1 = 0;
            y1 = -1;
        }
        for (i = 0; i < xOffset.length - 1; i += 2) {
            g.setColor(this._darkBorder);
            g.drawLine(x + xMul * xOffset[i], y + yMul * yOffset[i], x + xMul * xOffset[i + 1], y + yMul * yOffset[i + 1]);
            g.setColor(this._lightBorder);
            g.drawLine(x + xMul * xOffset[i] - x1, y + yMul * yOffset[i] - y1, x + xMul * xOffset[i + 1] - x1, y + yMul * yOffset[i + 1] - y1);
        }
    }

    private void _drawOneTouchVerticalSplitter(Graphics g, int bwidth, int grippySize, int numGrippies, int xOffset, int yOffset) {
        block16: {
            int nGrippies;
            int readingDirection;
            int lineStart;
            int grippyY;
            block15: {
                int grippyX = 0;
                grippyY = 16;
                lineStart = 8 + grippySize + 7 + 7;
                boolean isFirstPressed = this.isFirstPressed();
                boolean isSecondPressed = this.isSecondPressed();
                readingDirection = this.getActualReadingDirection();
                boolean isFirstEnabled = this.isFirstEnabled();
                boolean isSecondEnabled = this.isSecondEnabled();
                boolean type = false;
                nGrippies = 0;
                int alongBase = this.getHeight();
                int perpToBase = this.getWidth();
                int perpCenter = perpToBase / 2;
                int alongCenter = alongBase / 2;
                int[] xArray = null;
                int[] yArray = null;
                int[] xSepArray = null;
                int[] ySepArray = null;
                int x1 = 0;
                int x2 = 0;
                int y1 = 0;
                int y2 = 0;
                switch (bwidth) {
                    case 5: {
                        xArray = _sXOffsetDimension5;
                        yArray = _sYOffsetDimension5;
                        xSepArray = _sXOffsetSeparatorDimension5;
                        ySepArray = _sYOffsetSeparatorDimension5;
                        grippyX = readingDirection == 1 ? 0 : 4;
                        x1 = 1;
                        x2 = 3;
                        y1 = 10;
                        y2 = alongBase - y1;
                        break;
                    }
                    case 4: {
                        xArray = _sXOffsetDimension4;
                        yArray = _sYOffsetDimension4;
                        xSepArray = _sXOffsetSeparatorDimension4;
                        ySepArray = _sYOffsetSeparatorDimension4;
                        grippyX = readingDirection == 1 ? 0 : 3;
                        x1 = 1;
                        x2 = 2;
                        y1 = 8;
                        y2 = alongBase - y1;
                        break;
                    }
                    default: {
                        xArray = _sXOffsetCommon;
                        yArray = _sYOffsetCommon;
                        xSepArray = _sXOffsetSeparatorCommon;
                        ySepArray = _sYOffsetSeparatorCommon;
                        grippyX = readingDirection == 1 ? perpCenter - 2 : perpCenter + 1;
                        x1 = perpCenter - 2;
                        x2 = perpCenter + 1;
                        y1 = 12;
                        y2 = alongBase - y1;
                    }
                }
                if (readingDirection == 1) {
                    this._drawArrow(g, xArray, yArray, x1, 6, 1, isFirstEnabled);
                    this._drawArrow(g, xArray, yArray, x2, alongBase - 5 + 1, 2, isSecondEnabled);
                    this._drawSeparator(g, xSepArray, ySepArray, 1, alongCenter + 2);
                } else {
                    this._drawArrow(g, xArray, yArray, x2, y1, 2, isFirstEnabled);
                    this._drawArrow(g, xArray, yArray, x1, y2, 1, isSecondEnabled);
                    this._drawSeparator(g, xSepArray, ySepArray, bwidth - 2, alongCenter + 2);
                }
                if (bwidth < 5) break block15;
                nGrippies = numGrippies;
                while (nGrippies > 0) {
                    OracleThumbPainter.__drawGrippy(g, grippyX, grippyY, this._highlight, this._shadow, isFirstPressed, this.getActualReadingDirection());
                    --nGrippies;
                    grippyX += xOffset;
                    grippyY += yOffset;
                }
                grippyY = lineStart + 5 + 7 + 1;
                nGrippies = numGrippies;
                while (nGrippies > 0) {
                    OracleThumbPainter.__drawGrippy(g, grippyX, grippyY, this._highlight, this._shadow, isSecondPressed, this.getActualReadingDirection());
                    --nGrippies;
                    grippyX += xOffset;
                    grippyY += yOffset;
                }
                break block16;
            }
            if (bwidth != 4) break block16;
            nGrippies = numGrippies;
            while (nGrippies > 0) {
                if (readingDirection == 1) {
                    g.setColor(this._highlight);
                    g.drawLine(1, grippyY + 1, 1, grippyY + 1);
                    g.setColor(this._shadow);
                    g.drawLine(2, grippyY + 2, 2, grippyY + 2);
                } else if (readingDirection == 2) {
                    g.setColor(this._highlight);
                    g.drawLine(2, grippyY + 1, 2, grippyY + 1);
                    g.setColor(this._shadow);
                    g.drawLine(1, grippyY + 2, 1, grippyY + 2);
                }
                --nGrippies;
                grippyX += xOffset;
                grippyY += yOffset;
            }
            grippyY = lineStart + 5 + 7 + 1;
            nGrippies = numGrippies;
            while (nGrippies > 0) {
                if (readingDirection == 1) {
                    g.setColor(this._highlight);
                    g.drawLine(1, grippyY + 1, 1, grippyY + 1);
                    g.setColor(this._shadow);
                    g.drawLine(2, grippyY + 2, 2, grippyY + 2);
                } else {
                    g.setColor(this._highlight);
                    g.drawLine(2, grippyY + 1, 2, grippyY + 1);
                    g.setColor(this._shadow);
                    g.drawLine(1, grippyY + 2, 1, grippyY + 2);
                }
                --nGrippies;
                grippyX += xOffset;
                grippyY += yOffset;
            }
        }
    }

    private void _fireActionPerformed(int id) {
        Enumeration enumer = this._listenerManager.getListeners();
        if (enumer != null) {
            ActionEvent event = new ActionEvent(this, id, "");
            while (enumer.hasMoreElements()) {
                ActionListener listener = (ActionListener)enumer.nextElement();
                listener.actionPerformed(event);
            }
        }
    }

    private boolean _isInFirstButton(int x, int y) {
        boolean part1;
        int readingDirection = this.getActualReadingDirection();
        boolean part2 = false;
        if (this._isHorizontal) {
            boolean part12;
            int center = this.getWidth() / 2;
            int height = this.getHeight();
            boolean bl = part12 = y >= 0 && y < height - 1 && x >= 0 && x < center - 3;
            if (part12) {
                return part12;
            }
            part2 = y > 0 && x > center - 3 && 6 * y < (3 + center - x) * (height - 1);
            return part2;
        }
        int center = this.getHeight() / 2;
        int width = this.getWidth();
        boolean bl = part1 = x >= 0 && x < width - 1 && y >= 0 && y < center - 3;
        if (part1) {
            return part1;
        }
        part2 = readingDirection == 1 ? x > 0 && y > center - 3 && 6 * x < (3 + center - y) * (width - 1) : x < width - 1 && y > center - 3 && 6 * x > (3 - center + y) * (width - 1);
        return part2;
    }

    private void _handleMouseExited(MouseEvent e) {
        if (this._oneTouchExpandable) {
            this.setFirstArmed(false);
            this.setSecondArmed(false);
        } else {
            this.setButtonArmed(false);
        }
    }

    private void _handleMouseEntered(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this._oneTouchExpandable) {
            boolean firstArmed = this._isInFirstButton(x, y);
            if (this.isFirstEnabled()) {
                this.setFirstArmed(firstArmed);
            }
            if (this.isSecondEnabled()) {
                this.setSecondArmed(!firstArmed);
            }
        } else if (this.isButtonEnabled()) {
            this.setButtonArmed(true);
        }
    }

    private void _handleMousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this._oneTouchExpandable) {
            boolean firstPressed = this._isInFirstButton(x, y);
            if (this.isFirstEnabled()) {
                this.setFirstPressed(firstPressed);
            }
            if (this.isSecondEnabled()) {
                this.setSecondPressed(!firstPressed);
            }
        } else if (this.isButtonEnabled()) {
            this.setButtonPressed(true);
        }
    }

    private void _handleMouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            this._resetPressedState();
            this.repaint();
        } else if (this._oneTouchExpandable) {
            if (this.isFirstEnabled()) {
                this.setFirstPressed(false);
            }
            if (this.isSecondEnabled()) {
                this.setSecondPressed(false);
            }
        } else if (this.isButtonEnabled()) {
            this.setButtonPressed(false);
        }
    }

    private void _handleMouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Rectangle bounds = this.getBounds();
        if (this._oneTouchExpandable) {
            boolean firstArmed = this._isInFirstButton(x, y);
            if (this.isFirstEnabled()) {
                this.setFirstArmed(firstArmed);
            }
            if (this.isSecondEnabled()) {
                this.setSecondArmed(!firstArmed);
            }
        } else if (this.isButtonEnabled()) {
            this.setButtonArmed(true);
        }
    }

    private void _handleMouseDragged(MouseEvent e) {
        int height = this.getHeight();
        int width = this.getWidth();
        int x = e.getX();
        int y = e.getY();
        if (this._oneTouchExpandable) {
            if (x < 0 || x > width || y < 0 || y > height) {
                if (this.isFirstEnabled()) {
                    this.setFirstArmed(false);
                }
                if (this.isSecondEnabled()) {
                    this.setSecondArmed(false);
                }
            } else {
                boolean firstArmed = this._isInFirstButton(x, y);
                if (this.isFirstEnabled()) {
                    this.setFirstArmed(firstArmed);
                }
                if (this.isSecondEnabled()) {
                    this.setSecondArmed(!firstArmed);
                }
            }
        }
    }

    private void _resetPressedState() {
        this._firstPressed = false;
        this._secondPressed = false;
    }
}

