/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import oracle.bali.ewt.util.WindowUtils;

public class OracleTableUI
extends BasicTableUI {
    private Listener _listener;
    private Window _parent;
    private JTable _table;

    public static ComponentUI createUI(JComponent c) {
        return new OracleTableUI();
    }

    public void installUI(JComponent c) {
        this._table = (JTable)c;
        super.installUI(c);
        this._fixEscape();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this._table = null;
    }

    protected void installListeners() {
        super.installListeners();
        this._listener = new Listener();
        this._table.addPropertyChangeListener(this._listener);
        this._parent = WindowUtils.getWindow(this._table);
        if (this._parent != null) {
            this._parent.addWindowListener(this._listener);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this._table.removePropertyChangeListener(this._listener);
        if (this._parent != null) {
            this._parent.removeWindowListener(this._listener);
            this._parent = null;
        }
        this._listener = null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    private void _fixEscape() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this._table.getInputMap(1).put(keyStroke, "cancel");
        this._table.getActionMap().put("cancel", new CancelEditingAction());
    }

    private void _removeEscapeFix() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this._table.getInputMap(1).remove(keyStroke);
        this._table.getActionMap().remove("cancel");
    }

    private class Listener
    extends WindowAdapter
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (!"tableCellEditor".equals(name) && "ancestor".equals(name)) {
                if (OracleTableUI.this._parent != null) {
                    OracleTableUI.this._parent.removeWindowListener(this);
                    OracleTableUI.this._parent = null;
                }
                OracleTableUI.this._parent = WindowUtils.getWindow(OracleTableUI.this._table);
                if (OracleTableUI.this._parent != null) {
                    OracleTableUI.this._parent.addWindowListener(this);
                }
            }
        }

        public void windowActivated(WindowEvent event) {
            this._setSelectionColor("Table.selectionBackground");
        }

        public void windowDeactivated(WindowEvent event) {
            this._setSelectionColor("Table.inactiveSelectionBackground");
        }

        private void _setSelectionColor(String key) {
            Color c;
            Color sbg = OracleTableUI.this._table.getSelectionBackground();
            if ((sbg == null || sbg instanceof UIResource) && (c = UIManager.getColor(key)) != null) {
                OracleTableUI.this._table.setSelectionBackground(c);
            }
        }
    }

    private class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            table.removeEditor();
        }

        public boolean isEnabled() {
            return OracleTableUI.this._table.getEditorComponent() != null;
        }
    }
}

