/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;
import oracle.bali.ewt.olaf.OracleSeparatorPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleSeparatorUI
extends SeparatorUI
implements PainterUI {
    private static Painter _sPopupMenuPainter;
    private static final OracleSeparatorUI _sInstance;

    public static ComponentUI createUI(JComponent component) {
        return _sInstance;
    }

    public Painter getPainter(JComponent component) {
        if (component.getParent() instanceof JPopupMenu) {
            if (_sPopupMenuPainter == null) {
                _sPopupMenuPainter = new PopupMenuPainter();
            }
            return _sPopupMenuPainter;
        }
        boolean horizontal = ((JSeparator)component).getOrientation() == 0;
        return OracleSeparatorPainter.getPainter(horizontal);
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        OracleUIUtils.putPaintContext(component);
        component.setOpaque(false);
        LookAndFeel.installColors(component, "Separator.background", "Separator.foreground");
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    public Dimension getPreferredSize(JComponent component) {
        return OracleUIUtils.getPreferredSize(this, component);
    }

    public Dimension getMinimumSize(JComponent component) {
        return OracleUIUtils.getMinimumSize(this, component);
    }

    public Dimension getMaximumSize(JComponent component) {
        return null;
    }

    public void paint(Graphics g, JComponent component) {
        OracleUIUtils.paint(this, g, component);
    }

    public boolean contains(JComponent component, int x, int y) {
        return OracleUIUtils.contains(this, component, x, y);
    }

    protected OracleSeparatorUI() {
    }

    static {
        _sInstance = new OracleSeparatorUI();
    }

    private static class PopupMenuPainter
    extends AbstractPainter {
        private PopupMenuPainter() {
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            UIDefaults defaults = context.getPaintUIDefaults();
            g.setColor(defaults.getColor("PopupMenuSeparator.foreground"));
            g.drawLine(x, y, width, y);
            g.setColor(defaults.getColor("PopupMenuSeparator.background"));
            g.drawLine(x, y + 1, width, y + 1);
        }

        public Dimension getMinimumSize(PaintContext context) {
            return new Dimension(2, 2);
        }
    }
}

