/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleUIUtils;

public class OracleScrollPaneUI
extends BasicScrollPaneUI
implements Serializable {
    public static ComponentUI createUI(JComponent component) {
        return new OracleScrollPaneUI();
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        OracleUIUtils.putPaintContext(component);
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            OracleUIUtils.fillBackground(g, c);
        }
        JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
        JScrollBar horizontal = this.scrollpane.getHorizontalScrollBar();
        Color savedColor = g.getColor();
        g.setColor(OracleUIUtils.getUIDefaults(c).getColor(ColorScheme.NORMAL_INTENSITY));
        if (vertical != null && vertical.isVisible()) {
            int height = horizontal != null && horizontal.isVisible() ? horizontal.getY() + horizontal.getHeight() - vertical.getY() : vertical.getHeight();
            g.fillRect(vertical.getX(), vertical.getY(), vertical.getWidth(), height);
        }
        if (horizontal != null && horizontal.isVisible()) {
            g.fillRect(horizontal.getX(), horizontal.getY(), horizontal.getWidth(), horizontal.getHeight());
        }
        g.setColor(savedColor);
        this.paint(g, c);
    }

    protected void syncScrollPaneWithViewport() {
        Component view;
        super.syncScrollPaneWithViewport();
        JViewport viewport = this.scrollpane.getViewport();
        if (viewport != null && (view = viewport.getView()) instanceof JComponent) {
            JComponent jcv = (JComponent)view;
            if (jcv instanceof JTextComponent) {
                jcv.setBorder(new BasicBorders.MarginBorder());
            } else if (jcv.getBorder() instanceof UIResource) {
                jcv.setBorder(null);
            }
        }
    }

    private OracleScrollPaneUI() {
    }
}

