/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class OraclePopupMenuBorder
extends AbstractBorderPainter {
    private JPopupMenu _popupMenu;
    private static final ImmInsets _INSETS = new ImmInsets(3, 3, 3, 3);
    private static final ImmInsets _FILL_INSETS = new ImmInsets(2, 2, 2, 2);

    public OraclePopupMenuBorder(Painter wrappedPainter, JPopupMenu popupMenu) {
        super(wrappedPainter);
        this._popupMenu = popupMenu;
    }

    public ImmInsets getOwnFillInsets(PaintContext context) {
        return _FILL_INSETS;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return _INSETS;
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        UIDefaults defaults = context.getPaintUIDefaults();
        boolean square = this._isSquare();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        g.setColor(defaults.getColor(ColorScheme.NORMAL_INTENSITY));
        if (square) {
            g.drawLine(x, y, right - 4, y);
            g.drawLine(x, y, x, bottom - 4);
        } else {
            g.drawLine(x + 3, y, right - 4, y);
            g.drawLine(x + 1, y + 1, x + 2, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
            g.drawLine(x, y + 3, x, bottom - 4);
        }
        g.drawLine(right - 3, y + 1, right - 2, y + 1);
        g.drawLine(right - 2, y + 2, right - 2, y + 2);
        g.drawLine(x + 1, bottom - 3, x + 1, bottom - 2);
        g.drawLine(x + 2, bottom - 2, x + 2, bottom - 2);
        g.drawLine(right - 2, bottom - 3, right - 2, bottom - 2);
        g.drawLine(right - 3, bottom - 2, right - 3, bottom - 2);
        g.drawLine(right - 1, y + 3, right - 1, bottom - 3);
        g.drawLine(x + 3, bottom - 1, right - 4, bottom - 1);
        g.setColor(Color.white);
        if (square) {
            g.drawLine(x + 1, y + 1, right - 4, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, bottom - 4);
        } else {
            g.drawLine(x + 3, y + 1, right - 4, y + 1);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.drawLine(x + 1, y + 3, x + 1, bottom - 4);
        }
        g.drawLine(x + 2, bottom - 3, x + 2, bottom - 3);
        g.drawLine(right - 3, y + 2, right - 3, y + 2);
        g.drawLine(right - 2, y + 3, right - 2, y + 3);
        g.setColor(Color.black);
        g.drawLine(x + 5, bottom, right - 4, bottom);
        g.drawLine(right - 3, bottom - 1, right - 2, bottom - 1);
        g.drawLine(right - 1, bottom - 3, right - 1, bottom - 2);
        g.drawLine(right, y + 5, right, bottom - 4);
        g.setColor(defaults.getColor(ColorScheme.DARK_INTENSITY));
        g.drawLine(x + 2, bottom - 1, x + 2, bottom - 1);
        g.drawLine(x + 4, bottom, x + 4, bottom);
        g.drawLine(right - 3, bottom, right - 3, bottom);
        g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
        g.drawLine(right, bottom - 3, right, bottom - 3);
        g.drawLine(right, y + 4, right, y + 4);
        g.drawLine(right - 1, y + 2, right - 1, y + 2);
        g.setColor(savedColor);
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    private boolean _isSquare() {
        Component invoker = this._popupMenu.getInvoker();
        return invoker instanceof JMenu && invoker.getParent() instanceof JMenuBar;
    }
}

