/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Graphics;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleFocusPainter
extends AbstractBorderPainter {
    private boolean _noInsets;
    private static final ImmInsets _sInsets = new ImmInsets(2, 0, 2, 0);

    public OracleFocusPainter(Painter wrappedPainter) {
        this(wrappedPainter, false);
    }

    public OracleFocusPainter(Painter wrappedPainter, boolean noInsets) {
        super(wrappedPainter);
        this._noInsets = noInsets;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return this._noInsets ? ImmInsets.getEmptyInsets() : _sInsets;
    }

    public Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Painter contentPainter = super.getContentPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        if (proxyPainter == this && contentPainter != null || contentPainter == null && x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            contentPainter = this;
        }
        return contentPainter;
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        if ((context.getPaintState() & 0x40) != 0) {
            this._drawFocusLine(g, x, y, width);
            this._drawFocusLine(g, x, y + height - 1, width);
        }
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 0x20;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    static ImmInsets getFocusInsets() {
        return _sInsets;
    }

    private void _drawFocusLine(Graphics g, int x, int y, int width) {
        int numDashes = width / 3;
        int intWidth = numDashes * 3;
        int endX = x + intWidth;
        while (x < endX) {
            g.drawLine(x, y, x + 1, y);
            x += 3;
        }
        if ((width -= intWidth) > 0) {
            if (width > 2) {
                width = 2;
            }
            g.drawLine(x, y, x + width - 1, y);
        }
    }
}

