/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.graphics.SynthesizingImageSet;
import oracle.bali.ewt.olaf.OracleComboBoxBorderPainter;
import oracle.bali.ewt.olaf.OracleComboBoxButton;
import oracle.bali.ewt.olaf.OracleComboPopup;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.ImmInsets;

public class OracleComboBoxUI
extends BasicComboBoxUI
implements FocusListener {
    private OracleComboBoxButton _button;
    private int _columnWidth;
    private Dimension _cachedMaximumSize;
    private Dimension _cachedPreferredSize;
    private static final Border _sBorder = new BorderAdapter(new OracleComboBoxBorderPainter());
    static final int __ARROW_WIDTH = 14;
    private EnterHack _enterHack;

    private OracleComboBoxUI() {
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
        c.setBorder(_sBorder);
        OracleUIUtils.putPaintContext(c, new PaintCtxt(c));
        this._setEditableColors();
        this._updateButton(false);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setOpaque(true);
        c.setBorder(null);
        OracleUIUtils.removePaintContext(c);
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (key.equals("ComboBox.arrowSet")) {
            SynthesizingImageSet arrowSet = new SynthesizingImageSet(OracleUIUtils.getColorizedImage("choice.gif", OracleUIUtils.getColorScheme()), 1);
            return arrowSet;
        }
        return null;
    }

    protected void uninstallComponents() {
        super.uninstallComponents();
        this._button = null;
    }

    protected void configureEditor() {
        super.configureEditor();
        this.editor.addFocusListener(this);
        this.editor.setEnabled(this.comboBox.isEnabled());
        if (this.keyListener != null) {
            this.editor.addKeyListener(this.keyListener);
        }
        this._setEditableColors();
        this._hackTextField();
    }

    protected void unconfigureEditor() {
        super.unconfigureEditor();
        this.editor.removeFocusListener(this);
        if (this.keyListener != null) {
            this.editor.removeKeyListener(this.keyListener);
        }
        this._unhackTextField();
    }

    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.editor && this.editor instanceof JTextComponent) {
            ((JTextComponent)this.editor).selectAll();
        }
    }

    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.getComboBox().hidePopup();
        }
    }

    public static ComponentUI createUI(JComponent component) {
        return new OracleComboBoxUI();
    }

    protected LayoutManager createLayoutManager() {
        return new Layout();
    }

    public Dimension getPreferredSize(JComponent c) {
        if (!this.isMinimumSizeDirty && this._cachedPreferredSize != null) {
            return new Dimension(this._cachedPreferredSize);
        }
        Integer prefCols = (Integer)c.getClientProperty("preferredColumns");
        if (prefCols != null) {
            Dimension d = super.getPreferredSize(c);
            int cols = prefCols;
            if (cols > 0) {
                d.width = this._getWidthForColumns(cols);
            }
            this._cachedPreferredSize = this._addStandardInsets(d);
            this._cachedPreferredSize = this._addOracleInsets(this._cachedPreferredSize);
            return new Dimension(this._cachedPreferredSize);
        }
        return super.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty && this.cachedMinimumSize != null) {
            return new Dimension(this.cachedMinimumSize);
        }
        Integer minCols = (Integer)c.getClientProperty("minimumColumns");
        if (minCols != null) {
            Dimension d = super.getMinimumSize(c);
            int cols = minCols;
            if (cols > 0) {
                d.width = this._getWidthForColumns(cols);
            }
            this.cachedMinimumSize = this._addStandardInsets(d);
            this.cachedMinimumSize = this._addOracleInsets(this.cachedMinimumSize);
            return new Dimension(this.cachedMinimumSize);
        }
        return super.getMinimumSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        if (!this.isMinimumSizeDirty && this._cachedMaximumSize != null) {
            return new Dimension(this._cachedMaximumSize);
        }
        Integer maxCols = (Integer)c.getClientProperty("maximumColumns");
        if (maxCols != null) {
            Dimension d = super.getMaximumSize(c);
            int cols = maxCols;
            if (cols > 0) {
                d.width = this._getWidthForColumns(cols);
            }
            this._cachedMaximumSize = this._addStandardInsets(d);
            this._cachedMaximumSize = this._addOracleInsets(this._cachedMaximumSize);
            return new Dimension(this._cachedMaximumSize);
        }
        return super.getMaximumSize(c);
    }

    protected Dimension getDisplaySize() {
        Dimension d = super.getDisplaySize();
        return this._addOracleInsets(d);
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        final JComboBox cBox = this.comboBox;
        JButton button = this.arrowButton;
        AbstractAction downAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OracleComboBoxUI.this.selectNextPossibleValue();
            }

            public boolean isEnabled() {
                return cBox.isEnabled();
            }
        };
        this.comboBox.registerKeyboardAction(downAction, KeyStroke.getKeyStroke(40, 0), 1);
        AbstractAction upAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OracleComboBoxUI.this.selectPreviousPossibleValue();
            }

            public boolean isEnabled() {
                return cBox.isEnabled();
            }
        };
        this.comboBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 1);
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        OracleComboPopup popup = (OracleComboPopup)this.getPopup();
        if (popup != null) {
            popup.hackEscape();
        }
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
    }

    protected ListDataListener createListDataListener() {
        return new ModelListener();
    }

    protected ComboBoxEditor createEditor() {
        return new OracleComboBoxEditor();
    }

    ComboPopup __getPopup() {
        return this.popup;
    }

    JList __getList() {
        return this.listBox;
    }

    JComboBox __getComboBox() {
        return this.comboBox;
    }

    Component __getEditor() {
        return this.editor;
    }

    private void _hackTextField() {
        Component c = this.comboBox.getEditor().getEditorComponent();
        if (!(c instanceof JTextField)) {
            return;
        }
        JTextField textField = (JTextField)this.comboBox.getEditor().getEditorComponent();
        ActionMap actionMap = textField.getActionMap();
        actionMap.put("notify-field-accept", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
            }

            public boolean isEnabled() {
                return false;
            }
        });
        InputMap inputMap = textField.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "notify-field-accept");
        this._enterHack = new EnterHack();
        textField.addKeyListener(this._enterHack);
    }

    private void _unhackTextField() {
        Component c;
        if (this._enterHack != null && (c = this.comboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            c.removeKeyListener(this._enterHack);
        }
    }

    protected ComboPopup createPopup() {
        OracleComboPopup popup = new OracleComboPopup(this.comboBox, (OracleComboBoxButton)this.createArrowButton());
        this._button.setList(popup.getList());
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        UIDefaults defaults = OracleUIUtils.getUIDefaults(this.comboBox);
        popup.setBorder(defaults.getBorder("PopupMenu.border"));
        return popup;
    }

    protected KeyListener createKeyListener() {
        return new OracleKeyHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new OraclePropertyChangeHandler();
    }

    protected FocusListener createFocusListener() {
        return new OracleFocusHandler();
    }

    void layoutComboBox(Container parent, Layout manager) {
        if (this.comboBox.isEditable()) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = this.getInsets();
            int buttonHeight = height - (insets.top + insets.bottom);
            int buttonWidth = this.arrowButton.getPreferredSize().width;
            if (this.arrowButton != null) {
                this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
            }
            if (this.editor != null) {
                this.editor.setBounds(this.rectangleForCurrentValue());
            }
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int width = this.comboBox.getWidth();
            int height = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
        }
    }

    JComboBox getComboBox() {
        return this.comboBox;
    }

    JButton getArrowButton() {
        return this.arrowButton;
    }

    Component getEditor() {
        return this.editor;
    }

    ComboPopup getPopup() {
        return this.popup;
    }

    protected JButton createArrowButton() {
        if (this._button == null) {
            this._button = new OracleComboBoxButton(this.comboBox, this.currentValuePane);
            this._button.setIconOnly(this.comboBox.isEditable());
        }
        return this._button;
    }

    private Dimension _addStandardInsets(Dimension d) {
        Insets insets = this.getInsets();
        int buttonSize = d.height - (insets.top + insets.bottom);
        d.width += insets.left + insets.right + buttonSize;
        return d;
    }

    private Dimension _addOracleInsets(Dimension d) {
        ImmInsets focusInsets = OracleFocusPainter.getFocusInsets();
        d.width += focusInsets.left + focusInsets.right;
        d.height += focusInsets.top + focusInsets.bottom;
        d.height -= 4;
        return d;
    }

    private int _getColumnWidth() {
        if (this._columnWidth == 0) {
            FontMetrics metrics = this.editor.getFontMetrics(this.editor.getFont());
            this._columnWidth = metrics.charWidth('m');
        }
        return this._columnWidth;
    }

    private int _getWidthForColumns(int columns) {
        int width = 0;
        if (this.comboBox.isEditable()) {
            width = columns * this._getColumnWidth();
        } else {
            StringBuffer buffer = new StringBuffer(columns);
            for (int i = 0; i < columns; ++i) {
                buffer.append("m");
            }
            String dummy = buffer.toString();
            ListCellRenderer<String> renderer = this.comboBox.getRenderer();
            Component c = renderer.getListCellRendererComponent(this.listBox, dummy, -1, false, false);
            this.currentValuePane.add(c);
            c.setFont(this.comboBox.getFont());
            width = c.getPreferredSize().width;
            this.currentValuePane.remove(c);
        }
        return width;
    }

    private void _dirtyMinimumSize() {
        this.isMinimumSizeDirty = true;
    }

    private void _setEditableColors() {
        UIDefaults defaults = OracleUIUtils.getUIDefaults(this.comboBox);
        if (this.editor != null) {
            if (this.editor instanceof JComponent) {
                ((JComponent)this.editor).setOpaque(true);
            }
            this.editor.setBackground(this.comboBox.isEnabled() ? new ColorUIResource(defaults.getColor("text")) : new ColorUIResource(defaults.getColor("control")));
        }
        if (this.popup != null) {
            JList<Object> list = this.popup.getList();
            list.setBackground(this.comboBox.isEditable() ? new ColorUIResource(defaults.getColor("text")) : new ColorUIResource(defaults.getColor("control")));
        }
    }

    private void _updateButton(boolean hideDropDown) {
        this.arrowButton.setEnabled(this.comboBox.isEnabled() && (this.comboBox.getItemCount() > 1 || this.comboBox.getItemCount() == 1 && this.comboBox.getSelectedItem() != this.comboBox.getItemAt(0)));
        if (hideDropDown) {
            this.getComboBox().setPopupVisible(false);
        }
    }

    private class ModelListener
    extends BasicComboBoxUI.ListDataHandler {
        private ModelListener() {
            super(OracleComboBoxUI.this);
        }

        public void intervalAdded(ListDataEvent e) {
            super.intervalAdded(e);
            OracleComboBoxUI.this._updateButton(false);
        }

        public void intervalRemoved(ListDataEvent e) {
            super.intervalRemoved(e);
            OracleComboBoxUI.this._updateButton(false);
        }

        public void contentsChanged(ListDataEvent e) {
            super.contentsChanged(e);
            OracleComboBoxUI.this._updateButton(false);
        }
    }

    private class PaintCtxt
    extends JPaintContext {
        public PaintCtxt(JComponent comp) {
            super(comp);
        }

        public int getPaintState() {
            int state = super.getPaintState();
            if (OracleComboBoxUI.this.getComboBox().isPopupVisible()) {
                state |= 2;
            }
            return state;
        }
    }

    private class Layout
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private Layout() {
            super(OracleComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            OracleComboBoxUI.this.layoutComboBox(parent, this);
        }

        public void superLayout(Container parent) {
            super.layoutContainer(parent);
        }
    }

    private class OracleFocusHandler
    extends BasicComboBoxUI.FocusHandler {
        private OracleFocusHandler() {
            super(OracleComboBoxUI.this);
        }

        public void focusGained(FocusEvent e) {
            if (OracleComboBoxUI.this.getComboBox().isEditable() && OracleComboBoxUI.this.getEditor() != null) {
                FocusUtils.requestFocus(OracleComboBoxUI.this.getEditor());
            }
            super.focusGained(e);
        }
    }

    protected class OraclePropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        protected OraclePropertyChangeHandler() {
            super(OracleComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("font")) {
                OracleComboBoxUI.this._columnWidth = 0;
            }
            super.propertyChange(e);
            if (propertyName.equals("editable")) {
                boolean editable = OracleComboBoxUI.this.getComboBox().isEditable();
                if (!FocusUtils.areNewFocusAPIsAvailable() && editable) {
                    OracleComboBoxUI.this.getComboBox().setRequestFocusEnabled(true);
                }
                if (OracleComboBoxUI.this.getArrowButton() instanceof OracleComboBoxButton) {
                    ((OracleComboBoxButton)OracleComboBoxUI.this.getArrowButton()).setIconOnly(editable);
                }
            } else if (propertyName.equals("enabled")) {
                OracleComboBoxUI.this._setEditableColors();
                if (OracleComboBoxUI.this.getEditor() != null) {
                    OracleComboBoxUI.this.getEditor().setEnabled(OracleComboBoxUI.this.getComboBox().isEnabled());
                }
                OracleComboBoxUI.this._updateButton(true);
            } else if ("model".equals(propertyName)) {
                OracleComboBoxUI.this._updateButton(false);
            } else if (propertyName.equals("maximumColumns") || propertyName.equals("mimimumColumns") || propertyName.equals("preferredColumns")) {
                OracleComboBoxUI.this._dirtyMinimumSize();
            }
        }
    }

    public class OracleKeyHandler
    extends BasicComboBoxUI.KeyHandler {
        public OracleKeyHandler() {
            super(OracleComboBoxUI.this);
        }

        public void keyPressed(KeyEvent e) {
            JComboBox combo = OracleComboBoxUI.this.getComboBox();
            ComboPopup popup = OracleComboBoxUI.this.getPopup();
            if (e.getKeyCode() == 115 && e.getModifiers() == 0) {
                OracleComboBoxUI.this.getComboBox().setPopupVisible(!popup.isVisible());
                e.consume();
            } else if (e.isAltDown() && e.getKeyCode() != 18) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    OracleComboBoxUI.this.getComboBox().setPopupVisible(!popup.isVisible());
                    e.consume();
                }
            } else if (!combo.isEditable() || popup.isVisible()) {
                super.keyPressed(e);
            }
        }

        public void keyTyped(KeyEvent e) {
            if (OracleComboBoxUI.this.getComboBox().isEditable() && OracleComboBoxUI.this.getPopup().isVisible()) {
                e.consume();
            }
        }
    }

    class OracleComboTextField
    extends JTextField {
        public OracleComboTextField(String value, int n) {
            super(value, n);
            this.setOpaque(true);
        }

        public void setBorder(Border b) {
        }

        public void setOpaque(boolean opaque) {
            if (opaque) {
                super.setOpaque(opaque);
            }
        }
    }

    private class EnterHack
    extends KeyAdapter {
        private EnterHack() {
        }

        public void keyPressed(KeyEvent event) {
            JTextField textField = (JTextField)OracleComboBoxUI.this.__getEditor();
            if (event.getKeyCode() == 10) {
                if (OracleComboBoxUI.this.__getPopup().isVisible()) {
                    Object keyNav = OracleComboBoxUI.this.__getComboBox().getClientProperty("JComboBox.lightweightKeyboardNavigation");
                    if ("Lightweight".equals(keyNav)) {
                        OracleComboBoxUI.this.__getComboBox().setSelectedIndex(OracleComboBoxUI.this.__getList().getSelectedIndex());
                    }
                    event.consume();
                }
                textField.postActionEvent();
            }
        }
    }

    private class OracleComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource {
        public OracleComboBoxEditor() {
            this.editor = new OracleComboTextField("", 9);
            this.editor.addFocusListener(this);
        }
    }
}

