/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.util.WindowUtils;

public class BrowserPanelUI
extends BasicPanelUI
implements PropertyChangeListener {
    private static final BrowserPanelUI _sInstance = new BrowserPanelUI();
    private static final String _DEFAULT_WHEN_ADDED_PROPERTY = "OLAF.defaultBGWhenAdded";
    private static final String _OLD_BACKGROUND = "OLAF.oldBackground";

    public static ComponentUI createUI(JComponent component) {
        return _sInstance;
    }

    public void installUI(JComponent component) {
        Container parent;
        Color oldBackground = component.getBackground();
        boolean resource = oldBackground instanceof UIResource;
        super.installUI(component);
        if (component.getClass() == JPanel.class) {
            component.addPropertyChangeListener(this);
            BrowserPanelUI._registerWindow(component.getParent());
        }
        if ((parent = component.getParent()) == null) {
            component.putClientProperty(_DEFAULT_WHEN_ADDED_PROPERTY, Boolean.TRUE);
        } else if (!(parent.getParent() instanceof JRootPane)) {
            if (resource) {
                component.setBackground(null);
            }
        } else if (resource) {
            component.putClientProperty(_OLD_BACKGROUND, oldBackground);
            Color c = UIManager.getDefaults().getColor("EWTDialog.background");
            component.setBackground(c);
        }
        OracleUIUtils.putPaintContext(component);
    }

    public void uninstallUI(JComponent component) {
        Object o;
        super.uninstallUI(component);
        if (component.getClass() == JPanel.class) {
            component.removePropertyChangeListener(this);
            BrowserPanelUI._unregisterWindow(component.getParent());
        }
        if ((o = component.getClientProperty(_OLD_BACKGROUND)) instanceof Color) {
            component.setBackground((Color)o);
        }
        OracleUIUtils.removePaintContext(component);
    }

    public void propertyChange(PropertyChangeEvent event) {
        JComponent component = (JComponent)event.getSource();
        if ("ancestor".equals(event.getPropertyName())) {
            boolean defaultWhenAdded;
            BrowserPanelUI._unregisterWindow((Component)event.getOldValue());
            Component newParent = (Component)event.getNewValue();
            BrowserPanelUI._registerWindow(newParent);
            boolean bl = defaultWhenAdded = component.getClientProperty(_DEFAULT_WHEN_ADDED_PROPERTY) != null;
            if (defaultWhenAdded && newParent != null) {
                if (!(newParent instanceof JRootPane) && !(newParent.getParent() instanceof JRootPane)) {
                    component.setBackground(null);
                } else {
                    component.putClientProperty(_OLD_BACKGROUND, component.getBackground());
                    Color c = UIManager.getDefaults().getColor("EWTDialog.background");
                    component.setBackground(c);
                }
            }
        } else if ("background".equals(event.getPropertyName())) {
            component.putClientProperty(_DEFAULT_WHEN_ADDED_PROPERTY, null);
        }
    }

    private static void _registerWindow(Component parent) {
        Window w;
        if (parent instanceof JRootPane && (w = BrowserPanelUI._getWindow(parent.getParent())) != null) {
            WindowUtils.registerWindow(w);
        }
    }

    private static void _unregisterWindow(Component parent) {
        Window w;
        if (parent instanceof JRootPane && (w = BrowserPanelUI._getWindow(parent.getParent())) != null) {
            WindowUtils.unregisterWindow(w);
        }
    }

    private static Window _getWindow(Component c) {
        while (c != null) {
            if (c instanceof JInternalFrame) {
                return null;
            }
            if (c instanceof Window) {
                return (Window)c;
            }
            c = c.getParent();
        }
        return null;
    }

    private BrowserPanelUI() {
    }
}

