/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import java.text.Collator;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.RowComparator;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;

public class SortableTwoDModel
extends AbstractTwoDModel
implements Sortable {
    private int _columns;
    private int _rows;
    private ArrayOneDModel _data;
    private ArrayOneDModel _comparators;
    private Comparator _defaultComparator;
    private RowComparator _sorter;

    public SortableTwoDModel() {
        this(0, 0);
    }

    public SortableTwoDModel(int columns, int rows) {
        this._columns = columns;
        this._rows = rows;
        this._data = new ArrayOneDModel(this._rows);
        this._sorter = new RowComparator();
    }

    public void addColumns(int startIndex, int numberOfColumns) {
        if (numberOfColumns == 0) {
            return;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            ArrayOneDModel row = (ArrayOneDModel)this._data.getData(i);
            if (row == null) continue;
            row.addItems(startIndex, numberOfColumns);
        }
        if (this._comparators != null) {
            this._comparators.addItems(startIndex, numberOfColumns);
        }
        this._columns += numberOfColumns;
        this.fireModelEvent(2001, startIndex, numberOfColumns);
    }

    public void removeColumns(int startIndex, int numberOfColumns) {
        if (numberOfColumns == 0) {
            return;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            ArrayOneDModel row = (ArrayOneDModel)this._data.getData(i);
            if (row == null) continue;
            row.removeItems(startIndex, numberOfColumns);
        }
        if (this._comparators != null) {
            this._comparators.removeItems(startIndex, numberOfColumns);
        }
        this._columns -= numberOfColumns;
        this.fireModelEvent(2002, startIndex, numberOfColumns);
    }

    public void addRows(int startIndex, int numberOfRows) {
        if (numberOfRows == 0) {
            return;
        }
        this._data.addItems(startIndex, numberOfRows);
        this._rows += numberOfRows;
        this.fireModelEvent(2004, startIndex, numberOfRows);
    }

    public void removeRows(int startIndex, int numberOfRows) {
        if (numberOfRows == 0) {
            return;
        }
        this._data.removeItems(startIndex, numberOfRows);
        this._rows -= numberOfRows;
        this.fireModelEvent(2005, startIndex, numberOfRows);
    }

    public int getColumnCount() {
        return this._columns;
    }

    public int getRowCount() {
        return this._rows;
    }

    public Object getData(int columnIndex, int rowIndex) {
        ArrayOneDModel row = (ArrayOneDModel)this._data.getData(rowIndex);
        if (row == null) {
            return null;
        }
        return row.getData(columnIndex);
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        ArrayOneDModel row = (ArrayOneDModel)this._data.getData(rowIndex);
        if (row == null) {
            row = new ArrayOneDModel(this.getColumnCount());
            this._data.setData(rowIndex, row);
        }
        row.setData(columnIndex, data);
        this.fireModelEvent(2007, columnIndex, 1, rowIndex, 1);
    }

    public void setColumnComparator(int column, Comparator c) {
        if (this._comparators == null) {
            this._comparators = new ArrayOneDModel(this.getColumnCount());
        }
        this._comparators.setData(column, c);
    }

    public Comparator getColumnComparator(int column) {
        Comparator c;
        if (this._comparators != null && (c = (Comparator)this._comparators.getData(column)) != null) {
            return c;
        }
        return this.getDefaultComparator();
    }

    public Comparator getDefaultComparator() {
        if (this._defaultComparator == null) {
            this._defaultComparator = new StringComparator(Collator.getInstance());
        }
        return this._defaultComparator;
    }

    public void setDefaultComparator(Comparator comparator) {
        this._defaultComparator = comparator;
    }

    public void sort(int column, boolean ascending) {
        int count = this._rows;
        if (count == 0) {
            return;
        }
        Comparator c = this.getColumnComparator(column);
        this._sorter.setComparisonData(column, c, ascending);
        Object[] data = new Object[count];
        for (int i = 0; i < count; ++i) {
            data[i] = this._data.getData(i);
        }
        Sort.qSort((Object[])data, (int)data.length, (Comparator)this._sorter);
        this._data.removeItems(0, count);
        this._data.addItems(0, data);
        this.fireModelEvent(2007, 0, this._columns, 0, this._rows);
    }
}

