/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Enumeration;
import oracle.bali.ewt.layout.EqualLayout;

public class EqualColumnLayout
extends EqualLayout {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_END = 2;

    public EqualColumnLayout() {
    }

    public EqualColumnLayout(int interiorGap) {
        super(interiorGap);
    }

    public EqualColumnLayout(int interiorGap, int layoutAlignment, int perpendicularAlignment) {
        super(interiorGap, layoutAlignment, perpendicularAlignment);
    }

    public void layoutContainer(Container target) {
        int cellWidth;
        int layoutAlignment = this.getLayoutAlignment();
        Insets containerInsets = target.getInsets();
        Dimension size = target.getSize();
        int width = size.width;
        int height = size.height;
        int numVisibleChildren = EqualColumnLayout.getNumberVisibleChildren(target);
        int cellHeight = height - containerInsets.top - containerInsets.bottom;
        if (numVisibleChildren > 1) {
            cellHeight -= this.getInteriorGap() * (numVisibleChildren - 1);
            cellHeight /= numVisibleChildren;
        }
        Dimension cellPrefSize = this.getCellSize(target, true);
        if (cellHeight > cellPrefSize.height) {
            cellHeight = cellPrefSize.height;
        }
        if ((cellWidth = width - containerInsets.left - containerInsets.right) > cellPrefSize.width) {
            cellWidth = cellPrefSize.width;
        }
        int y = containerInsets.top;
        if (layoutAlignment != 0) {
            int totalHeight = cellHeight * numVisibleChildren;
            if (numVisibleChildren > 1) {
                totalHeight += this.getInteriorGap() * (numVisibleChildren - 1);
            }
            y = layoutAlignment == 2 ? height - totalHeight - containerInsets.bottom : (y += height - totalHeight >> 1);
        }
        int perpendicularAlignment = this.getPerpendicularAlignment();
        Enumeration componentEnumeration = this.getComponentEnumeration(target);
        while (componentEnumeration.hasMoreElements()) {
            Component currChild = (Component)componentEnumeration.nextElement();
            if (!currChild.isVisible()) continue;
            int x = containerInsets.left;
            if (perpendicularAlignment != 0) {
                x = perpendicularAlignment == 2 ? width - containerInsets.right - cellWidth : (x += width - containerInsets.left - containerInsets.right - cellWidth >> 1);
            }
            currChild.setBounds(x, y, cellWidth, cellHeight);
            y += cellHeight + this.getInteriorGap();
        }
    }

    protected Dimension getInsetLayoutSize(Container target, boolean usePreferredSize) {
        int numVisibleChildren = EqualColumnLayout.getNumberVisibleChildren(target);
        Dimension cellSize = this.getCellSize(target, usePreferredSize);
        int height = cellSize.height * numVisibleChildren;
        if (numVisibleChildren > 1) {
            height += this.getInteriorGap() * (numVisibleChildren - 1);
        }
        return new Dimension(cellSize.width, height);
    }
}

