/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.help;

import java.awt.Component;
import javax.swing.JComponent;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;

public class HelpUtils {
    private static final String _PROPERTY_PROVIDER = "JEWT.HelpProvider";
    private static final String _PROPERTY_HELPSET = "HelpSet";
    private static final String _PROPERTY_ID = "HelpID";
    private static HelpProvider _sDefaultProvider;
    private static Object _sDefaultHelpSet;
    private static String _sDefaultHelpID;

    private HelpUtils() {
    }

    public static void showHelp(Component component) throws HelpUnavailableException {
        HelpProvider provider = HelpUtils.getHelpProvider(component);
        if (provider == null) {
            throw new HelpUnavailableException(null, "No help provider");
        }
        provider.showHelp(component);
    }

    public static void setDefaultHelpProvider(HelpProvider provider) {
        _sDefaultProvider = provider;
    }

    public static HelpProvider getDefaultHelpProvider() {
        return _sDefaultProvider;
    }

    public static void setDefaultHelpSet(Object helpset) {
        _sDefaultHelpSet = helpset;
    }

    public static Object getDefaultHelpSet() {
        return _sDefaultHelpSet;
    }

    public static void setDefaultHelpID(String id) {
        _sDefaultHelpID = id;
    }

    public static String getDefaultHelpID() {
        return _sDefaultHelpID;
    }

    public static void setHelpProvider(JComponent component, HelpProvider provider) {
        component.putClientProperty(_PROPERTY_PROVIDER, provider);
    }

    public static void setHelpSet(JComponent component, Object helpset) {
        component.putClientProperty(_PROPERTY_HELPSET, helpset);
    }

    public static void setHelpID(JComponent component, String id) {
        component.putClientProperty(_PROPERTY_ID, id);
    }

    public static HelpProvider getHelpProvider(Component component) {
        while (component != null) {
            Object providerObj;
            if (component instanceof JComponent && (providerObj = ((JComponent)component).getClientProperty(_PROPERTY_PROVIDER)) instanceof HelpProvider) {
                return (HelpProvider)providerObj;
            }
            component = component.getParent();
        }
        return HelpUtils.getDefaultHelpProvider();
    }

    public static Object getHelpSet(Component component) {
        while (component != null) {
            Object helpSet;
            if (component instanceof JComponent && (helpSet = ((JComponent)component).getClientProperty(_PROPERTY_HELPSET)) != null) {
                return helpSet;
            }
            component = component.getParent();
        }
        return HelpUtils.getDefaultHelpSet();
    }

    public static String getHelpID(Component component) {
        while (component != null) {
            JComponent jc;
            Object helpIDObj;
            if (component instanceof JComponent && (helpIDObj = (jc = (JComponent)component).getClientProperty(_PROPERTY_ID)) instanceof String) {
                return (String)helpIDObj;
            }
            component = component.getParent();
        }
        return HelpUtils.getDefaultHelpID();
    }
}

