/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.hGrid;

import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.grid.hGrid.HTwoDModel;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;

public class HArrayTwoDModel
extends AbstractTwoDModel
implements HTwoDModel {
    public static final int ROW_NOT_VISIBLE = -1;
    public static final int ROOT_PARENT_INDEX = -1;
    private int[] _visibleToStoreTable;
    private ArrayTwoDModel _store;

    public HArrayTwoDModel(int columns, int rows) {
        if (columns <= 0) {
            throw new IllegalArgumentException("Must have at least one column");
        }
        this._store = new ArrayTwoDModel(columns, 0);
        this.addRowsAtDepth(0, rows, 0, -1);
    }

    public int getColumnCount() {
        return this._store.getColumnCount();
    }

    public final int getRowCount() {
        if (this._visibleToStoreTable == null) {
            return 0;
        }
        return this._visibleToStoreTable.length;
    }

    public final Object getData(int columnIndex, int rowIndex) {
        return this.getExpandedData(columnIndex, this._visibleToStoreTable[rowIndex]);
    }

    public final void setData(int columnIndex, int rowIndex, Object data) {
        this.setExpandedData(columnIndex, this._visibleToStoreTable[rowIndex], data);
    }

    public final void expandRow(int columnIndex, int rowIndex) {
        if (columnIndex != 0) {
            throw new IllegalArgumentException();
        }
        this.expandExpandedRow(this._visibleToStoreTable[rowIndex]);
    }

    public final void collapseRow(int columnIndex, int rowIndex) {
        if (columnIndex != 0) {
            throw new IllegalArgumentException();
        }
        this.collapseExpandedRow(this._visibleToStoreTable[rowIndex]);
    }

    public int getExpandedRowCount() {
        return this._store.getRowCount();
    }

    public Object getExpandedData(int column, int row) {
        return this._store.getData(column, row);
    }

    public void setExpandedData(int column, int row, Object data) {
        if (column == 0) {
            Data hData = this._getRowHData(row);
            hData._data = data;
            data = hData;
        }
        this.setStoreData(column, row, data);
    }

    public boolean isRowExpanded(int columnIndex, int rowIndex) {
        return this._getRowHData(this._visibleToStoreTable[rowIndex]).isExpanded();
    }

    public void expandExpandedRow(int rowIndex) {
        Data hData = this._getRowHData(rowIndex);
        if (hData.isExpanded()) {
            return;
        }
        hData._expanded = true;
        this.sendCellInvalidateEvent(0, rowIndex);
        if (!this.isRowVisible(rowIndex)) {
            return;
        }
        if (hData._hasChildren) {
            int childCount = this._getVisibleDescendantCount(rowIndex);
            int startTableIndex = this.getVisibleIndex(rowIndex) + 1;
            this._expandTable(startTableIndex, childCount);
            int[] visibleToStore = this._visibleToStoreTable;
            int depth = hData.getDepth();
            int rowCount = this.getExpandedRowCount();
            int tableIndex = startTableIndex;
            while (++rowIndex < rowCount && (hData = this._getRowHData(rowIndex)).getDepth() > depth) {
                visibleToStore[tableIndex++] = rowIndex;
                if (!hData.hasChildren() || hData.isExpanded()) continue;
                rowIndex += this.getDescendantCount(rowIndex);
            }
            this.fireModelEvent(2004, startTableIndex, childCount);
        }
    }

    public void collapseExpandedRow(int rowIndex) {
        Data hData = this._getRowHData(rowIndex);
        if (!hData.isExpanded()) {
            return;
        }
        if (!this.isRowVisible(rowIndex)) {
            hData._expanded = false;
            return;
        }
        int childCount = -1;
        int tableIndex = -1;
        if (hData._hasChildren) {
            childCount = this._getVisibleDescendantCount(rowIndex);
            tableIndex = this.getVisibleIndex(rowIndex) + 1;
            this._shrinkTable(tableIndex, childCount);
        }
        hData._expanded = false;
        if (childCount != -1) {
            this.fireModelEvent(2005, tableIndex, childCount);
        }
        this.sendCellInvalidateEvent(0, rowIndex);
    }

    public int getVisibleIndex(int expandedIndex) {
        if (!this.isRowVisible(expandedIndex)) {
            return -1;
        }
        int index = this._findNewVisibleIndex(expandedIndex);
        return index;
    }

    public int getExpandedIndex(int visibleIndex) {
        if (this._visibleToStoreTable != null) {
            return this._visibleToStoreTable[visibleIndex];
        }
        return -1;
    }

    public void addChildrenRows(int rowIndex, int numberOfRows) {
        this.addRowsAtDepth(rowIndex + 1, numberOfRows, this._getRowDepth(rowIndex) + 1, rowIndex);
    }

    public void addRootRows(int rowIndex, int numberOfRows) {
        if (rowIndex < this.getExpandedRowCount() && this._getRowDepth(rowIndex) > 0) {
            throw new IllegalArgumentException("Can't insert root item here");
        }
        this.addRowsAtDepth(rowIndex, numberOfRows, 0, -1);
    }

    public int addSiblingRows(int rowIndex, int numberOfRows) {
        int depth = this._getRowDepth(rowIndex);
        int parentIndex = this.getParentRow(rowIndex);
        rowIndex += this.getDescendantCount(rowIndex) + 1;
        this.addRowsAtDepth(rowIndex, numberOfRows, depth, parentIndex);
        return rowIndex;
    }

    public int removeRows(int rowIndex, int numberOfRows) {
        int totalRows = 0;
        int depth = this._getRowDepth(rowIndex);
        int currentRow = rowIndex;
        int visibleIndex = this.getVisibleIndex(rowIndex);
        int parentIndex = this.getParentRow(rowIndex);
        int totalCount = this.getExpandedRowCount();
        for (int i = 0; i < numberOfRows; ++i) {
            if (this._getRowDepth(currentRow) != depth) {
                throw new IllegalArgumentException("Illegal numberOfRows");
            }
            int skip = this.getDescendantCount(currentRow) + 1;
            totalRows += skip;
            if ((currentRow += skip) == totalCount) break;
        }
        int visibleCount = 0;
        if (visibleIndex != -1) {
            int endRow = rowIndex + totalRows - 1;
            visibleCount = this._findNewVisibleIndex(endRow) - visibleIndex + 1;
            if (!this.isRowVisible(endRow)) {
                --visibleCount;
            }
            this._shrinkTable(visibleIndex, visibleCount);
        }
        int[] indices = this._visibleToStoreTable;
        for (int i = 0; i < indices.length; ++i) {
            int storeIndex = indices[i];
            if (storeIndex < rowIndex) continue;
            indices[i] = storeIndex - totalRows;
        }
        this._store.removeRows(rowIndex, totalRows);
        int newRowTotal = this._store.getRowCount();
        for (int i = rowIndex; i < newRowTotal; ++i) {
            Data rowData = this._getRowHData(i);
            int pIndex = rowData.getParentRow();
            if (pIndex < rowIndex) continue;
            rowData._parentRow = pIndex - numberOfRows;
        }
        if (visibleCount > 0) {
            this.fireModelEvent(2005, visibleIndex, visibleCount);
        }
        if (parentIndex != -1) {
            boolean childrenGone;
            if (this.getExpandedRowCount() - 1 == parentIndex) {
                childrenGone = true;
            } else {
                boolean bl = childrenGone = this._getRowDepth(parentIndex + 1) != depth;
            }
            if (childrenGone) {
                Data parent = this._getRowHData(parentIndex);
                parent._hasChildren = false;
                if (!parent._claimHasChildren) {
                    this.sendCellInvalidateEvent(0, parentIndex);
                }
            }
        }
        return totalRows;
    }

    public void claimRowHasChildren(int row, boolean turnOn) {
        Data hData = this._getRowHData(row);
        boolean hadChildren = hData.hasChildren();
        hData._claimHasChildren = turnOn;
        if (hadChildren != hData.hasChildren()) {
            this.sendCellInvalidateEvent(0, row);
        }
    }

    public int getParentRow(int rowIndex) {
        return this._getRowHData(rowIndex).getParentRow();
    }

    public boolean isRowVisible(int rowIndex) {
        while (rowIndex >= 0) {
            if ((rowIndex = this.getParentRow(rowIndex)) == -1 || this._getRowHData(rowIndex).isExpanded()) continue;
            return false;
        }
        return true;
    }

    public int getDescendantCount(int rowIndex) {
        int depth = this._getRowDepth(rowIndex);
        int rowCount = this.getExpandedRowCount();
        int descendantCount = 0;
        while (++rowIndex < rowCount && this._getRowDepth(rowIndex) > depth) {
            ++descendantCount;
        }
        return descendantCount;
    }

    protected void addRowsAtDepth(int startIndex, int numberOfRows, int depth, int parentRow) {
        if (numberOfRows == 0) {
            return;
        }
        if (startIndex < this.getExpandedRowCount() && this._getRowDepth(startIndex) > depth) {
            throw new IllegalArgumentException();
        }
        if (parentRow == -1) {
            if (depth != 0) {
                throw new IllegalArgumentException();
            }
        } else {
            Data parent = this._getRowHData(parentRow);
            int parentDepth = parent.getDepth();
            if (parentDepth != depth - 1) {
                throw new IllegalArgumentException();
            }
            if (!parent._hasChildren) {
                parent._hasChildren = true;
                if (!parent._claimHasChildren) {
                    this.sendCellInvalidateEvent(0, parentRow);
                }
            }
        }
        this._store.addRows(startIndex, numberOfRows);
        for (int i = 0; i < numberOfRows; ++i) {
            Data newRow = new Data(depth, parentRow);
            this._store.setData(0, startIndex + i, newRow);
        }
        int[] indices = this._visibleToStoreTable;
        if (indices != null) {
            for (int i = 0; i < indices.length; ++i) {
                int storeIndex = indices[i];
                if (storeIndex < startIndex) continue;
                indices[i] = storeIndex + numberOfRows;
            }
        }
        int newRowTotal = this._store.getRowCount();
        for (int i = startIndex + numberOfRows; i < newRowTotal; ++i) {
            Data rowData = this._getRowHData(i);
            int parentIndex = rowData.getParentRow();
            if (parentIndex < startIndex) continue;
            rowData._parentRow = parentIndex + numberOfRows;
        }
        if (this.isRowVisible(startIndex)) {
            int insertAt = startIndex > 0 ? this._findNewVisibleIndex(startIndex) : 0;
            this._expandTable(insertAt, numberOfRows);
            indices = this._visibleToStoreTable;
            for (int i = 0; i < numberOfRows; ++i) {
                indices[insertAt + i] = startIndex + i;
            }
            this.fireModelEvent(2004, insertAt, numberOfRows);
        }
    }

    protected void setStoreData(int column, int row, Object data) {
        this._store.setData(column, row, data);
        this.sendCellInvalidateEvent(column, row);
    }

    protected void sendCellInvalidateEvent(int column, int row) {
        int visibleIndex = this.getVisibleIndex(row);
        if (visibleIndex != -1) {
            this.fireModelEvent(2007, column, 1, visibleIndex, 1);
        }
    }

    private Data _getRowHData(int rowIndex) {
        return (Data)this.getExpandedData(0, rowIndex);
    }

    private int _getRowDepth(int index) {
        return ((HDataObject)this.getExpandedData(0, index)).getDepth();
    }

    private void _shrinkTable(int removeFrom, int numberOfRows) {
        if (numberOfRows == 0) {
            return;
        }
        int[] oldIndices = this._visibleToStoreTable;
        int oldRowCount = oldIndices == null ? 0 : oldIndices.length;
        int[] newIndices = new int[oldRowCount - numberOfRows];
        System.arraycopy(oldIndices, 0, newIndices, 0, removeFrom);
        System.arraycopy(oldIndices, removeFrom + numberOfRows, newIndices, removeFrom, oldRowCount - numberOfRows - removeFrom);
        this._visibleToStoreTable = newIndices;
    }

    private void _expandTable(int insertAt, int numberOfRows) {
        int[] oldIndices = this._visibleToStoreTable;
        int oldRowCount = oldIndices == null ? 0 : oldIndices.length;
        int[] newIndices = new int[oldRowCount + numberOfRows];
        if (insertAt > 0) {
            System.arraycopy(oldIndices, 0, newIndices, 0, insertAt);
        }
        if (oldRowCount > insertAt) {
            System.arraycopy(oldIndices, insertAt, newIndices, insertAt + numberOfRows, oldRowCount - insertAt);
        }
        this._visibleToStoreTable = newIndices;
    }

    private int _findNewVisibleIndex(int storeIndex) {
        int[] indices = this._visibleToStoreTable;
        if (indices == null) {
            return 0;
        }
        int arraySize = indices.length;
        for (int i = 0; i < arraySize; ++i) {
            if (storeIndex > indices[i]) continue;
            return i;
        }
        return arraySize;
    }

    private int _getVisibleDescendantCount(int rowIndex) {
        Data hData;
        if (!this._getRowHData(rowIndex).isExpanded()) {
            return 0;
        }
        int depth = this._getRowDepth(rowIndex);
        int rowCount = this.getExpandedRowCount();
        int descendantCount = 0;
        while (++rowIndex < rowCount && (hData = this._getRowHData(rowIndex)).getDepth() > depth) {
            ++descendantCount;
            if (!hData._hasChildren || hData.isExpanded()) continue;
            rowIndex += this.getDescendantCount(rowIndex);
        }
        return descendantCount;
    }

    private final class Data
    implements HDataObject {
        Object _data;
        boolean _expanded;
        boolean _hasChildren;
        boolean _claimHasChildren;
        int _parentRow;
        private int _depth;

        public Data(int depth, int parentRow) {
            this._depth = depth;
            this._parentRow = parentRow;
        }

        public Object getData() {
            return this._data;
        }

        public int getDepth() {
            return this._depth;
        }

        public boolean isExpanded() {
            return this._expanded;
        }

        public boolean hasChildren() {
            return this._hasChildren || this._claimHasChildren;
        }

        public int getParentRow() {
            return this._parentRow;
        }
    }
}

