/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.hGrid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleState;
import javax.swing.Icon;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;

public abstract class AbstractCellHandler
extends ProxyInputHandler
implements Painter {
    private Context _contextProxy;
    private int _indentWidth;
    private Painter _painter;
    private Icon _expandedIcon;
    private Icon _collapsedIcon;
    private boolean _consumeMouseEvents;
    private boolean _expandedIconDefaulted;
    private boolean _collapsedIconDefaulted;
    private static final int _DEFAULT_INDENT_WIDTH = 18;
    private static final int _BUTTON_MARGIN = 2;
    private static final int _DEFAULT_BUTTON_SIZE = 11;

    protected AbstractCellHandler() {
        this((Painter)UIManager.get("Grid.DefaultCellPainter"));
    }

    protected AbstractCellHandler(Painter painter) {
        this(painter, NullInputHandler.getCellInputHandler());
    }

    protected AbstractCellHandler(CellInputHandler input) {
        this((Painter)UIManager.get("Grid.DefaultCellPainter"), input);
    }

    protected AbstractCellHandler(Painter painter, CellInputHandler input) {
        super(input);
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        this._painter = painter;
        this._indentWidth = 18;
        this._contextProxy = new Context();
    }

    public Painter getPainter() {
        return this._painter;
    }

    public void updateUI() {
        if (this._expandedIconDefaulted) {
            this._expandedIcon = null;
        }
        if (this._collapsedIconDefaulted) {
            this._collapsedIcon = null;
        }
    }

    public void setIndentWidth(int indentWidth) {
        this._indentWidth = indentWidth;
    }

    public int getIndentWidth() {
        return this._indentWidth;
    }

    public Icon getExpandedIcon() {
        return this._expandedIcon;
    }

    public void setExpandedIcon(Icon expandedIcon) {
        this._expandedIcon = expandedIcon;
        this._expandedIconDefaulted = false;
    }

    public Icon getCollapsedIcon() {
        return this._collapsedIcon;
    }

    public void setCollapsedIcon(Icon collapsedIcon) {
        this._collapsedIcon = collapsedIcon;
        this._collapsedIconDefaulted = false;
    }

    public void mousePressed(MouseEvent event, Grid grid, int columnIndex, int rowIndex) {
        if (!event.isConsumed()) {
            this.processButtonMousePressed(event, grid, columnIndex, rowIndex);
        }
        if (!event.isConsumed()) {
            super.mousePressed(event, grid, columnIndex, rowIndex);
        } else {
            this._consumeMouseEvents = true;
        }
    }

    public void mouseDragged(MouseEvent event, Grid grid, int columnIndex, int rowIndex) {
        if (this._consumeMouseEvents) {
            event.consume();
        } else {
            super.mouseDragged(event, grid, columnIndex, rowIndex);
        }
    }

    public void mouseReleased(MouseEvent event, Grid grid, int columnIndex, int rowIndex) {
        if (this._consumeMouseEvents) {
            event.consume();
            this._consumeMouseEvents = false;
        } else {
            super.mouseReleased(event, grid, columnIndex, rowIndex);
        }
    }

    public void keyPressed(KeyEvent event, Grid grid, int columnIndex, int rowIndex) {
        super.keyPressed(event, grid, columnIndex, rowIndex);
        if (event.isConsumed()) {
            return;
        }
        int code = event.getKeyCode();
        if (code == 37 || code == 39) {
            boolean doExpand = code == 39;
            boolean consumed = this.setCellExpansionState(grid.getModel(), columnIndex, rowIndex, doExpand);
            Grid.AccessibleGrid ag = grid.getAccessibleGrid();
            if (ag != null) {
                AccessibleState newValue;
                AccessibleState oldValue;
                if (doExpand) {
                    oldValue = AccessibleState.COLLAPSED;
                    newValue = AccessibleState.EXPANDED;
                } else {
                    oldValue = AccessibleState.EXPANDED;
                    newValue = AccessibleState.COLLAPSED;
                }
                int index = ag.getAccessibleIndexAt(columnIndex, rowIndex);
                Accessible a = ag.getAccessibleChild(index);
                ag.firePropertyChange("AccessibleState", oldValue, newValue);
                a.getAccessibleContext().firePropertyChange("AccessibleState", oldValue, newValue);
            }
            if (consumed) {
                event.consume();
            }
        }
    }

    public Rectangle getEditControlBounds(Grid grid, int columnIndex, int rowIndex) {
        Rectangle bounds = super.getEditControlBounds(grid, columnIndex, rowIndex);
        int indent = this._getIndentAt(grid, columnIndex, rowIndex);
        if (indent != 0) {
            if (bounds == null) {
                int rowHeight = grid.getRowHeight(rowIndex);
                int columnWidth = grid.getColumnWidth(columnIndex);
                bounds = new Rectangle(0, 0, columnWidth, rowHeight);
            }
            bounds.x += indent;
            bounds.width -= indent;
        }
        return bounds;
    }

    public Object getWrappedData(Object sourceData) {
        return sourceData;
    }

    public void startEdit(Grid grid, int columnIndex, int rowIndex, Object data) {
        super.startEdit(grid, columnIndex, rowIndex, this.getWrappedData(data));
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        return new Dimension(availableWidth, availableHeight);
    }

    public Dimension getPreferredSize(PaintContext context) {
        Context proxy = this._contextProxy;
        proxy.setPaintContext(context);
        return this._addIndentDepth(this._painter.getPreferredSize(proxy), context);
    }

    public Dimension getMinimumSize(PaintContext context) {
        Context proxy = this._contextProxy;
        proxy.setPaintContext(context);
        return this._addIndentDepth(this._painter.getMinimumSize(proxy), context);
    }

    public Dimension getMaximumSize(PaintContext context) {
        Context proxy = this._contextProxy;
        proxy.setPaintContext(context);
        return this._addIndentDepth(this._painter.getMaximumSize(proxy), context);
    }

    protected boolean isBackgroundUsed() {
        return true;
    }

    private Dimension _addIndentDepth(Dimension d, PaintContext context) {
        TwoDModel dataSource = (TwoDModel)context.getPaintData("Model");
        Cell cell = (Cell)context.getPaintData("Cell");
        int indentDepth = this.getCellDepth(dataSource, cell.column, cell.row);
        int indent = this._getIndentAtDepth(context, indentDepth);
        d.width += indent;
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        TwoDModel model = (TwoDModel)context.getPaintData("Model");
        Cell cell = (Cell)context.getPaintData("Cell");
        int indentDepth = this.getCellDepth(model, cell.column, cell.row);
        boolean hasChildren = this.cellHasChildren(model, cell.column, cell.row);
        Object data = this.getWrappedData(context.getPaintData(null));
        Context contextProxy = this._contextProxy;
        int indent = this._getIndentAtDepth(context, indentDepth);
        x += indent;
        width -= indent;
        Appearance appearance = null;
        Color saved = g.getColor();
        int state = context.getPaintState();
        if ((state & 1) == 0 && (state & 0x20) != 0 && this.isBackgroundUsed() && (appearance = (Appearance)context.getPaintData("Appearance")) != null) {
            ImmInsets insets = appearance.getInsets();
            g.setColor(appearance.getBackground());
            g.fillRect(x - indent - insets.left, y - insets.top, indent + insets.left, height + insets.top + insets.bottom);
            g.setColor(saved);
        }
        if (hasChildren) {
            Icon buttonIcon;
            Icon icon = buttonIcon = this.isCellExpanded(model, cell.column, cell.row) ? this._getExpandedIcon(context) : this._getCollapsedIcon(context);
            if (buttonIcon != null) {
                int buttonX = x - 2 - buttonIcon.getIconWidth();
                int buttonY = y + (height - buttonIcon.getIconHeight()) / 2;
                buttonIcon.paintIcon(context.getComponent(), g, buttonX, buttonY);
                g.setColor(saved);
            }
        }
        Context context2 = contextProxy;
        synchronized (context2) {
            contextProxy.setPaintContext(context);
            this._painter.paint(contextProxy, g, x, y, width, height);
        }
    }

    public final boolean contains(PaintContext context, int availableWidth, int availableHeight, int x, int y) {
        return this.getPainterAt(context, availableWidth, availableHeight, x, y, null) != null;
    }

    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        if (x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            return this;
        }
        return null;
    }

    public boolean isTransparent(PaintContext context) {
        return true;
    }

    public int getRepaintFlags(PaintContext context) {
        return this._painter.getRepaintFlags(context);
    }

    public int getInvalidateFlags(PaintContext context) {
        return this._painter.getInvalidateFlags(context);
    }

    protected abstract boolean setCellExpansionState(TwoDModel var1, int var2, int var3, boolean var4);

    protected abstract boolean cellHasChildren(TwoDModel var1, int var2, int var3);

    protected abstract int getCellDepth(TwoDModel var1, int var2, int var3);

    protected abstract boolean isCellExpanded(TwoDModel var1, int var2, int var3);

    protected void processButtonMousePressed(MouseEvent event, Grid grid, int columnIndex, int rowIndex) {
        TwoDModel model = grid.getModel();
        if (this.cellHasChildren(model, columnIndex, rowIndex)) {
            int depth;
            int buttonX;
            int rowHeight = grid.getRowHeight(rowIndex);
            int columnWidth = grid.getColumnWidth(columnIndex);
            int mouseX = event.getX();
            if (mouseX <= (buttonX = this._getButtonX(depth = this.getCellDepth(model, columnIndex, rowIndex))) + this._getButtonWidth(grid.getPaintContext())) {
                event.consume();
                boolean isExpanded = this.isCellExpanded(model, columnIndex, rowIndex);
                this.setCellExpansionState(model, columnIndex, rowIndex, !isExpanded);
            }
        }
    }

    protected void translateMouseEvent(MouseEvent event, Grid grid, int columnIndex, int rowIndex, boolean toWrapped) {
        int indent = this._getIndentAt(grid, columnIndex, rowIndex);
        if (toWrapped) {
            indent = -indent;
        }
        event.translatePoint(indent, 0);
    }

    private int _getButtonWidth(PaintContext context) {
        return this._getExpandedIcon(context).getIconWidth();
    }

    private int _getIndentAt(Grid grid, int columnIndex, int rowIndex) {
        return this._getIndentAtDepth(grid.getPaintContext(), this.getCellDepth(grid.getModel(), columnIndex, rowIndex));
    }

    private int _getIndentAtDepth(PaintContext context, int depth) {
        return this._getButtonX(depth) + this._getButtonWidth(context) + 2;
    }

    private int _getButtonX(int depth) {
        return depth * this.getIndentWidth() + 2;
    }

    private Icon _getExpandedIcon(PaintContext context) {
        Icon icon = this.getExpandedIcon();
        if (icon == null) {
            this._expandedIcon = icon = context.getPaintUIDefaults().getIcon("Tree.expandedIcon");
            this._expandedIconDefaulted = true;
        }
        return icon;
    }

    private Icon _getCollapsedIcon(PaintContext context) {
        Icon icon = this.getCollapsedIcon();
        if (icon == null) {
            icon = context.getPaintUIDefaults().getIcon("Tree.collapsedIcon");
            this._collapsedIconDefaulted = true;
            this._collapsedIcon = icon;
        }
        return icon;
    }

    private class Context
    extends PaintContextProxy {
        private PaintContext _context;

        private Context() {
        }

        public void setPaintContext(PaintContext context) {
            this._context = context;
        }

        protected PaintContext getPaintContext() {
            return this._context;
        }

        public Object getPaintData(Object key) {
            return AbstractCellHandler.this.getWrappedData(super.getPaintData(key));
        }
    }
}

