/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.grid.bigCell.BigCell;
import oracle.bali.ewt.model.AbstractTwoDModel;

public class BigCellTwoDModel
extends AbstractTwoDModel {
    private int _columns;
    private int _rows;
    private Object[][] _data;
    private static int _COLUMNS_ALLOCATED_AHEAD = 20;

    public BigCellTwoDModel(int columns, int rows) {
        this._columns = columns;
        this._rows = rows;
    }

    public int getColumnCount() {
        return this._columns;
    }

    public int getRowCount() {
        return this._rows;
    }

    public Object getData(int columnIndex, int rowIndex) {
        if (this._data == null) {
            return null;
        }
        return this._data[columnIndex][rowIndex];
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        if (this._data == null) {
            this._data = new Object[this.getColumnCount()][this.getRowCount()];
        }
        if (!(data instanceof AbstractBigCell) && data != this._getAbstractBigCell(columnIndex, rowIndex)) {
            this._clearCell(columnIndex, rowIndex);
        }
        this._data[columnIndex][rowIndex] = data;
        this.fireModelEvent(2007, columnIndex, 1, rowIndex, 1);
    }

    public Object getRealData(int column, int row) {
        AbstractBigCell cell = this._getAbstractBigCell(column, row);
        return cell == null ? this.getData(column, row) : cell.getData();
    }

    public void setBigCellData(int column, int columnCount, int row, int rowCount, Object data) {
        BigCell cell = new BigCell(column, columnCount, row, rowCount, data);
        this.storeCell(column, columnCount, row, rowCount, cell);
    }

    public void addColumns(int startIndex, int numberOfColumns) {
        this._addColumnsToArray(startIndex, numberOfColumns);
        this._columns += numberOfColumns;
        this.fireModelEvent(2001, startIndex, numberOfColumns);
        this._adjustAfterAddColumns(startIndex, numberOfColumns);
    }

    public final void addColumns(int numberOfColumns) {
        this.addColumns(this.getColumnCount(), numberOfColumns);
    }

    public void removeColumns(int startIndex, int numberOfColumns) {
        this._removeColumnsFromArray(startIndex, numberOfColumns);
        this._columns -= numberOfColumns;
        this.fireModelEvent(2002, startIndex, numberOfColumns);
        this._adjustAfterRemoveColumns(startIndex, numberOfColumns);
    }

    public final void removeColumns(int numberOfColumns) {
        this.removeColumns(this.getColumnCount() - numberOfColumns, numberOfColumns);
    }

    public void addRows(int startIndex, int numberOfRows) {
        this._addRowsToArray(startIndex, numberOfRows);
        this._rows += numberOfRows;
        this.fireModelEvent(2004, startIndex, numberOfRows);
        this._adjustAfterAddRows(startIndex, numberOfRows);
    }

    public final void addRows(int numberOfRows) {
        this.addRows(this.getRowCount(), numberOfRows);
    }

    public void removeRows(int startIndex, int numberOfRows) {
        this._removeRowsFromArray(startIndex, numberOfRows);
        this._rows -= numberOfRows;
        this.fireModelEvent(2005, startIndex, numberOfRows);
        this._adjustAfterRemoveRows(startIndex, numberOfRows);
    }

    public final void removeRows(int numberOfRows) {
        this.removeRows(this.getRowCount() - numberOfRows, numberOfRows);
    }

    protected void storeCell(int column, int columnCount, int row, int rowCount, Object data) {
        if (this._data == null) {
            this._data = new Object[this._columns][this._rows];
        }
        for (int i = 0; i < columnCount; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                this._clearCell(i + column, j + row);
                this._data[i + column][j + row] = data;
            }
        }
        this._data[column][row] = data;
        this.fireModelEvent(2007, column, columnCount, row, rowCount);
    }

    private void _clearCell(int column, int row) {
        AbstractBigCell bigCell = this._getAbstractBigCell(column, row);
        if (bigCell == null) {
            return;
        }
        int columns = bigCell.getColumnCount();
        int rows = bigCell.getRowCount();
        int startColumn = bigCell.getColumn();
        int startRow = bigCell.getRow();
        for (int i = 0; i < columns; ++i) {
            for (int j = 0; j < rows; ++j) {
                this._data[i + startColumn][j + startRow] = null;
            }
        }
        this.fireModelEvent(2007, startColumn, columns, startRow, rows);
    }

    private AbstractBigCell _getAbstractBigCell(int column, int row) {
        Object data = this.getData(column, row);
        AbstractBigCell bigCell = null;
        if (data instanceof AbstractBigCell) {
            bigCell = (AbstractBigCell)data;
        }
        return bigCell;
    }

    private BigCell _getBigCell(int column, int row) {
        AbstractBigCell temp = this._getAbstractBigCell(column, row);
        BigCell bigCell = null;
        if (temp instanceof BigCell) {
            bigCell = (BigCell)temp;
        }
        return bigCell;
    }

    private void _adjustAfterAddColumns(int startIndex, int numberOfColumns) {
        for (int j = 0; j < this._rows; ++j) {
            int i = startIndex + numberOfColumns;
            while (i < this._columns) {
                BigCell cell = this._getBigCell(i, j);
                if (cell == null) {
                    ++i;
                    continue;
                }
                if (cell.getRow() != j) {
                    i = cell.getColumn() + cell.getColumnCount();
                    continue;
                }
                if (cell.getColumn() < startIndex) {
                    cell.setColumnCount(cell.getColumnCount() + numberOfColumns);
                    for (int jj = 0; jj < cell.getRowCount(); ++jj) {
                        for (int ii = 0; ii < numberOfColumns; ++ii) {
                            this._data[startIndex + ii][j + jj] = cell;
                        }
                    }
                    i = cell.getColumn() + cell.getColumnCount();
                    continue;
                }
                cell.setColumn(i);
                i += cell.getColumnCount();
            }
        }
    }

    private void _adjustAfterRemoveColumns(int startIndex, int numberOfColumns) {
        for (int j = 0; j < this._rows; ++j) {
            BigCell cell;
            int i = 0;
            if (startIndex > 0) {
                i = startIndex - 1;
                cell = this._getBigCell(i, j);
                if (cell == null) {
                    ++i;
                } else if (cell.getRow() != j) {
                    i = Math.max(i + 1, cell.getColumn() + cell.getColumnCount());
                } else if (cell.getColumn() + cell.getColumnCount() > startIndex) {
                    if (cell.getColumn() + cell.getColumnCount() < startIndex + numberOfColumns) {
                        cell.setColumnCount(startIndex - cell.getColumn());
                        ++i;
                    } else {
                        cell.setColumnCount(cell.getColumnCount() - numberOfColumns);
                        i = Math.max(i + 1, cell.getColumn() + cell.getColumnCount());
                    }
                } else {
                    ++i;
                }
            }
            while (i < this._columns) {
                cell = this._getBigCell(i, j);
                if (cell == null) {
                    ++i;
                    continue;
                }
                if (cell.getRow() != j) {
                    i = Math.max(i + 1, cell.getColumn() + cell.getColumnCount());
                    continue;
                }
                if (cell.getColumn() - numberOfColumns < startIndex) {
                    cell.setColumn(startIndex);
                    int trunkValue = startIndex + numberOfColumns - cell.getColumn();
                    cell.setColumnCount(cell.getColumnCount() - trunkValue);
                    i = Math.max(i + 1, cell.getColumn() + cell.getColumnCount());
                    continue;
                }
                cell.setColumn(cell.getColumn() - numberOfColumns);
                i += cell.getColumnCount();
            }
        }
    }

    private void _addColumnsToArray(int start, int number) {
        Object[][] dst;
        Object[][] src = this._data;
        if (src == null) {
            return;
        }
        int length = this._columns;
        if (src.length >= length + number) {
            dst = src;
        } else {
            dst = new Object[length + number + _COLUMNS_ALLOCATED_AHEAD][this._rows];
            System.arraycopy(src, 0, dst, 0, start);
            this._data = dst;
        }
        System.arraycopy(src, start, dst, start + number, length - start);
        if (dst == src) {
            int columnIndex = start;
            for (int i = 0; i < number; ++i) {
                src[columnIndex++] = new Object[this._rows];
            }
        }
    }

    private void _removeColumnsFromArray(int start, int number) {
        Object[][] dst;
        Object[][] src = this._data;
        if (src == null) {
            return;
        }
        int length = this._columns;
        if (length - number + _COLUMNS_ALLOCATED_AHEAD < src.length / 2) {
            dst = new Object[length - number + _COLUMNS_ALLOCATED_AHEAD][this._rows];
            System.arraycopy(src, 0, dst, 0, start);
            this._data = dst;
        } else {
            dst = src;
        }
        System.arraycopy(src, start + number, dst, start, length - start - number);
        if (dst == src) {
            int columnIndex = length;
            for (int i = 0; i < number; ++i) {
                src[--columnIndex] = new Object[this._rows];
            }
        }
    }

    private void _adjustAfterAddRows(int startIndex, int numberOfRows) {
        for (int i = 0; i < this._columns; ++i) {
            int j = startIndex + numberOfRows;
            while (j < this._rows) {
                BigCell cell = this._getBigCell(i, j);
                if (cell == null) {
                    ++j;
                    continue;
                }
                if (cell.getColumn() != i) {
                    j = cell.getRow() + cell.getRowCount();
                    continue;
                }
                if (cell.getRow() < startIndex) {
                    cell.setRowCount(cell.getRowCount() + numberOfRows);
                    for (int ii = 0; ii < cell.getColumnCount(); ++ii) {
                        for (int jj = 0; jj < numberOfRows; ++jj) {
                            this._data[i + ii][startIndex + jj] = cell;
                        }
                    }
                    j = cell.getRow() + cell.getRowCount();
                    continue;
                }
                cell.setRow(j);
                j += cell.getRowCount();
            }
        }
    }

    private void _adjustAfterRemoveRows(int startIndex, int numberOfRows) {
        for (int j = 0; j < this._columns; ++j) {
            BigCell cell;
            int i = 0;
            if (startIndex > 0) {
                i = startIndex - 1;
                cell = this._getBigCell(j, i);
                if (cell == null) {
                    ++i;
                } else if (cell.getColumn() != j) {
                    i = Math.max(i + 1, cell.getRow() + cell.getRowCount());
                } else if (cell.getRow() + cell.getRowCount() > startIndex) {
                    if (cell.getRow() + cell.getRowCount() < startIndex + numberOfRows) {
                        cell.setRowCount(startIndex - cell.getRow());
                        ++i;
                    } else {
                        cell.setRowCount(cell.getRowCount() - numberOfRows);
                        i = Math.max(i + 1, cell.getRow() + cell.getRowCount());
                    }
                } else {
                    ++i;
                }
            }
            while (i < this._rows) {
                cell = this._getBigCell(j, i);
                if (cell == null) {
                    ++i;
                    continue;
                }
                if (cell.getColumn() != j) {
                    i = Math.max(i + 1, cell.getRow() + cell.getRowCount());
                    continue;
                }
                if (cell.getRow() - numberOfRows < startIndex) {
                    cell.setRow(startIndex);
                    int trunkValue = startIndex + numberOfRows - cell.getRow();
                    cell.setRowCount(cell.getRowCount() - trunkValue);
                    i = Math.max(i + 1, cell.getRow() + cell.getRowCount());
                    continue;
                }
                cell.setRow(cell.getRow() - numberOfRows);
                i += cell.getRowCount();
            }
        }
    }

    private void _addRowsToArray(int start, int number) {
        Object[][] src = this._data;
        if (src == null) {
            return;
        }
        int length = this._rows;
        int newLength = length + number;
        int secondStart = start + number;
        int secondLength = length - start;
        for (int i = 0; i < this._columns; ++i) {
            Object[] srcCol = src[i];
            if (srcCol == null) continue;
            Object[] dstCol = new Object[newLength];
            System.arraycopy(srcCol, 0, dstCol, 0, start);
            System.arraycopy(srcCol, start, dstCol, secondStart, secondLength);
            src[i] = dstCol;
        }
    }

    private void _removeRowsFromArray(int start, int number) {
        Object[][] src = this._data;
        if (src == null) {
            return;
        }
        int length = this._rows;
        int newLength = length - number;
        int secondStart = start + number;
        int secondLength = length - start - number;
        for (int i = 0; i < this._columns; ++i) {
            Object[] srcCol = src[i];
            if (srcCol == null) continue;
            Object[] dstCol = new Object[newLength];
            System.arraycopy(srcCol, 0, dstCol, 0, start);
            System.arraycopy(srcCol, secondStart, dstCol, start, secondLength);
            src[i] = dstCol;
        }
    }
}

