/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;

public class DateInputHandler
extends CellInputHandler {
    private DateEditor _DateEditor;
    static boolean _dirty;
    private DateFormat _format;

    public DateInputHandler(DateFormat d) {
        this._format = d;
    }

    public void setDateFormat(DateFormat d) {
        this._format = d;
    }

    public DateFormat getDateFormat() {
        return this._format;
    }

    public void updateUI() {
        if (this._DateEditor != null) {
            SwingUtilities.updateComponentTreeUI(this._DateEditor);
            this._DateEditor.setBorder(null);
        }
    }

    public void focusGained(AWTEvent why, Grid grid, int column, int row) {
        if (why instanceof MouseEvent) {
            grid.startCellEdit(column, row);
        }
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        super.mousePressed(e, grid, column, row);
        Cell focusCell = grid.getFocusCell();
        if (focusCell != null && focusCell.column == column && focusCell.row == row && SwingUtilities.isLeftMouseButton(e)) {
            grid.startCellEdit(column, row);
        }
    }

    public synchronized Component getEditControl(Grid grid, int column, int row) {
        if (this._DateEditor == null) {
            this._DateEditor = new DateEditor();
            this._DateEditor.addPropertyChangeListener(new Dirty());
            this._DateEditor.setBorder(null);
        }
        return this._DateEditor;
    }

    public boolean isDirty(Grid grid, int column, int row) {
        return _dirty;
    }

    public void startEdit(Grid grid, int column, int row, Object data) {
        DateEditor dateEditor = (DateEditor)this.getEditControl(grid, column, row);
        dateEditor.setCalendar(this.getDateFormat().getCalendar());
        if (data == null || data instanceof Date) {
            dateEditor.setDate((Date)data);
        } else {
            String s = data.toString();
            try {
                dateEditor.setDateString(s);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("data " + data + " must be a Date");
            }
        }
        dateEditor.setDateFormat(this.getDateFormat());
        _dirty = false;
    }

    public synchronized Object commitEdit(Grid grid, int column, int row) {
        DateEditor edit = (DateEditor)this.getEditControl(grid, column, row);
        Date data = edit.getDate();
        return data;
    }

    private static class Dirty
    implements PropertyChangeListener {
        private Dirty() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("date".equals(e.getPropertyName())) {
                _dirty = true;
            }
        }
    }
}

