/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;

public class GraphicsProxy
extends Graphics {
    private Hashtable _hash;
    private Graphics _graphics;

    public GraphicsProxy(Graphics graphics) {
        this._graphics = graphics;
    }

    public Graphics getGraphics() {
        return this._graphics;
    }

    public synchronized Object put(Object key, Object value) {
        if (this._hash == null) {
            this._hash = new Hashtable();
        }
        return this._hash.put(key, value);
    }

    public synchronized Object get(Object key) {
        Object data = null;
        if (this._hash != null) {
            data = this._hash.get(key);
        }
        return data;
    }

    public Graphics create() {
        return new GraphicsProxy(this.getGraphics().create());
    }

    public void translate(int x, int y) {
        this.getGraphics().translate(x, y);
    }

    public Color getColor() {
        return this.getGraphics().getColor();
    }

    public void setColor(Color newColor) {
        this.getGraphics().setColor(newColor);
    }

    public void setPaintMode() {
        this.getGraphics().setPaintMode();
    }

    public void setXORMode(Color xorColor) {
        this.getGraphics().setXORMode(xorColor);
    }

    public Font getFont() {
        return this.getGraphics().getFont();
    }

    public void setFont(Font newFont) {
        this.getGraphics().setFont(newFont);
    }

    public FontMetrics getFontMetrics(Font measuredFont) {
        return this.getGraphics().getFontMetrics(measuredFont);
    }

    public Rectangle getClipBounds() {
        return this.getGraphics().getClipBounds();
    }

    public void clipRect(int x, int y, int width, int height) {
        this.getGraphics().clipRect(x, y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.getGraphics().setClip(x, y, width, height);
    }

    public Shape getClip() {
        return this.getGraphics().getClip();
    }

    public void setClip(Shape clip) {
        this.getGraphics().setClip(clip);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.getGraphics().copyArea(x, y, width, height, dx, dy);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.getGraphics().drawLine(x1, y1, x2, y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.getGraphics().fillRect(x, y, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.getGraphics().clearRect(x, y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.getGraphics().drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.getGraphics().fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.getGraphics().drawOval(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.getGraphics().drawOval(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.getGraphics().drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.getGraphics().fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.getGraphics().drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.getGraphics().drawPolygon(xPoints, yPoints, nPoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.getGraphics().fillPolygon(xPoints, yPoints, nPoints);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.getGraphics().drawString(iterator, x, y);
    }

    public void drawString(String str, int x, int y) {
        this.getGraphics().drawString(str, x, y);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.getGraphics().drawImage(img, x, y, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.getGraphics().drawImage(img, x, y, width, height, observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.getGraphics().drawImage(img, x, y, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.getGraphics().drawImage(img, x, y, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.getGraphics().drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.getGraphics().drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public void dispose() {
        this.getGraphics().dispose();
    }

    public void finalize() {
    }
}

