/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageFilter;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.graphics.ImageUtils;

public class WindowsUIUtils {
    public static Image getImage(String name) {
        return ImageUtils.getImageResource(WindowsUIUtils.class, "icons/" + name);
    }

    public static Image getColorizedImage(UIDefaults defaults, String name) {
        Image image = ImageUtils.createFilteredImage(WindowsUIUtils.getImage(name), (ImageFilter)defaults.get("EWTColorizingFilter"));
        ImageUtils.loadImage(image);
        return image;
    }

    public static Object imageInst(UIDefaults defaults, Object key, String discriminant) {
        return WindowsUIUtils.getImage(discriminant);
    }

    public static Object cImageInst(UIDefaults defaults, Object key, String discriminant) {
        return WindowsUIUtils.getColorizedImage(defaults, discriminant);
    }

    public static void drawFocusRectOnTreeCell(Graphics g, int x, int y, int width, int height) {
        WindowsUIUtils.drawSolidRect(g, x, y, width, height);
    }

    public static void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        WindowsUIUtils.drawDottedRect(g, x, y, width, height);
    }

    static void drawDottedRect(Graphics g, int x, int y, int width, int height) {
        int x2 = x + width;
        int y2 = y + height;
        GraphicUtils.drawDottedLine(g, x, y, x2, y);
        GraphicUtils.drawDottedLine(g, x2, y, x2, y2);
        GraphicUtils.drawDottedLine(g, x, y2, x2, y2);
        GraphicUtils.drawDottedLine(g, x, y, x, y2);
    }

    static void drawSolidRect(Graphics g, int x, int y, int width, int height) {
        int x2 = x + width;
        int y2 = y + height;
        Color savedColor = g.getColor();
        g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
        GraphicUtils.drawLine(g, x, y, x2, y, 1);
        GraphicUtils.drawLine(g, x2, y, x2, y2, 1);
        GraphicUtils.drawLine(g, x, y2, x2, y2, 1);
        GraphicUtils.drawLine(g, x, y, x, y2, 1);
        g.setColor(savedColor);
    }
}

