/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotTable;

class WindowsPivotHeaderSeparator
extends AbstractPainter
implements UIResource {
    private boolean _horizontal;
    private static Painter _sHorizontal;
    private static Painter _sVertical;
    private static final Dimension _sMIN_SIZE;

    public static Painter getHorizontalSeparator() {
        if (_sHorizontal == null) {
            _sHorizontal = new WindowsPivotHeaderSeparator(true);
        }
        return _sHorizontal;
    }

    public static Painter getVerticalSeparator() {
        if (_sVertical == null) {
            _sVertical = new WindowsPivotHeaderSeparator(false);
        }
        return _sVertical;
    }

    public Dimension getMinimumSize(PaintContext context) {
        return _sMIN_SIZE;
    }

    public int getRepaintFlags(PaintContext context) {
        return 1;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean enabled;
        boolean raised;
        Object data = context.getPaintData(PivotTable.KEY_DRAW_RAISED);
        boolean bl = raised = data instanceof Boolean ? (Boolean)data : true;
        if (!raised) {
            return;
        }
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color color = Color.black;
        g.setColor(color);
        int state = context.getPaintState();
        boolean bl2 = enabled = (state & 1) == 0;
        if (this._horizontal) {
            this._paintHorizontal(context, g, x, y, width, height, enabled);
        } else {
            this._paintVertical(context, g, x, y, width, height, enabled);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintHorizontal(PaintContext context, Graphics g, int x, int y, int width, int height, boolean enabled) {
        int right = x + width - 1;
        if (enabled) {
            g.drawLine(x, y, right, y);
        } else {
            for (int i = x; i <= right; i += 2) {
                g.drawLine(i, y, i, y);
            }
        }
    }

    private void _paintVertical(PaintContext context, Graphics g, int x, int y, int width, int height, boolean enabled) {
        int bottom = y + height - 1;
        if (enabled) {
            g.drawLine(x, y, x, bottom);
        } else {
            for (int i = y; i <= bottom; i += 2) {
                g.drawLine(x, i, x, i);
            }
        }
    }

    private WindowsPivotHeaderSeparator(boolean horizontal) {
        this._horizontal = horizontal;
    }

    static {
        _sMIN_SIZE = new Dimension(1, 1);
    }
}

