/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

class WindowsHeaderItemPainter
extends AbstractBorderPainter
implements UIResource {
    private static final ImmInsets _INSETS = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets[] _FILL_INSETS = new ImmInsets[]{new ImmInsets(1, 1, 1, 1), new ImmInsets(2, 2, 2, 2)};
    private Object _key;
    private boolean _horizontal;

    public WindowsHeaderItemPainter() {
        this(Header.KEY_DRAW_RAISED, true);
    }

    public WindowsHeaderItemPainter(boolean horizontal) {
        this(Header.KEY_DRAW_RAISED, horizontal);
    }

    public WindowsHeaderItemPainter(Object key, boolean horizontal) {
        this._key = key;
        this._horizontal = horizontal;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return _INSETS;
    }

    protected ImmInsets getOwnFillInsets(PaintContext context) {
        int state = context.getPaintState();
        int fillIndex = 0;
        if ((state & 2) == 0) {
            ++fillIndex;
        }
        return _FILL_INSETS[fillIndex];
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean armed;
        Object value;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        Object data = context.getPaintData(this._key);
        boolean raised = data instanceof Boolean ? (Boolean)data : true;
        Color background = context.getPaintBackground();
        g.setColor(background);
        g.fillRect(x, y, --width, --height);
        int bottom = y + height;
        int right = x + width;
        Color darkShadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
        Color borderColor = null;
        if ((state & 1) == 0 && (value = context.getPaintData("headerItemBorderColor")) instanceof Color) {
            borderColor = (Color)value;
        }
        if (borderColor == null) {
            borderColor = raised || this.isPaintingPivotGridHeader() ? defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW) : darkShadow;
        }
        boolean bl = armed = (state & 2) != 0;
        if (raised && armed) {
            g.setColor(darkShadow);
            g.drawRect(x, y, width, height);
        } else if (!raised) {
            g.setColor(borderColor);
            g.drawLine(right, y, right, bottom);
            g.drawLine(x, bottom, right, bottom);
            if (!this.isPaintingPivotGridHeader()) {
                if (this._horizontal) {
                    g.drawLine(x, y, right, y);
                } else {
                    g.drawLine(x, y, x, bottom);
                }
            }
        } else {
            Color lightHighLight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            Color highlight = defaults.getColor(LookAndFeel.CONTROL_HIGHLIGHT);
            g.setColor(borderColor);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right, y, right, bottom);
            g.setColor(lightHighLight);
            g.drawLine(x, y, x, --bottom);
            g.drawLine(x, y, --right, y);
            g.setColor(darkShadow);
            g.drawLine(++x, bottom, right, bottom);
            g.drawLine(right, ++y, right, bottom);
            g.setColor(highlight);
            g.drawLine(x, y, x, --bottom);
            g.drawLine(x, y, --right, y);
        }
        g.setColor(savedColor);
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return false;
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 1 | 4 | 2 | 0x40 | 0x400 | 0x80;
    }

    protected boolean isPaintingPivotGridHeader() {
        return false;
    }
}

