/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.basic.BasicEWTSpinButtonUI;
import oracle.bali.ewt.graphics.ImageSetIcon;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.graphics.ImageUtils;

public class WindowsEWTSpinButtonUI
extends BasicEWTSpinButtonUI {
    private static Insets _sMargin = new Insets(0, 0, 0, 0);
    private static final Icon[] _sSpinIcons = new Icon[2];

    public static ComponentUI createUI(JComponent component) {
        return new WindowsEWTSpinButtonUI();
    }

    protected AbstractButton createIncrementButton(JComponent component) {
        return this._createButton(true);
    }

    protected AbstractButton createDecrementButton(JComponent component) {
        return this._createButton(false);
    }

    private AbstractButton _createButton(boolean increment) {
        Button b = new Button();
        b.setIcon(this._getCachedIcon(increment));
        b.setBorder(UIManager.getBorder("Button.border"));
        b.setMargin(_sMargin);
        b.setDefaultCapable(false);
        return b;
    }

    private Icon _getCachedIcon(boolean increment) {
        Icon icon;
        int cacheIndex = 0;
        if (increment) {
            ++cacheIndex;
        }
        if ((icon = _sSpinIcons[cacheIndex]) == null) {
            String iconName = increment ? "icons/spinUpStrip.gif" : "icons/spinDownStrip.gif";
            WindowsEWTSpinButtonUI._sSpinIcons[cacheIndex] = icon = new ImageSetIcon(new ImageStrip(ImageUtils.getImageResource(this.getClass(), iconName), 3));
        }
        return icon;
    }

    private WindowsEWTSpinButtonUI() {
    }

    private static class Button
    extends JButton {
        private Button() {
        }

        public void requestFocus() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

