/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import oracle.bali.ewt.dnd.DnDUtils;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceContext;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;

@Deprecated
class DragTracker
extends MouseAdapter
implements MouseMotionListener,
KeyListener {
    private DragSourceContext _dragContext;
    private DropTargetContext _dropContext;
    private DropTarget _target;
    private Point _localPoint;
    private int _gestureModifiers;
    private Component _topmostParent;
    private Point _dragOverPoint;
    private boolean _dropOccurred;
    private Component _keyComponent;
    private Image _dragImage;
    private Point _offset;
    private static DragTracker _sDragTracker;

    public DragTracker(DragSourceContext dragContext, Image dragImage, Point offset) {
        this._dragContext = dragContext;
        this._dragImage = dragImage;
        if (offset != null) {
            this._offset = new Point(offset);
        }
    }

    public void init(InputEvent trigger) {
        if (trigger instanceof MouseEvent) {
            this.mouseDragged((MouseEvent)trigger);
        } else {
            this._gestureModifiers = trigger.getModifiers();
        }
        this._keyComponent = null;
        if (this._keyComponent == null) {
            this._keyComponent = this._dragContext.getComponent();
            this._keyComponent.requestFocus();
        }
        if (this._keyComponent != null) {
            this._keyComponent.addKeyListener(this);
        }
        _sDragTracker = this;
    }

    public void setDragImage(Image dragImage) {
        this._dragImage = dragImage;
    }

    public Image getDragImage() {
        return this._dragImage;
    }

    public void mouseReleased(MouseEvent e) {
        DropTarget target = this._target;
        this.eraseHighlight();
        this._topmostParent = null;
        if (target != null && target.isActive()) {
            target.drop(new DropTargetDropEvent(target.getDropTargetContext(), this._localPoint, this._getDropAction(), this._dragContext.getSourceActions(), true));
            this._dropOccurred = true;
        }
        this.terminateDrag(false);
        e.consume();
        _sDragTracker = null;
    }

    public void mousePressed(MouseEvent e) {
        this._dragContext.cancelDrag();
        e.consume();
    }

    public void mouseDragged(MouseEvent e) {
        Point local;
        this.eraseHighlight();
        Component c = (Component)e.getSource();
        this._localPoint = local = new Point(e.getX(), e.getY());
        this._updateModifiers(e);
        Component targetComp = DnDUtils.getTargetComponentOutside(c, local);
        DropTarget target = DnDUtils.getEWTDropTarget(targetComp);
        if (target != null && !target.isActive()) {
            target = null;
        }
        DropTarget oldTarget = this._target;
        DragSourceContext dragContext = this._dragContext;
        DragSource source = dragContext.getDragSource();
        if (oldTarget != target) {
            if (oldTarget != null) {
                oldTarget.dragExit(new DropTargetEvent(this._dropContext));
                dragContext.dragExit(new DragSourceEvent(dragContext));
                this._dropContext = null;
            }
            if (target != null) {
                this._dropContext = target.getDropTargetContext();
                target.dragEnter(this._createDropTargetDragEvent(local));
                target.dragOver(this._createDropTargetDragEvent(local));
                dragContext.dragEnter(this._createDragSourceDragEvent());
            }
            this._target = target;
        } else if (target != null) {
            target.dragOver(this._createDropTargetDragEvent(local));
            dragContext.dragOver(this._createDragSourceDragEvent());
        }
        this._dragOverPoint = new Point(local);
        this._topmostParent = DnDUtils.getTopmostParent(targetComp, this._dragOverPoint);
        Point offset = this._offset;
        if (offset != null) {
            this._dragOverPoint.x += offset.x;
            this._dragOverPoint.y += offset.y;
        }
        this.drawHighlight();
        e.consume();
    }

    public void eraseHighlight() {
        Component c = this._topmostParent;
        if (c == null) {
            return;
        }
        Point pt = this._dragOverPoint;
        if (pt == null) {
            return;
        }
        Image image = this._dragImage;
        if (image != null) {
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            DnDUtils.paintImmediate(c, pt.x, pt.y, width, height);
        }
    }

    public void drawHighlight() {
        Component c = this._topmostParent;
        if (c == null) {
            return;
        }
        Point pt = this._dragOverPoint;
        if (pt == null) {
            return;
        }
        Image image = this._dragImage;
        if (image != null) {
            Graphics g = c.getGraphics();
            g.drawImage(image, pt.x, pt.y, null);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this._dragContext.cancelDrag();
            e.consume();
            return;
        }
        this._updateModifiers(e);
    }

    public void keyReleased(KeyEvent e) {
        this._updateModifiers(e);
    }

    public void terminateDrag(boolean deliverEvents) {
        DragSourceContext dragContext = this._dragContext;
        this.eraseHighlight();
        if (this._dropContext != null) {
            if (deliverEvents) {
                this._target.dragExit(this._createDropTargetDragEvent(this._localPoint));
            }
            this._target = null;
            this._dropContext = null;
        }
        Component comp = dragContext.getComponent();
        comp.removeMouseListener(this);
        comp.removeMouseMotionListener(this);
        if (this._keyComponent != null) {
            this._keyComponent.removeKeyListener(this);
        }
        DragSourceDropEvent dropEvent = this._dropOccurred ? new DragSourceDropEvent(dragContext, dragContext.getDragOperation(), dragContext.getDragSucceded()) : new DragSourceDropEvent(dragContext);
        dragContext.dragDropEnd(dropEvent);
        DragSource.setCurrentDragSourceContext(null);
    }

    static void eraseFeedback() {
        DragTracker tracker = _sDragTracker;
        if (tracker != null) {
            tracker.eraseHighlight();
        }
    }

    static void drawFeedback() {
        DragTracker tracker = _sDragTracker;
        if (tracker != null) {
            tracker.drawHighlight();
        }
    }

    private DropTargetDragEvent _createDropTargetDragEvent(Point local) {
        return new DropTargetDragEvent(this._dropContext, new Point(local), this._getDropAction(), this._dragContext.getSourceActions());
    }

    private DragSourceDragEvent _createDragSourceDragEvent() {
        return new DragSourceDragEvent(this._dragContext, this._getDropAction(), this._getTargetActions(), this._gestureModifiers, true);
    }

    private int _getTargetActions() {
        return this._dropContext == null ? 0 : this._dropContext.getTargetActions() & this._dragContext.getSourceActions();
    }

    private void _updateModifiers(InputEvent event) {
        int newModifiers = event.getModifiers();
        if (newModifiers != this._gestureModifiers) {
            this._gestureModifiers = newModifiers;
            this._dragContext.dropActionChanged(this._createDragSourceDragEvent());
            DropTarget target = this._target;
            if (target != null) {
                target.dropActionChanged(this._createDropTargetDragEvent(this._localPoint));
            }
        }
    }

    private int _getUserActions() {
        return DnDUtils.getDefaultActions(this._gestureModifiers);
    }

    private int _getDropAction() {
        int modifierActions = this._getUserActions();
        int sourceActions = this._dragContext.getSourceActions();
        int targetActions = this._dropContext != null ? this._dropContext.getTargetActions() : 0;
        int actions = sourceActions & targetActions;
        if ((actions &= 0x40000003) != 0) {
            if ((actions & modifierActions) != 0) {
                actions &= modifierActions;
            }
            if (actions != 1 & actions != 2 & actions != 0x40000000) {
                int primaryAction = 2;
                int secondaryAction = 1;
                actions = (actions & primaryAction) != 0 ? primaryAction : ((actions & secondaryAction) != 0 ? secondaryAction : 0x40000000);
            }
        }
        return actions;
    }
}

