/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

class OneDSparseArrayBlock {
    private int _start;
    private Object[] _data;

    public OneDSparseArrayBlock(int startIndex, int length) {
        this._start = startIndex;
        this._data = new Object[length];
    }

    public OneDSparseArrayBlock(int startIndex, Object[] elements, int count) {
        this._start = startIndex;
        this._data = new Object[count];
        System.arraycopy(elements, 0, this._data, 0, count);
    }

    public Object[] getElements() {
        Object[] data = new Object[this._data.length];
        System.arraycopy(this._data, 0, data, 0, this._data.length);
        return data;
    }

    public Object getElement(int index) {
        return this._data[index];
    }

    public int getLength() {
        return this._data.length;
    }

    public int getStartIndex() {
        return this._start;
    }

    public void setElement(int index, Object element) {
        this._data[index] = element;
    }

    public void setLength(int length) {
        Object[] newdata = new Object[length];
        System.arraycopy(this._data, 0, newdata, 0, Math.min(this._data.length, length));
        this._data = newdata;
    }

    public void setStartIndex(int startIndex) {
        this._start = startIndex;
    }
}

