/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public class DTreeStackingDecoration
implements DTreeDecoration {
    private DTreeDecoration _bottomDecoration;
    private DTreeDecoration _topDecoration;

    public DTreeStackingDecoration(DTreeDecoration bottomDecoration, DTreeDecoration topDecoration) {
        this._bottomDecoration = bottomDecoration;
        this._topDecoration = topDecoration;
    }

    public ImmInsets getDecorationInsets(DTree tree) {
        ImmInsets bottomInsets = this._bottomDecoration.getDecorationInsets(tree);
        ImmInsets topInsets = this._topDecoration.getDecorationInsets(tree);
        if (bottomInsets == null) {
            return topInsets;
        }
        if (topInsets == null) {
            return bottomInsets;
        }
        return new ImmInsets(Math.max(bottomInsets.top, topInsets.top), Math.max(bottomInsets.left, topInsets.left), Math.max(bottomInsets.bottom, topInsets.bottom), Math.max(bottomInsets.right, topInsets.right));
    }

    public void paintDecoration(PaintContext context, Graphics g, DTreeItem item, int width, int height) {
        this._bottomDecoration.paintDecoration(context, g, item, width, height);
        this._topDecoration.paintDecoration(context, g, item, width, height);
    }

    public void processMouseEvent(MouseEvent evt, DTreeItem item) {
        this._topDecoration.processMouseEvent(evt, item);
        if (evt.isConsumed()) {
            return;
        }
        this._bottomDecoration.processMouseEvent(evt, item);
    }
}

