/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeRootItem;

public class DTreeSelection
implements Cloneable {
    private DTreeRange[] _ranges;
    private int _itemCount;

    public final void addRange(DTreeRange range) {
        DTreeRange[] ranges = new DTreeRange[]{range};
        this.addRanges(ranges);
    }

    public void addRanges(DTreeRange[] ranges) {
        int addCount;
        DTreeRange[] newRanges = null;
        int newCount = 0;
        int n = addCount = ranges == null ? 0 : ranges.length;
        if (this._ranges == null) {
            newRanges = ranges;
            newCount = addCount;
        } else {
            int oldCount = this.getCount();
            newCount = addCount + oldCount;
            newRanges = new DTreeRange[newCount];
            System.arraycopy(ranges, 0, newRanges, 0, addCount);
            System.arraycopy(this._ranges, 0, newRanges, addCount, this._ranges.length);
        }
        newRanges = this._normalizeRanges(newRanges, newCount);
        this._ranges = newRanges;
        this._itemCount = this._countItems();
    }

    public Object clone() {
        DTreeSelection newSelection = new DTreeSelection();
        newSelection.addRanges(this._ranges);
        return newSelection;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DTreeSelection)) {
            return false;
        }
        DTreeSelection selection = (DTreeSelection)obj;
        if (selection.getCount() != this.getCount()) {
            return false;
        }
        int nranges = this.getCount();
        for (int i = 0; i < nranges; ++i) {
            if (this._ranges[i].equals(selection.getRange(i))) continue;
            return false;
        }
        return true;
    }

    public final DTreeSelection getAncestorSelection() {
        int nRanges = this.getCount();
        DTreeRange[] ancestors = new DTreeRange[nRanges];
        int nAncestors = 0;
        for (int i = 0; i < nRanges; ++i) {
            DTreeRange range = this.getRange(i);
            DTreeItem parent = range.getParent();
            boolean isDescendent = false;
            for (int j = 0; j < i; ++j) {
                if (!this.getRange(j).isItemDescendent(parent)) continue;
                isDescendent = true;
                break;
            }
            if (isDescendent) continue;
            ancestors[nAncestors++] = range;
        }
        if (ancestors.length > nAncestors) {
            DTreeRange[] tmpAncestors = new DTreeRange[nAncestors];
            System.arraycopy(ancestors, 0, tmpAncestors, 0, nAncestors);
            ancestors = tmpAncestors;
        }
        DTreeSelection ancestorRanges = new DTreeSelection();
        ancestorRanges.addRanges(ancestors);
        return ancestorRanges;
    }

    public int getCount() {
        return this._ranges == null ? 0 : this._ranges.length;
    }

    public final DTreeItem getFirstItem() {
        if (this.getItemCount() == 0) {
            return null;
        }
        DTreeRange range = this.getRange(0);
        return range.getParent().getItem(range.getStartIndex());
    }

    public final int getItemCount() {
        return this._itemCount;
    }

    public final DTreeItem[] getItems() {
        DTreeItem[] items = new DTreeItem[1];
        int itemCount = 0;
        for (int i = 0; i < this.getCount(); ++i) {
            DTreeRange range = this.getRange(i);
            DTreeItem parent = range.getParent();
            int start = range.getStartIndex();
            int count = range.getCount();
            int j = start;
            while (j < start + count) {
                DTreeItem item = parent.getItem(j);
                if (itemCount == items.length) {
                    DTreeItem[] tmpItems = new DTreeItem[itemCount * 2];
                    System.arraycopy(items, 0, tmpItems, 0, itemCount);
                    items = tmpItems;
                }
                items[itemCount] = item;
                ++j;
                ++itemCount;
            }
        }
        if (itemCount < items.length) {
            DTreeItem[] tmpItems = new DTreeItem[itemCount];
            System.arraycopy(items, 0, tmpItems, 0, itemCount);
            items = tmpItems;
        }
        return items;
    }

    public DTreeRange getRange(int index) {
        return this._ranges[index];
    }

    public final boolean isItemDescendent(DTreeItem item) {
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            if (!this.getRange(i).isItemDescendent(item)) continue;
            return true;
        }
        return false;
    }

    void __itemsAdded(DTreeItem parent, int startIndex, int count) {
        int nRanges = this.getCount();
        DTreeRange[] newRanges = new DTreeRange[nRanges];
        for (int i = 0; i < nRanges; ++i) {
            int rangeStart;
            DTreeRange range = this.getRange(i);
            DTreeItem rangeParent = range.getParent();
            if (parent == rangeParent && (rangeStart = range.getStartIndex()) >= startIndex) {
                range = new DTreeRange(parent, rangeStart + count, range.getCount());
            }
            newRanges[i] = range;
        }
        this._ranges = null;
        this.addRanges(newRanges);
    }

    void __itemsRemoved(DTreeItem parent, int startIndex, int count) {
        int lastIndex = startIndex + count - 1;
        DTree tree = parent.getTree();
        DTreeRootItem root = tree.getRoot();
        int oldRangeCount = this.getCount();
        DTreeRange[] newRanges = new DTreeRange[oldRangeCount];
        int newRangeCount = 0;
        for (int i = 0; i < oldRangeCount; ++i) {
            DTreeRange range = this.getRange(i);
            DTreeItem rangeParent = range.getParent();
            if (rangeParent == parent) {
                int rangeCount;
                int rangeStart = range.getStartIndex();
                int rangeEnd = rangeStart + (rangeCount = range.getCount()) - 1;
                if (startIndex > rangeEnd) {
                    newRanges[newRangeCount++] = range;
                    continue;
                }
                if (lastIndex < rangeStart) {
                    newRanges[newRangeCount++] = new DTreeRange(parent, rangeStart - count, rangeCount);
                    continue;
                }
                if (startIndex <= rangeStart) {
                    if (lastIndex >= rangeEnd) continue;
                    newRanges[newRangeCount++] = new DTreeRange(parent, startIndex, rangeEnd - lastIndex);
                    continue;
                }
                int newCount = startIndex - rangeStart;
                if (lastIndex < rangeEnd) {
                    newCount += rangeEnd - lastIndex;
                }
                newRanges[newRangeCount++] = new DTreeRange(parent, rangeStart, newCount);
                continue;
            }
            if (rangeParent.getTree() == null || !DTree.isItemDescendent(rangeParent, root)) continue;
            newRanges[newRangeCount++] = range;
        }
        if (newRangeCount < newRanges.length) {
            DTreeRange[] tmpRanges = new DTreeRange[newRangeCount];
            System.arraycopy(newRanges, 0, tmpRanges, 0, newRangeCount);
            newRanges = tmpRanges;
        }
        this._ranges = null;
        this.addRanges(newRanges);
    }

    private DTreeRange[] _normalizeRanges(DTreeRange[] ranges, int count) {
        int i;
        DTreeRange[] normal = new DTreeRange[count];
        int normalcount = 0;
        for (i = 0; i < count; ++i) {
            int j;
            DTreeRange range = ranges[i];
            DTreeItem parent = range.getParent();
            for (j = 0; j < normalcount; ++j) {
                DTreeRange normalrange = normal[j];
                DTreeItem normalparent = normalrange.getParent();
                if (parent == normalparent) {
                    if (range.getStartIndex() >= normalrange.getStartIndex()) continue;
                    System.arraycopy(normal, j, normal, j + 1, normalcount - j);
                    normal[j] = range;
                    ++normalcount;
                    break;
                }
                if (!DTree.isItemBefore(parent, normalparent)) continue;
                System.arraycopy(normal, j, normal, j + 1, normalcount - j);
                normal[j] = range;
                ++normalcount;
                break;
            }
            if (j != normalcount) continue;
            normal[j] = range;
            ++normalcount;
        }
        i = 0;
        while (i < normalcount) {
            DTreeRange range = normal[i];
            DTreeItem parent = range.getParent();
            int rangestart = range.getStartIndex();
            int rangecount = range.getCount();
            if (rangecount <= 0) {
                System.arraycopy(normal, i + 1, normal, i, normalcount - (i + 1));
                --normalcount;
                continue;
            }
            int j = i + 1;
            while (j < normalcount && parent == normal[j].getParent()) {
                DTreeRange nextrange = normal[j];
                int nextstart = nextrange.getStartIndex();
                int nextcount = nextrange.getCount();
                if (nextstart > rangestart + rangecount) break;
                rangecount = Math.max(rangecount, nextstart + nextcount - rangestart);
                normal[i] = new DTreeRange(parent, rangestart, rangecount);
                System.arraycopy(normal, j + 1, normal, j, normalcount - (j + 1));
                --normalcount;
            }
            ++i;
        }
        if (normalcount < normal.length) {
            DTreeRange[] tmpnormal = new DTreeRange[normalcount];
            System.arraycopy(normal, 0, tmpnormal, 0, normalcount);
            normal = tmpnormal;
        }
        return normal;
    }

    private int _countItems() {
        int nItems = 0;
        int nRanges = this.getCount();
        for (int i = 0; i < nRanges; ++i) {
            DTreeRange range = this.getRange(i);
            nItems += range.getCount();
        }
        return nItems;
    }
}

