/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.event.Cancelable;

public class DTreeMultipleSelectionManager
implements DTreeSelectionManager {
    private DTree _tree;
    private DTreeSelection _ranges;
    private DTreeItem _anchor;
    private PropertyChangeSupport _propSupport;
    private VetoableChangeSupport _vetoSupport;

    public DTreeMultipleSelectionManager() {
        this._setSelection(new DTreeSelection());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propSupport == null) {
            this._propSupport = new PropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport(this);
        }
        this._vetoSupport.addVetoableChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propSupport != null) {
            this._propSupport.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(listener);
        }
    }

    public void setTree(DTree tree) {
        if (tree != this._tree) {
            this._setSelection(null);
            this._tree = tree;
            this._setSelection(new DTreeSelection());
            this._anchor = null;
        }
    }

    public void extendSelection(DTreeItem item) throws PropertyVetoException {
        DTreeRange[] newranges = new DTreeRange[1];
        int newcount = 0;
        DTreeItem anchor = this._getAnchor();
        DTreeItem first = null;
        DTreeItem last = null;
        if (DTree.isItemBefore(anchor, item)) {
            first = anchor;
            last = item;
        } else {
            first = item;
            last = anchor;
        }
        Enumeration enumer = this._tree.getExpandedEnumeration();
        while (enumer.hasMoreElements()) {
            DTreeItem tmpparent;
            DTreeItem parent = (DTreeItem)enumer.nextElement();
            if (last == parent || DTree.isItemBefore(last, parent) || DTree.isItemBefore(parent, first) && !DTree.isItemDescendent(first, parent)) continue;
            int start = 0;
            int count = 0;
            if (first == parent || DTree.isItemBefore(first, parent)) {
                start = 0;
            } else if (first.getParent() == parent) {
                start = first.getIndex();
            } else {
                tmpparent = first.getParent();
                while (tmpparent.getParent() != parent) {
                    tmpparent = tmpparent.getParent();
                }
                start = tmpparent.getIndex() + 1;
            }
            if (!DTree.isItemDescendent(last, parent)) {
                count = parent.getItemCount() - start;
            } else {
                tmpparent = last;
                while (tmpparent.getParent() != parent) {
                    tmpparent = tmpparent.getParent();
                }
                count = tmpparent.getIndex() - start + 1;
            }
            DTreeRange newrange = new DTreeRange(parent, start, count);
            if (newcount == newranges.length) {
                DTreeRange[] tmpranges = new DTreeRange[newcount * 2];
                System.arraycopy(newranges, 0, tmpranges, 0, newcount);
                newranges = tmpranges;
            }
            newranges[newcount] = newrange;
            ++newcount;
        }
        if (newranges.length != newcount) {
            DTreeRange[] tmpranges = new DTreeRange[newcount];
            System.arraycopy(newranges, 0, tmpranges, 0, newcount);
            newranges = tmpranges;
        }
        DTreeSelection newSelection = new DTreeSelection();
        newSelection.addRanges(newranges);
        this._setSelection(newSelection, item);
    }

    public boolean isSomethingSelected() {
        return this._ranges.getCount() > 0;
    }

    public DTreeSelection getSelection() {
        return (DTreeSelection)this._ranges.clone();
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isSelected(DTreeItem item) {
        DTreeItem parent = item.getParent();
        int index = item.getIndex();
        for (int i = 0; i < this._ranges.getCount(); ++i) {
            DTreeRange range = this._ranges.getRange(i);
            if (!range.contains(parent, index)) continue;
            return true;
        }
        return false;
    }

    public void itemCollapsing(DTreeItemEvent evt) {
        DTreeItem item = evt.getItem();
        DTreeSelection oldranges = this.getSelection();
        DTreeSelection newranges = new DTreeSelection();
        for (int i = 0; i < oldranges.getCount(); ++i) {
            DTreeRange range = oldranges.getRange(i);
            if (DTree.isItemDescendent(range.getParent(), item)) continue;
            newranges.addRange(range);
        }
        try {
            this.setSelection(newranges);
        }
        catch (PropertyVetoException e) {
            ((Cancelable)((Object)evt)).cancel();
        }
    }

    public void itemsAdded(DTreeItem parent, int startIndex, int count) {
    }

    public void itemsRemoved(DTreeItem parent, int startIndex, int count) {
    }

    public void selectItem(DTreeItem item) throws PropertyVetoException {
        DTreeSelection newranges = new DTreeSelection();
        if (item != null) {
            newranges.addRange(new DTreeRange(item.getParent(), item.getIndex(), 1));
        }
        this._setSelection(newranges, item);
        this._setAnchor(item);
    }

    public void setSelection(DTreeSelection ranges) throws PropertyVetoException {
        this._setSelection(ranges, null);
    }

    public void toggleItem(DTreeItem item) throws PropertyVetoException {
        DTreeSelection oldranges = this.getSelection();
        DTreeSelection newranges = null;
        if (!this.isSelected(item)) {
            newranges = this.getSelection();
            newranges.addRange(new DTreeRange(item.getParent(), item.getIndex(), 1));
        } else {
            DTreeItem parent = item.getParent();
            int index = item.getIndex();
            newranges = new DTreeSelection();
            for (int i = 0; i < oldranges.getCount(); ++i) {
                DTreeRange range = oldranges.getRange(i);
                if (!range.contains(parent, index)) {
                    newranges.addRange(range);
                    continue;
                }
                int rangestart = range.getStartIndex();
                int rangecount = range.getCount();
                if (index > rangestart) {
                    newranges.addRange(new DTreeRange(parent, rangestart, index - rangestart));
                }
                if (index >= rangestart + rangecount - 1) continue;
                newranges.addRange(new DTreeRange(parent, index + 1, rangestart + rangecount - (index + 1)));
            }
        }
        this._setSelection(newranges, item);
        this._setAnchor(item);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propSupport != null) {
            this._propSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this._vetoSupport != null) {
            this._vetoSupport.fireVetoableChange(propertyName, oldValue, newValue);
        }
    }

    protected DTreeSelection filterSelection(DTreeSelection selection) {
        return selection;
    }

    private DTreeItem _getAnchor() {
        if (this._anchor == null) {
            this._anchor = this._tree.getRoot();
        }
        return this._anchor;
    }

    private void _setAnchor(DTreeItem anchor) {
        this._anchor = anchor;
    }

    private void _setFocusedItem(DTreeItem focusedItem) {
        if (focusedItem != null) {
            DTree tree = this.getTree();
            tree.setFocusedItem(focusedItem);
        }
    }

    private void _setSelection(DTreeSelection ranges, DTreeItem newFocus) throws PropertyVetoException {
        DTreeSelection oldranges = this.getSelection();
        boolean emptySelection = ranges == null;
        DTreeSelection newranges = emptySelection ? new DTreeSelection() : this.filterSelection((DTreeSelection)ranges.clone());
        if (oldranges.equals(ranges)) {
            return;
        }
        this.fireVetoableChange("selection", oldranges, newranges);
        this._setSelection(newranges);
        this._setFocusedItem(newFocus);
        if (emptySelection) {
            this._setAnchor(null);
        } else if (this._anchor == null) {
            this._setAnchor(newranges.getFirstItem());
        }
        this.firePropertyChange("selection", oldranges, newranges);
    }

    private void _setSelection(DTreeSelection selection) {
        DTree tree;
        if (selection != this._ranges && (tree = this.getTree()) != null) {
            if (this._ranges != null) {
                tree.__removeSelection(this._ranges);
            }
            this._ranges = selection;
            if (this._ranges != null) {
                tree.__addSelection(this._ranges);
            }
        }
    }
}

