/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;

class RGBComponent
extends BaseColorEditor {
    private static final String _KEY_RED = "COLORCHOOSER.RED_LABEL";
    private static final String _KEY_GREEN = "COLORCHOOSER.GREEN_LABEL";
    private static final String _KEY_BLUE = "COLORCHOOSER.BLUE_LABEL";
    private static final String _KEY_RED_DESC = "COLORCHOOSER.RED_DESCRIPTION";
    private static final String _KEY_GREEN_DESC = "COLORCHOOSER.GREEN_DESCRIPTION";
    private static final String _KEY_BLUE_DESC = "COLORCHOOSER.BLUE_DESCRIPTION";
    private static final String _RED_NAME = "Red_Box";
    private static final String _GREEN_NAME = "Green_Box";
    private static final String _BLUE_NAME = "Blue_Box";
    private boolean _ignoreEvents;
    private JLabel _redLabel;
    private JLabel _blueLabel;
    private JLabel _greenLabel;
    private NumericSpinBox _red;
    private NumericSpinBox _green;
    private NumericSpinBox _blue;

    public RGBComponent() {
        Insets inset;
        Listener listener = new Listener();
        this._red = new NumericSpinBox(0, 255);
        this._red.addChangeListener(listener);
        this._red.setName(_RED_NAME);
        this._green = new NumericSpinBox(0, 255);
        this._green.addChangeListener(listener);
        this._green.setName(_GREEN_NAME);
        this._blue = new NumericSpinBox(0, 255);
        this._blue.addChangeListener(listener);
        this._blue.setName(_BLUE_NAME);
        this._redLabel = new JLabel(" ");
        this._redLabel.setLabelFor(this._red);
        this._greenLabel = new JLabel(" ");
        this._greenLabel.setLabelFor(this._green);
        this._blueLabel = new JLabel(" ");
        this._blueLabel.setLabelFor(this._blue);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = inset = new Insets(0, 0, 3, 12);
        this.setLayout(layout);
        gbc.gridwidth = -1;
        layout.setConstraints(this._redLabel, gbc);
        this.add(this._redLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._red, gbc);
        this.add(this._red);
        gbc.gridwidth = -1;
        inset.right = 12;
        layout.setConstraints(this._greenLabel, gbc);
        this.add(this._greenLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._green, gbc);
        this.add(this._green);
        gbc.gridwidth = -1;
        inset.bottom = 0;
        inset.right = 12;
        layout.setConstraints(this._blueLabel, gbc);
        this.add(this._blueLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._blue, gbc);
        this.add(this._blue);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._redLabel.setEnabled(enabled);
        this._blueLabel.setEnabled(enabled);
        this._greenLabel.setEnabled(enabled);
        this._red.setEnabled(enabled);
        this._green.setEnabled(enabled);
        this._blue.setEnabled(enabled);
    }

    protected void colorChanged(Color newColor) {
        this._ignoreEvents = true;
        int[] vals = ColorUtils.colorToRGB(newColor);
        this._red.setIntValue(vals[0]);
        this._green.setIntValue(vals[1]);
        this._blue.setIntValue(vals[2]);
        this._ignoreEvents = false;
    }

    protected void updateLabels(Locale newLocale) {
        String translatedText = RGBComponent.__getTranslatedString(newLocale, _KEY_RED);
        this._redLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._redLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = RGBComponent.__getTranslatedString(newLocale, _KEY_GREEN);
        this._greenLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._greenLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = RGBComponent.__getTranslatedString(newLocale, _KEY_BLUE);
        this._blueLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._blueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
    }

    protected void updateAccessibleNames() {
        String text = this.__getTranslatedString(_KEY_RED_DESC);
        this._red.getAccessibleContext().setAccessibleName(text);
        text = this.__getTranslatedString(_KEY_GREEN_DESC);
        this._green.getAccessibleContext().setAccessibleName(text);
        text = this.__getTranslatedString(_KEY_BLUE_DESC);
        this._blue.getAccessibleContext().setAccessibleName(text);
    }

    private void _updateColor() {
        this.storeColor(ColorUtils.rgbToColor(this._red.getIntValue(), this._green.getIntValue(), this._blue.getIntValue()));
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!RGBComponent.this._ignoreEvents) {
                RGBComponent.this._updateColor();
            }
        }
    }
}

