/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

class ColorComponent
extends BaseColorEditor
implements KeyListener {
    private static final String _KEY_ACCESS_NAME = "COLORCHOICE.FULL_ACCESSIBLE_NAME";
    private static final String _KEY_COLOR_VALUE = "COLORPALETTE.TOOLTIP";
    private static final Dimension _SIZE = new Dimension(54, 21);
    private static final String _SELECTED_LABEL = "COLORCHOOSER.SELECTED_COLOR";
    private static final String _ORIGINAL_LABEL = "COLORCHOOSER.ORIGINAL_COLOR";
    private static final String _ORIGINAL_COLOR_NAME = "Current_Color_Panel";
    private JLabel _selectedColorLabel = new JLabel("");
    private JLabel _originalColorLabel;
    private ColorPanel _selectedColorPanel = new ColorPanel();
    private ColorPanel _originalColorPanel;
    private Color _originalColor;

    public ColorComponent() {
        Insets inset;
        this._selectedColorPanel.setBackground(Color.white);
        this._originalColorLabel = new JLabel("");
        this._originalColorLabel.addKeyListener(this);
        this._originalColorPanel = new OriginalColorPanel();
        this._originalColorLabel.setLabelFor(this._originalColorPanel);
        this._originalColorPanel.setName(_ORIGINAL_COLOR_NAME);
        this._originalColorPanel.addKeyListener(this);
        this.setOriginalColor(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = -1;
        gbc.anchor = 17;
        gbc.insets = inset = new Insets(0, 0, 0, 12);
        gbc.gridx = 0;
        this.add((Component)this._selectedColorLabel, gbc);
        this.add((Component)this._originalColorLabel, gbc);
        gbc.gridx = 1;
        inset.right = 0;
        gbc.weightx = 1.0;
        this.add((Component)this._selectedColorPanel, gbc);
        this.add((Component)this._originalColorPanel, gbc);
    }

    public void setOriginalColor(Color color) {
        this._originalColor = color == null ? Color.white : color;
        this._originalColorPanel.setBackground(this._originalColor);
    }

    public Color getOriginalColor() {
        return this._originalColor;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._selectedColorLabel.setEnabled(enabled);
        this._selectedColorPanel.setEnabled(enabled);
        this._originalColorLabel.setEnabled(enabled);
        this._originalColorPanel.setEnabled(enabled);
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getComponent() == this._originalColorPanel && this.isEnabled() && !ke.isConsumed() && ke.getModifiers() == 0 && ke.getKeyCode() == 32) {
            this._restoreOriginalColor();
            ke.consume();
        }
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
        int keyCode;
        if (ke.getComponent() == this._originalColorLabel && this.isEnabled() && !ke.isConsumed() && ke.getModifiers() == 8 && ((keyCode = ke.getKeyCode()) == 0 || keyCode == this._originalColorLabel.getDisplayedMnemonic())) {
            this._restoreOriginalColor();
        }
    }

    protected void colorChanged(Color newColor) {
        this._selectedColorPanel.setBackground(newColor);
    }

    protected void updateLabels(Locale locale) {
        String translatedText = ColorComponent.__getTranslatedString(locale, _SELECTED_LABEL);
        this._selectedColorLabel.setText(translatedText);
        translatedText = ColorComponent.__getTranslatedString(locale, _ORIGINAL_LABEL);
        this._originalColorLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._originalColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
    }

    public void _restoreOriginalColor() {
        if (this.getColor() != this._originalColor) {
            this.storeColor(this._originalColor);
            this._selectedColorPanel.setBackground(this._originalColor);
        }
    }

    private class OriginalColorPanel
    extends ColorPanel
    implements Accessible {
        public OriginalColorPanel() {
            this.enableEvents(20L);
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (this.isEnabled() && !me.isConsumed() && me.getID() == 501 && SwingUtilities.isLeftMouseButton(me)) {
                if (!this.hasFocus()) {
                    this.requestFocus();
                }
                ColorComponent.this._restoreOriginalColor();
                me.consume();
            }
        }

        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            this.repaint();
        }

        private class Access
        extends JComponent.AccessibleJComponent {
            private Access() {
                super(OriginalColorPanel.this);
            }

            public String getAccessibleName() {
                String accName = super.getAccessibleName();
                if (accName == null) {
                    accName = "";
                }
                String accPattern = ColorComponent.this.__getAccessTranslatedString(ColorComponent._KEY_ACCESS_NAME);
                accName = MessageFormat.format(accPattern, accName);
                accPattern = ColorComponent.this.__getAccessTranslatedString(ColorComponent._KEY_COLOR_VALUE);
                Color c = ColorComponent.this._originalColor;
                Object[] argss = new Object[]{IntegerUtils.getInteger((int)c.getRed()), IntegerUtils.getInteger((int)c.getGreen()), IntegerUtils.getInteger((int)c.getBlue())};
                String colorValue = MessageFormat.format(accPattern, argss);
                return accName + " " + colorValue;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }
        }
    }

    private class ColorPanel
    extends LWComponent {
        private ColorPanel() {
        }

        public Dimension getMinimumSize() {
            return _SIZE;
        }

        public Dimension getPreferredSize() {
            return _SIZE;
        }

        public Dimension getMaximumSize() {
            return _SIZE;
        }

        protected void paintComponent(Graphics g) {
            Color oldColor = g.getColor();
            ImmInsets i = this.getBorderInsets();
            int x = i.left;
            int y = i.top;
            int width = this.getWidth() - (i.left + i.right);
            int height = this.getHeight() - (i.top + i.bottom);
            Color color = this.getBackground();
            g.setColor(color);
            g.fillRect(i.left, i.top, width, height);
            if (this.hasFocus()) {
                double lum = (double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11;
                if (lum < 61.0) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.black);
                }
                ColorPickerUtils.paintFocus(g, x, y += 2, width, height -= 4);
            }
            g.setColor(oldColor);
        }
    }
}

