/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;

public class PopupButtonModel
extends DefaultButtonModel {
    AbstractButton _button;
    private JPopupMenu _popupMenu;
    private PopupMenuListener _pml;
    private AWTEventListener _awtListener;
    private Timer _timer;
    private boolean _popupAlreadyShown;
    private boolean _popupWillShow;
    private static final int _POPUP_DELAY = 500;

    public PopupButtonModel(AbstractButton button) {
        this._button = button;
        Listen listen = new Listen();
        this._timer = new Timer(500, listen);
        this._timer.setRepeats(false);
        this._pml = listen;
    }

    public PopupButtonModel(AbstractButton button, JPopupMenu popup) {
        this(button);
        this.setPopupMenu(popup);
    }

    public void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._awtListener);
    }

    public JPopupMenu getPopupMenu() {
        return this._popupMenu;
    }

    public synchronized void setPopupMenu(JPopupMenu popupMenu) {
        if (popupMenu != this._popupMenu) {
            if (this._popupMenu != null) {
                this._popupMenu.removePopupMenuListener(this._pml);
            }
            this._popupMenu = popupMenu;
            if (popupMenu != null) {
                popupMenu.addPopupMenuListener(this._pml);
            }
        }
    }

    public void setDelay(int delay) {
        this._timer.setInitialDelay(delay);
    }

    public int getDelay() {
        return this._timer.getInitialDelay();
    }

    public boolean isPressed() {
        return super.isPressed() || this._isMenuVisible();
    }

    public boolean isArmed() {
        return super.isArmed() || this._isMenuVisible();
    }

    public void setPressed(boolean isPressed) {
        if (isPressed != super.isPressed()) {
            if (isPressed) {
                super.setPressed(isPressed);
                if (this._isMenuVisible()) {
                    this._hidePopup();
                } else if (!this._popupAlreadyShown && this.getPopupMenu() != null) {
                    this._popupWillShow = true;
                    this._timer.start();
                }
            } else if (!this._popupWillShow) {
                super.setPressed(isPressed);
            }
        }
    }

    public void setArmed(boolean isArmed) {
        if (isArmed != super.isArmed() && !this._popupWillShow) {
            super.setArmed(isArmed);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            if (!enabled) {
                this.setArmed(false);
                this.setPressed(false);
            }
            super.setEnabled(enabled);
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this._isMenuVisible()) {
            return;
        }
        super.fireActionPerformed(e);
    }

    void __showPopup() {
        this._popupWillShow = false;
        this.setArmed(false);
        super.setPressed(false);
        JPopupMenu popup = this.getPopupMenu();
        if (popup != null) {
            MenuUtils.showPopupMenu(popup, this._button, 0, this._button.getHeight());
        }
    }

    void __initialize() {
        this._awtListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                if (event.getSource() == PopupButtonModel.this._button && event.getID() == 501) {
                    if (PopupButtonModel.this._isMenuVisible()) {
                        PopupButtonModel.this._popupAlreadyShown = true;
                    } else {
                        PopupButtonModel.this._popupAlreadyShown = false;
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this._awtListener, 16L);
    }

    private void _hidePopup() {
        JPopupMenu popup = this.getPopupMenu();
        if (popup != null) {
            popup.setVisible(false);
        }
    }

    private boolean _isMenuVisible() {
        JPopupMenu popup = this.getPopupMenu();
        if (popup == null) {
            return false;
        }
        return popup.isVisible();
    }

    private class Listen
    implements ActionListener,
    PopupMenuListener {
        private Listen() {
        }

        public void actionPerformed(ActionEvent event) {
            PopupButtonModel.this.__showPopup();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            PopupButtonModel.this.fireStateChanged();
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

