/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.FontUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DialogBarLayout
implements LayoutManager2 {
    private static final double _MIN_RELATIVE_WIDTH = 0.1;
    private static final int _CELL_SIZE_GAP = 5;
    private static final double _FRACTION = 0.95;
    private static final int _BUTTON_GAP = 1;
    private static final int _LEFT_RIGHT_GAP = 30;
    private static final int _GROUP_GAP = 8;
    private static final int _COMP_INDEX_HELP = 0;
    private static final int _COMP_INDEX_YES = 1;
    private static final int _COMP_INDEX_NO = 2;
    private static final int _COMP_INDEX_CANCEL = 3;
    private static final int _COMP_INDEX_BACK = 4;
    private static final int _COMP_INDEX_NEXT = 5;
    private static final int _COMP_INDEX_FINISH = 6;
    private static final int _COMP_INDEX_APPLY = 7;
    private static final int _COMP_INDEX_SAVE = 8;
    private static final int _COMP_INDEX_NULL = 9;
    private static final int _NUM_COMPS = 10;
    private static final int[] _NORMAL_SPECIAL_START = new int[]{0};
    private static final int[] _NORMAL_SPECIAL_END = new int[]{3, 2, 1, 7, 8, 6, 5, 4};
    private static final int[] _WIZARD_SPECIAL_START = new int[]{0, 7, 8};
    private static final int[] _WIZARD_SPECIAL_END = new int[]{2, 1, 3, 6, 5, 4};
    private Hashtable _compToConstraintMap = new Hashtable(13);
    private Component[] _specialComponents = new Component[10];
    private ArrayList<Component> _sortedSpecialComp;
    private int _indexSortedSpecial = -1;
    private int _cellWidth;
    private double _relativeWidth = 1.0;
    private boolean _layoutDirty = false;
    private Container _container;
    private transient Dimension _cellSize = null;
    private static final String _RESERVED_WIZARD_BUTTONS = "WizardReservedButtonSpaces";

    public DialogBarLayout(Container container) {
        this._container = container;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void addLayoutComponent(String constraintName, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        int specialIndex = (Integer)this._compToConstraintMap.remove(comp);
        if (this._specialComponents[specialIndex] == comp) {
            this._specialComponents[specialIndex] = null;
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Component oldSpecial;
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        if (constraints == null) {
            constraints = DialogButtonBar.CONSTRAINT_NULL;
        }
        Integer intConstraint = (Integer)constraints;
        this._compToConstraintMap.put(comp, intConstraint);
        int specialIndex = intConstraint;
        if (specialIndex != 9 && (oldSpecial = this._specialComponents[specialIndex]) != null) {
            this._compToConstraintMap.put(comp, DialogButtonBar.CONSTRAINT_NULL);
        }
        this._specialComponents[specialIndex] = comp;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension innerSize = null;
        innerSize = this._isWizardConfiguration() ? this._calculateSizeInWizard(target) : this._calculateSize(target);
        Insets borderInsets = target.getInsets();
        innerSize.width += borderInsets.left + borderInsets.right;
        innerSize.height += borderInsets.top + borderInsets.bottom;
        Insets lafInsets = UIManager.getInsets("EWTDialogButtonBar.margin");
        if (lafInsets != null) {
            innerSize.width += lafInsets.left + lafInsets.right;
            innerSize.height += lafInsets.top + lafInsets.bottom;
        }
        return innerSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container target) {
        Dimension availableSize = target.getSize();
        Insets insets = target.getInsets();
        boolean isWizard = this._isWizardConfiguration();
        Insets lafInsets = UIManager.getInsets("EWTDialogButtonBar.margin");
        if (lafInsets != null) {
            insets.left += lafInsets.left;
            insets.right += lafInsets.right;
            insets.top += lafInsets.top;
            insets.bottom += lafInsets.bottom;
        }
        int startX = insets.left;
        int endX = availableSize.width - insets.right;
        int startY = insets.top;
        int availableHeight = availableSize.height - startY - insets.bottom;
        Dimension cellSize = this._getCellSize(target);
        int cellWidth = cellSize.width;
        int cellHeight = cellSize.height;
        int extraHeight = availableHeight - cellHeight;
        if (extraHeight < 0) {
            cellHeight = availableHeight;
            extraHeight = 0;
        }
        startX = this._layoutSpecialComponents(this._getSpecialLeft(), true, startX, endX, startY, extraHeight, cellWidth, cellHeight);
        endX = this._layoutSpecialComponents(this._getSpecialRight(), false, startX, endX, startY, extraHeight, cellWidth, cellHeight);
        if (isWizard) {
            this._layoutNonSpecialComponentsInWizard(target, startX, endX, startY, extraHeight, cellWidth, cellHeight);
        } else {
            this._layoutNonSpecialComponents(target, startX, endX, startY, extraHeight, cellWidth, cellHeight);
        }
        while (isWizard && this._layoutDirty) {
            this._layoutDirty = false;
            int currCellWidth = this._calculateCellWidth();
            startX = insets.left;
            endX = availableSize.width - insets.right;
            startX = this._layoutSpecialComponents(this._getSpecialLeft(), true, startX, endX, startY, extraHeight, currCellWidth, cellHeight);
            if (this._layoutDirty) continue;
            endX = this._layoutSpecialComponents(this._getSpecialRight(), false, startX, endX, startY, extraHeight, currCellWidth, cellHeight);
            if (this._layoutDirty) continue;
            this._layoutNonSpecialComponentsInWizard(target, startX, endX, startY, extraHeight, currCellWidth, cellHeight);
        }
        this._layoutDirty = false;
        this._relativeWidth = 1.0;
        this._sortedSpecialComp = null;
    }

    private void _layoutNonSpecialComponents(Container target, int startX, int endX, int startY, int extraHeight, int cellWidth, int cellHeight) {
        int availableWidth;
        int shiftStart;
        cellWidth = (int)((double)cellWidth * this._relativeWidth);
        int numVisibleSpecial = this._getNumVisibleSpecial();
        int numVisibleChildren = this._getNumVisible(target);
        int numVisibleNonSpecial = numVisibleChildren - numVisibleSpecial;
        int nonSpecialSize = numVisibleNonSpecial * cellWidth;
        if (numVisibleNonSpecial > 0) {
            nonSpecialSize += (numVisibleNonSpecial - 1) * 8;
        }
        if ((shiftStart = (availableWidth = endX - startX) - nonSpecialSize) > 0) {
            startX += shiftStart;
            availableWidth -= shiftStart;
        }
        int numChildren = target.getComponentCount();
        for (int i = 0; i < numChildren; ++i) {
            Component currComponent = target.getComponent(i);
            if (!currComponent.isVisible() || this._isSpecial(currComponent)) continue;
            if (cellWidth > availableWidth) {
                if (this._relativeWidth > 0.1) {
                    this._layoutDirty = true;
                    return;
                }
                cellWidth = availableWidth;
            }
            int currY = 0;
            if (extraHeight > 0) {
                currY = (int)((float)extraHeight * currComponent.getAlignmentY());
            }
            currComponent.setBounds(startX, startY + currY, cellWidth, cellHeight);
            int sizeIncrement = cellWidth + 8;
            startX += sizeIncrement;
            availableWidth -= sizeIncrement;
        }
    }

    private void _layoutNonSpecialComponentsInWizard(Container target, int startX, int endX, int startY, int extraHeight, int cellWidth, int cellHeight) {
        int availableWidth;
        int shiftStart;
        int numVisibleSpecial = this._getNumVisibleSpecial();
        int numVisibleChildren = this._getNumVisible(target);
        int numVisibleNonSpecial = 0;
        int nonSpecialSize = 0;
        int numChildren = target.getComponentCount();
        for (int i = 0; i < numChildren; ++i) {
            Component currChild = target.getComponent(i);
            if (!currChild.isVisible() || this._isSpecial(currChild)) continue;
            ++numVisibleNonSpecial;
            Dimension currPreferred = currChild.getPreferredSize();
            Font font = currChild.getFont();
            if (font != null) {
                currPreferred.width += 3 * FontUtils.getAverageWidth(font);
            }
            nonSpecialSize += (int)((double)Math.max(cellWidth, currPreferred.width) * this._relativeWidth);
        }
        if (numVisibleNonSpecial > 0) {
            nonSpecialSize += (numVisibleNonSpecial - 1) * 8;
        }
        if ((shiftStart = (availableWidth = endX - startX) - nonSpecialSize) > 0) {
            startX += shiftStart / 2;
            availableWidth -= shiftStart / 2;
        }
        for (int i = 0; i < numChildren; ++i) {
            Component currComponent = target.getComponent(i);
            if (!currComponent.isVisible() || this._isSpecial(currComponent)) continue;
            Dimension currPreferred = currComponent.getPreferredSize();
            Font font = currComponent.getFont();
            if (font != null) {
                currPreferred.width += 3 * FontUtils.getAverageWidth(font);
            }
            int width = Math.max(currPreferred.width, cellWidth);
            if ((width = (int)((double)width * this._relativeWidth)) > availableWidth) {
                if (this._relativeWidth > 0.1) {
                    this._layoutDirty = true;
                    return;
                }
                width = availableWidth;
            }
            int currY = 0;
            if (extraHeight > 0) {
                currY = (int)((float)extraHeight * currComponent.getAlignmentY());
            }
            currComponent.setBounds(startX, startY + currY, width, cellHeight);
            int sizeIncrement = width + 8;
            startX += sizeIncrement;
            availableWidth -= sizeIncrement;
        }
    }

    private int _layoutSpecialComponents(int[] specialIndices, boolean isStart, int startX, int endX, int startY, int extraHeight, int cellWidth, int cellHeight) {
        cellWidth = (int)((double)cellWidth * this._relativeWidth);
        for (int i = 0; i < specialIndices.length; ++i) {
            Component nextComponent;
            int nextSpecialIndex;
            int availableWidth = endX - startX;
            int currSpecialIndex = specialIndices[i];
            Component currComponent = this._specialComponents[currSpecialIndex];
            if (currComponent == null || !currComponent.isVisible()) continue;
            if (cellWidth > availableWidth) {
                if (this._relativeWidth > 0.1) {
                    this._layoutDirty = true;
                    return -1;
                }
                cellWidth = availableWidth;
            }
            int currY = 0;
            if (extraHeight > 0) {
                currY = (int)((float)extraHeight * currComponent.getAlignmentY());
            }
            int currX = startX;
            if (!isStart) {
                currX = endX - cellWidth;
            }
            currComponent.setBounds(currX, startY + currY, cellWidth, cellHeight);
            int gapSize = 8;
            if (currSpecialIndex == 5 && i + 1 < specialIndices.length && (nextSpecialIndex = specialIndices[i + 1]) == 4 && (nextComponent = this._specialComponents[nextSpecialIndex]) != null && nextComponent.isVisible()) {
                gapSize = 1;
            }
            int sizeIncrement = cellWidth + gapSize;
            if (isStart) {
                startX += sizeIncrement;
                continue;
            }
            endX -= sizeIncrement;
        }
        if (isStart) {
            return startX;
        }
        return endX;
    }

    @Override
    public void invalidateLayout(Container target) {
        this._cellSize = null;
    }

    private Dimension _getCellSize(Container target) {
        if (this._cellSize == null) {
            this._cellSize = this._calculateCellSize(target, this._isWizardConfiguration());
        }
        return this._cellSize;
    }

    private Dimension _calculateSize(Container target) {
        int numVisibleChildren = this._getNumVisible(target);
        Dimension cellSize = this._getCellSize(target);
        int newWidth = cellSize.width * numVisibleChildren;
        if (numVisibleChildren > 0) {
            if (this._isBackAndNextVisible()) {
                newWidth += (numVisibleChildren - 2) * 8;
                ++newWidth;
            } else {
                newWidth += (numVisibleChildren - 1) * 8;
            }
            if (this._isLeftGroupPresent() && this._isRightGroupPresent()) {
                newWidth += Math.min(30, cellSize.width);
            }
        }
        int newHeight = cellSize.height;
        return new Dimension(newWidth, newHeight);
    }

    private Dimension _calculateSizeInWizard(Container target) {
        int numChildren = target.getComponentCount();
        int numVisibleChildren = this._getNumVisible(target);
        int numSpecialVisible = this._getNumVisibleSpecial();
        int numNonSpecialVisible = 0;
        Dimension cellSize = this._getCellSize(target);
        int newWidth = cellSize.width * numSpecialVisible;
        for (int i = 0; i < numChildren; ++i) {
            Component currChild = target.getComponent(i);
            if (!currChild.isVisible() || this._isSpecial(currChild)) continue;
            Dimension currPreferred = currChild.getPreferredSize();
            Font font = currChild.getFont();
            if (font != null) {
                currPreferred.width += 3 * FontUtils.getAverageWidth(font);
            }
            newWidth += Math.max(currPreferred.width, cellSize.width);
            ++numNonSpecialVisible;
        }
        if (numVisibleChildren > 0) {
            if (this._isBackAndNextVisible()) {
                newWidth += (numVisibleChildren - 2) * 8;
                ++newWidth;
            } else {
                newWidth += (numVisibleChildren - 1) * 8;
            }
            int numGroups = 0;
            if (this._isLeftGroupPresent()) {
                ++numGroups;
            }
            if (this._isRightGroupPresent()) {
                ++numGroups;
            }
            if (numNonSpecialVisible != 0) {
                ++numGroups;
            }
            if (numGroups > 1) {
                newWidth += (numGroups - 1) * Math.min(30, cellSize.width);
            }
        }
        return new Dimension(newWidth, cellSize.height);
    }

    private boolean _isLeftGroupPresent() {
        int[] left = this._getSpecialStart();
        for (int i = 0; i < left.length; ++i) {
            Component comp = this._specialComponents[left[i]];
            if (comp == null || !comp.isVisible()) continue;
            return true;
        }
        return false;
    }

    private boolean _isRightGroupPresent() {
        int[] right = this._getSpecialEnd();
        for (int i = 0; i < right.length; ++i) {
            Component comp = this._specialComponents[right[i]];
            if (comp == null || !comp.isVisible()) continue;
            return true;
        }
        return false;
    }

    private Dimension _calculateCellSize(Container target, boolean onlySpecialButtonWidth) {
        int numChildren = target.getComponentCount();
        int currMaxHeight = 0;
        int currMaxWidth = 0;
        Font font = null;
        for (int i = 0; i < numChildren; ++i) {
            Component currChild = target.getComponent(i);
            if (!currChild.isVisible()) continue;
            Dimension currPreferred = currChild.getPreferredSize();
            if (font == null) {
                font = currChild.getFont();
            }
            if ((!onlySpecialButtonWidth || this._isSpecial(currChild)) && currPreferred.width > currMaxWidth) {
                currMaxWidth = currPreferred.width;
            }
            if (currPreferred.height <= currMaxHeight) continue;
            currMaxHeight = currPreferred.height;
        }
        if (font != null) {
            currMaxWidth += 3 * FontUtils.getAverageWidth(font);
        }
        return new Dimension(currMaxWidth, currMaxHeight);
    }

    private int _getNumVisible(Container target) {
        Object o;
        int numVisible = 0;
        int numChildren = target.getComponentCount();
        for (int i = 0; i < numChildren; ++i) {
            if (!target.getComponent(i).isVisible()) continue;
            ++numVisible;
        }
        if (this._isWizardConfiguration() && target instanceof JComponent && (o = ((JComponent)target).getClientProperty(_RESERVED_WIZARD_BUTTONS)) instanceof Integer) {
            numVisible += ((Integer)o).intValue();
        }
        return numVisible;
    }

    private boolean _isBackAndNextVisible() {
        Component back = this._specialComponents[4];
        Component next = this._specialComponents[5];
        return back != null && next != null && back.isVisible() && next.isVisible();
    }

    private boolean _isSpecial(Component comp) {
        return (Integer)this._compToConstraintMap.get(comp) != 9;
    }

    private int _getNumVisibleSpecial() {
        int numSpecial = 0;
        for (int i = 0; i < 9; ++i) {
            Component currSpecial = this._specialComponents[i];
            if (currSpecial == null || !currSpecial.isVisible()) continue;
            ++numSpecial;
        }
        return numSpecial;
    }

    private int[] _getSpecialLeft() {
        if (this._isLeftToRight()) {
            return this._getSpecialStart();
        }
        return this._getSpecialEnd();
    }

    private int[] _getSpecialRight() {
        if (this._isLeftToRight()) {
            return this._getSpecialEnd();
        }
        return this._getSpecialStart();
    }

    private int[] _getSpecialStart() {
        if (this._isWizardConfiguration()) {
            return _WIZARD_SPECIAL_START;
        }
        return _NORMAL_SPECIAL_START;
    }

    private int[] _getSpecialEnd() {
        if (this._isWizardConfiguration()) {
            return _WIZARD_SPECIAL_END;
        }
        return _NORMAL_SPECIAL_END;
    }

    private boolean _isWizardConfiguration() {
        return this._specialComponents[4] != null || this._specialComponents[5] != null || this._specialComponents[6] != null;
    }

    private boolean _isLeftToRight() {
        return true;
    }

    private ArrayList<Component> _sortSpecialComponent() {
        ArrayList<Component> comps = new ArrayList<Component>();
        for (int i = 0; i < this._specialComponents.length; ++i) {
            Component c = this._specialComponents[i];
            if (c == null || !c.isVisible() || !this._isSpecial(c)) continue;
            comps.add(this._specialComponents[i]);
        }
        Collections.sort(comps, new ButtonWidthComparator());
        return comps;
    }

    private int _calculateCellWidth() {
        if (this._sortedSpecialComp == null) {
            this._sortedSpecialComp = this._sortSpecialComponent();
            this._indexSortedSpecial = this._sortedSpecialComp.size();
            if (this._indexSortedSpecial > 0) {
                this._cellWidth = this._sortedSpecialComp.get((int)(this._indexSortedSpecial - 1)).getPreferredSize().width;
            }
        }
        if (this._sortedSpecialComp.size() == 0) {
            return 0;
        }
        if (this._indexSortedSpecial - 1 >= 0) {
            int currWidth = this._sortedSpecialComp.get((int)(this._indexSortedSpecial - 1)).getPreferredSize().width;
            if (this._cellWidth - currWidth > 5) {
                this._cellWidth -= 5;
            } else {
                --this._indexSortedSpecial;
                this._cellWidth = currWidth;
            }
        } else {
            this._relativeWidth *= 0.95;
        }
        Font font = this._sortedSpecialComp.get(this._indexSortedSpecial).getFont();
        int fontWidth = 0;
        if (font != null) {
            fontWidth = 3 * FontUtils.getAverageWidth(font);
        }
        return this._cellWidth + fontWidth;
    }

    private class ButtonWidthComparator
    implements Comparator {
        private ButtonWidthComparator() {
        }

        public int compare(Object o1, Object o2) {
            Component c1 = (Component)o1;
            Component c2 = (Component)o2;
            return c1.getPreferredSize().width - c2.getPreferredSize().width;
        }
    }
}

